/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import convex.api.Convex;
import convex.cli.CLIError;
import convex.cli.Main;
import convex.core.Result;
import convex.core.data.ACell;
import convex.core.data.Address;
import convex.core.lang.Reader;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="query", mixinStandardHelpOptions=true, description={"Execute a user query via the current peer. The query can be any valid Convex Lisp form."})
public class Query
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(Query.class);
    @CommandLine.ParentCommand
    protected Main mainParent;
    @CommandLine.Option(names={"--port"}, description={"Port number to connect to a peer."})
    private int port = 0;
    @CommandLine.Option(names={"--host"}, defaultValue="localhost", description={"Hostname to connect to a peer. Default: ${DEFAULT-VALUE}"})
    private String hostname;
    @CommandLine.Option(names={"-t", "--timeout"}, description={"Timeout in miliseconds."})
    private long timeout = 5000L;
    @CommandLine.Option(names={"-a", "--address"}, description={"Address to make the query from. Default: First peer address."})
    private long address = 11L;
    @CommandLine.Parameters(paramLabel="queryCommand", description={"Query Command"})
    private String queryCommand;

    @Override
    public void run() {
        log.info("query command: {}", (Object)this.queryCommand);
        Convex convex = null;
        convex = this.mainParent.connectToSessionPeer(this.hostname, this.port, Address.create(this.address), null);
        try {
            log.info("Executing query: %s\n", (Object)this.queryCommand);
            Object message = Reader.read(this.queryCommand);
            Result result = convex.querySync((ACell)message, this.timeout);
            this.mainParent.printResult(result);
        }
        catch (IOException | TimeoutException e) {
            throw new CLIError("Error executing query", e);
        }
    }
}

