/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;
import org.jdesktop.swingx.multislider.DefaultMultiThumbModel;
import org.jdesktop.swingx.multislider.MultiThumbModel;
import org.jdesktop.swingx.multislider.ThumbDataEvent;
import org.jdesktop.swingx.multislider.ThumbDataListener;
import org.jdesktop.swingx.multislider.ThumbListener;
import org.jdesktop.swingx.multislider.ThumbRenderer;
import org.jdesktop.swingx.multislider.TrackRenderer;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.MultiThumbSliderAddon;
import org.jdesktop.swingx.plaf.MultiThumbSliderUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXMultiThumbSlider<E>
extends JComponent {
    public static final String uiClassID = "MultiThumbSliderUI";
    private ThumbDataListener tdl;
    private List<ThumbComp> thumbs;
    private ThumbRenderer thumbRenderer;
    private TrackRenderer trackRenderer;
    private MultiThumbModel<E> model;
    private List<ThumbListener> listeners = new ArrayList<ThumbListener>();
    private ThumbComp selected;

    public JXMultiThumbSlider() {
        this.thumbs = new ArrayList<ThumbComp>();
        this.setLayout(null);
        this.tdl = new ThumbHandler();
        this.setModel(new DefaultMultiThumbModel());
        MultiThumbMouseListener mia = new MultiThumbMouseListener();
        this.addMouseListener(mia);
        this.addMouseMotionListener(mia);
        Dimension dim = new Dimension(60, 16);
        this.setPreferredSize(dim);
        this.setSize(dim);
        this.setMinimumSize(new Dimension(30, 16));
        this.updateUI();
    }

    @Override
    public MultiThumbSliderUI getUI() {
        return (MultiThumbSliderUI)this.ui;
    }

    public void setUI(MultiThumbSliderUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI((MultiThumbSliderUI)LookAndFeelAddons.getUI(this, MultiThumbSliderUI.class));
        this.invalidate();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isVisible()) {
            if (this.trackRenderer != null) {
                JComponent comp = this.trackRenderer.getRendererComponent(this);
                this.add(comp);
                comp.paint(g);
                this.remove(comp);
            } else {
                this.paintRange((Graphics2D)g);
            }
        }
    }

    private void paintRange(Graphics2D g) {
        g.setColor(Color.blue);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    private float getThumbValue(int thumbIndex) {
        return this.getModel().getThumbAt(thumbIndex).getPosition();
    }

    private float getThumbValue(ThumbComp thumb) {
        return this.getThumbValue(this.thumbs.indexOf(thumb));
    }

    private int getThumbIndex(ThumbComp thumb) {
        return this.thumbs.indexOf(thumb);
    }

    private void clipThumbPosition(ThumbComp thumb) {
        if (this.getThumbValue(thumb) < this.getModel().getMinimumValue()) {
            this.getModel().getThumbAt(this.getThumbIndex(thumb)).setPosition(this.getModel().getMinimumValue());
        }
        if (this.getThumbValue(thumb) > this.getModel().getMaximumValue()) {
            this.getModel().getThumbAt(this.getThumbIndex(thumb)).setPosition(this.getModel().getMaximumValue());
        }
    }

    public ThumbRenderer getThumbRenderer() {
        return this.thumbRenderer;
    }

    public void setThumbRenderer(ThumbRenderer thumbRenderer) {
        this.thumbRenderer = thumbRenderer;
    }

    public TrackRenderer getTrackRenderer() {
        return this.trackRenderer;
    }

    public void setTrackRenderer(TrackRenderer trackRenderer) {
        this.trackRenderer = trackRenderer;
    }

    public float getMinimumValue() {
        return this.getModel().getMinimumValue();
    }

    public void setMinimumValue(float minimumValue) {
        this.getModel().setMinimumValue(minimumValue);
    }

    public float getMaximumValue() {
        return this.getModel().getMaximumValue();
    }

    public void setMaximumValue(float maximumValue) {
        this.getModel().setMaximumValue(maximumValue);
    }

    private void setThumbPositionByX(ThumbComp selected) {
        float range = this.getModel().getMaximumValue() - this.getModel().getMinimumValue();
        int x = selected.getX();
        x += selected.getWidth() / 2;
        int w = this.getWidth();
        float delta = (float)(x -= selected.getWidth() / 2) / (float)(w -= selected.getWidth());
        int thumb_index = this.getThumbIndex(selected);
        float value = delta * range;
        this.getModel().getThumbAt(thumb_index).setPosition(value);
        this.clipThumbPosition(selected);
    }

    private void setThumbXByPosition(ThumbComp thumb, float pos) {
        float lp = this.getWidth() - thumb.getWidth();
        float lu = this.getModel().getMaximumValue() - this.getModel().getMinimumValue();
        float tp = pos * lp / lu;
        thumb.setLocation((int)tp - thumb.getWidth() / 2 + thumb.getWidth() / 2, thumb.getY());
    }

    private void recalc() {
        for (ThumbComp th : this.thumbs) {
            this.setThumbXByPosition(th, this.getModel().getThumbAt(this.getThumbIndex(th)).getPosition());
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.recalc();
    }

    public JComponent getSelectedThumb() {
        return this.selected;
    }

    public int getSelectedIndex() {
        return this.getThumbIndex(this.selected);
    }

    public MultiThumbModel<E> getModel() {
        return this.model;
    }

    public void setModel(MultiThumbModel<E> model) {
        if (this.model != null) {
            this.model.removeThumbDataListener(this.tdl);
        }
        this.model = model;
        this.model.addThumbDataListener(this.tdl);
    }

    public void addMultiThumbListener(ThumbListener listener) {
        this.listeners.add(listener);
    }

    static {
        LookAndFeelAddons.contribute(new MultiThumbSliderAddon());
    }

    private class ThumbHandler
    implements ThumbDataListener {
        private ThumbHandler() {
        }

        public void positionChanged(ThumbDataEvent e) {
            ThumbComp comp = (ThumbComp)JXMultiThumbSlider.this.thumbs.get(e.getIndex());
            JXMultiThumbSlider.this.clipThumbPosition(comp);
            JXMultiThumbSlider.this.setThumbXByPosition(comp, e.getThumb().getPosition());
            JXMultiThumbSlider.this.repaint();
        }

        public void thumbAdded(ThumbDataEvent evt) {
            ThumbComp thumb = new ThumbComp(JXMultiThumbSlider.this);
            thumb.setLocation(0, 0);
            JXMultiThumbSlider.this.add(thumb);
            JXMultiThumbSlider.this.thumbs.add(evt.getIndex(), thumb);
            JXMultiThumbSlider.this.clipThumbPosition(thumb);
            JXMultiThumbSlider.this.setThumbXByPosition(thumb, evt.getThumb().getPosition());
            JXMultiThumbSlider.this.repaint();
        }

        public void thumbRemoved(ThumbDataEvent evt) {
            ThumbComp thumb = (ThumbComp)JXMultiThumbSlider.this.thumbs.get(evt.getIndex());
            JXMultiThumbSlider.this.remove(thumb);
            JXMultiThumbSlider.this.thumbs.remove(thumb);
            JXMultiThumbSlider.this.repaint();
        }

        public void valueChanged(ThumbDataEvent e) {
            JXMultiThumbSlider.this.repaint();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThumbComp
    extends JComponent {
        private JXMultiThumbSlider<?> slider;
        private boolean selected;

        public ThumbComp(JXMultiThumbSlider<?> slider) {
            this.slider = slider;
            Dimension dim = new Dimension(10, 10);
            this.setSize(dim);
            this.setMinimumSize(dim);
            this.setPreferredSize(dim);
            this.setMaximumSize(dim);
            this.setBackground(Color.white);
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.slider.getThumbRenderer() != null) {
                JComponent comp = this.getRenderer();
                comp.setSize(this.getSize());
                comp.paint(g);
            } else {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (this.isSelected()) {
                    g.setColor(Color.black);
                    g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                }
            }
        }

        private JComponent getRenderer() {
            return this.slider.getThumbRenderer().getThumbRendererComponent(this.slider, ((JXMultiThumbSlider)this.slider).getThumbIndex(this), this.isSelected());
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }

    private class MultiThumbMouseListener
    extends MouseInputAdapter {
        private MultiThumbMouseListener() {
        }

        public void mousePressed(MouseEvent evt) {
            ThumbComp handle2 = this.findHandle(evt);
            if (handle2 != null) {
                JXMultiThumbSlider.this.selected = handle2;
                JXMultiThumbSlider.this.selected.setSelected(true);
                int thumb_index = JXMultiThumbSlider.this.getThumbIndex(JXMultiThumbSlider.this.selected);
                for (ThumbListener tl : JXMultiThumbSlider.this.listeners) {
                    tl.thumbSelected(thumb_index);
                }
                JXMultiThumbSlider.this.repaint();
            } else {
                JXMultiThumbSlider.this.selected = null;
                for (ThumbListener tl : JXMultiThumbSlider.this.listeners) {
                    tl.thumbSelected(-1);
                }
                JXMultiThumbSlider.this.repaint();
            }
            for (ThumbListener tl : JXMultiThumbSlider.this.listeners) {
                tl.mousePressed(evt);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            if (JXMultiThumbSlider.this.selected != null) {
                JXMultiThumbSlider.this.selected.setSelected(false);
            }
        }

        public void mouseDragged(MouseEvent evt) {
            if (JXMultiThumbSlider.this.selected != null) {
                int nx = (int)evt.getPoint().getX() - JXMultiThumbSlider.this.selected.getWidth() / 2;
                if (nx < 0) {
                    nx = 0;
                }
                if (nx > JXMultiThumbSlider.this.getWidth() - JXMultiThumbSlider.this.selected.getWidth()) {
                    nx = JXMultiThumbSlider.this.getWidth() - JXMultiThumbSlider.this.selected.getWidth();
                }
                JXMultiThumbSlider.this.selected.setLocation(nx, (int)JXMultiThumbSlider.this.selected.getLocation().getY());
                JXMultiThumbSlider.this.setThumbPositionByX(JXMultiThumbSlider.this.selected);
                int thumb_index = JXMultiThumbSlider.this.getThumbIndex(JXMultiThumbSlider.this.selected);
                for (ThumbListener mtl : JXMultiThumbSlider.this.listeners) {
                    mtl.thumbMoved(thumb_index, JXMultiThumbSlider.this.getModel().getThumbAt(thumb_index).getPosition());
                }
                JXMultiThumbSlider.this.repaint();
            }
        }

        private ThumbComp findHandle(MouseEvent evt) {
            for (ThumbComp hand : JXMultiThumbSlider.this.thumbs) {
                Point p2 = new Point();
                p2.setLocation(evt.getPoint().getX() - (double)hand.getX(), evt.getPoint().getY() - (double)hand.getY());
                if (!hand.contains(p2)) continue;
                return hand;
            }
            return null;
        }
    }
}

