/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.themes;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import mdlaf.components.menu.MaterialMenuArrowIcon;
import mdlaf.themes.MaterialTheme;
import mdlaf.utils.MaterialBorders;
import mdlaf.utils.MaterialColors;
import mdlaf.utils.MaterialFontFactory;
import mdlaf.utils.MaterialImageFactory;
import mdlaf.utils.icons.IMaterialIconCode;
import mdlaf.utils.icons.MaterialIconFont;

public abstract class AbstractMaterialTheme
implements MaterialTheme {
    protected ColorUIResource backgroundPrimary;
    protected ColorUIResource highlightBackgroundPrimary;
    protected ColorUIResource textColor;
    protected ColorUIResource disableTextColor;
    protected ColorUIResource buttonBackgroundColor;
    protected ColorUIResource buttonTextColor;
    protected ColorUIResource buttonBackgroundColorMouseHover;
    protected ColorUIResource buttonDefaultBackgroundColor;
    protected ColorUIResource buttonDefaultTextColor;
    protected ColorUIResource buttonDefaultBackgroundColorMouseHover;
    protected ColorUIResource buttonDisabledBackground;
    protected ColorUIResource buttonDisabledForeground;
    protected ColorUIResource buttonFocusColor;
    protected ColorUIResource buttonDefaultFocusColor;
    protected ColorUIResource buttonBorderColor;
    protected ColorUIResource buttonColorHighlight;
    protected BorderUIResource buttonBorder;
    protected IconUIResource unselectedIconToggleButton;
    protected IconUIResource selectedIconToggleButton;
    protected IconUIResource disabledUnselectedIconToggleButton;
    protected IconUIResource disabledSelectedIconToggleButton;
    protected boolean withoutIconToggleButton = false;
    protected ColorUIResource withoutIconSelectedBackgroundToggleButton;
    protected ColorUIResource withoutIconSelectedForegoundToggleButton;
    protected ColorUIResource withoutIconBackgroundToggleButton;
    protected ColorUIResource withoutIconForegroundToggleButton;
    protected BorderUIResource withoutIconSelectedBorderToggleButton;
    protected BorderUIResource withoutIconBorderToggleButton;
    protected IconUIResource unselectedCheckBoxIcon;
    protected IconUIResource selectedCheckBoxIcon;
    protected IconUIResource disabledUnselectedCheckBoxIcon;
    protected IconUIResource disabledSelectedCheckBoxIcon;
    protected ColorUIResource selectedInDropDownBackgroundComboBox;
    protected ColorUIResource selectedForegroundComboBox;
    protected BorderUIResource borderComboBox;
    protected BorderUIResource borderItemComboBox;
    protected IconUIResource buttonIconComboBox;
    protected IconUIResource buttonSelectIconComboBox;
    protected IconUIResource buttonDisabledIconComboBox;
    protected ColorUIResource menuBackground;
    protected ColorUIResource menuTextColor;
    protected ColorUIResource menuBackgroundMouseHover;
    protected ColorUIResource menuDisableBackground;
    protected BorderUIResource borderMenu;
    protected BorderUIResource borderMenuBar;
    protected IconUIResource unselectedRadioButtonIcon;
    protected IconUIResource selectedRadioButtonIcon;
    protected IconUIResource disabledUnselectedRadioButtonIcon;
    protected IconUIResource disabledSelectedRadioButtonIcon;
    protected BorderUIResource borderPopupMenu;
    protected ColorUIResource arrowButtonBackgroundSpinner;
    protected ColorUIResource mouseHoverButtonColorSpinner;
    protected BorderUIResource borderSpinner;
    protected BorderUIResource arrowButtonBorderSpinner;
    public IconUIResource previousButtonIconSpinner;
    public IconUIResource nextButtonIconSpinner;
    protected BorderUIResource borderPanel;
    protected ColorUIResource trackColorScrollBar;
    protected ColorUIResource thumbColorScrollBar;
    protected ColorUIResource thumbDarkShadowColorScrollBar;
    protected ColorUIResource thumbHighlightColorScrollBar;
    protected ColorUIResource thumbShadowColorScrollBar;
    protected ColorUIResource mouseHoverColorScrollBar;
    protected ColorUIResource arrowButtonColorScrollBar;
    protected ColorUIResource arrowButtonOnClickColorScrollBar;
    protected BorderUIResource arrowButtonBorderScrollBar;
    protected ColorUIResource trackColorSlider;
    protected ColorUIResource haloColorSlider;
    protected ColorUIResource disabledColorSlider;
    protected BorderUIResource borderSlider;
    protected ColorUIResource highlightColorTabbedPane;
    protected ColorUIResource borderHighlightColorTabbedPane;
    protected ColorUIResource focusColorLineTabbedPane;
    protected ColorUIResource disableColorTabTabbedPane;
    protected InsetsUIResource tabInsetsTabbedPane;
    protected InsetsUIResource selectedTabInsetsTabbedPane;
    protected IconUIResource bottomIconTabbedPane;
    protected IconUIResource disabledBottomIconTabbedPane;
    protected IconUIResource topIconTabbedPane;
    protected IconUIResource leftIconTabbedPane;
    protected IconUIResource rightIconTabbedPane;
    protected IconUIResource disabledTopIconTabbedPane;
    protected IconUIResource disabledLeftIconTabbedPane;
    protected IconUIResource disabledRightIconTabbedPane;
    protected ColorUIResource colorIconTabbedPane;
    protected ColorUIResource colorDisabledIconTabbedPane;
    protected ColorUIResource backgroundTable;
    protected ColorUIResource backgroundTableHeader;
    protected ColorUIResource foregroundTable;
    protected ColorUIResource foregroundTableHeader;
    protected ColorUIResource selectionBackgroundTable;
    protected ColorUIResource selectionForegroundTable;
    protected ColorUIResource gridColorTable;
    protected ColorUIResource alternateRowBackgroundTable;
    protected BorderUIResource borderTable;
    protected BorderUIResource borderTableHeader;
    protected BorderUIResource cellBorderTableHeader;
    protected IconUIResource unselectedCheckBoxIconTable;
    protected IconUIResource selectedCheckBoxIconTable;
    protected IconUIResource unselectedCheckBoxIconSelectionRowTable;
    protected IconUIResource selectedCheckBoxIconSelectionRowTable;
    protected ColorUIResource dockingBackgroundToolBar;
    protected ColorUIResource floatingBackgroundToolBar;
    protected BorderUIResource borderToolBar;
    protected ColorUIResource selectionForegroundTree;
    protected ColorUIResource selectionBackgroundTree;
    protected ColorUIResource selectionBorderColorTree;
    protected IconUIResource closedIconTree;
    protected IconUIResource openIconTree;
    protected IconUIResource leafIconTree;
    protected BorderUIResource borderTree;
    protected ColorUIResource backgroundTextField;
    protected ColorUIResource inactiveForegroundTextField;
    protected ColorUIResource inactiveBackgroundTextField;
    protected ColorUIResource selectionBackgroundTextField;
    protected ColorUIResource selectionForegroundTextField;
    protected ColorUIResource disabledBackgroudnTextField;
    protected ColorUIResource disabledForegroundTextField;
    protected ColorUIResource inactiveColorLineTextField;
    protected ColorUIResource activeColorLineTextField;
    protected BorderUIResource borderTextField;
    protected ColorUIResource titleBackgroundGradientStartTaskPane;
    protected ColorUIResource titleBackgroundGradientEndTaskPane;
    protected ColorUIResource titleColorTaskPane;
    protected ColorUIResource titleOverTaskPane;
    protected ColorUIResource specialTitleOverTaskPane;
    protected ColorUIResource backgroundTaskPane;
    protected ColorUIResource borderColorTaskPane;
    protected ColorUIResource contentBackgroundTaskPane;
    protected BorderUIResource borderTaskPane;
    protected IconUIResource yesCollapsedTaskPane;
    protected IconUIResource noCollapsedTaskPane;
    protected int archTaskPane;
    protected ColorUIResource selectionBackgroundList;
    protected ColorUIResource selectionForegroundList;
    protected BorderUIResource focusCellHighlightBorder;
    protected BorderUIResource borderItemList;
    protected BorderUIResource borderList;
    protected BorderUIResource borderFrameRootPane;
    protected BorderUIResource borderDialogRootPane;
    protected ColorUIResource backgroundOptionPane;
    protected IconUIResource warningIconOptionPane;
    protected IconUIResource errorIconIconOptionPane;
    protected IconUIResource questionIconOptionPane;
    protected IconUIResource informationIconOptionPane;
    protected ColorUIResource colorDividierSplitPane;
    protected ColorUIResource colorDividierFocusSplitPane;
    protected int sizeDividierSplitPane = 5;
    protected BorderUIResource dividierBorderSplitPane;
    protected IconUIResource iconComputerFileChooser;
    protected IconUIResource iconDirectoryFileChooser;
    protected IconUIResource iconFileFileChooser;
    protected IconUIResource iconFloppyDriveFileChooser;
    protected IconUIResource iconHardDriveFileChooser;
    protected IconUIResource iconHomeFileChooser;
    protected IconUIResource iconListFileChooser;
    protected IconUIResource iconDetailsFileChooser;
    protected IconUIResource iconNewFolderFileChooser;
    protected IconUIResource iconUpFolderFileChooser;
    protected ColorUIResource backgroundProgressBar;
    protected ColorUIResource foregroundProgressBar;
    protected BorderUIResource borderProgressBar;
    protected ColorUIResource colorTextTitledBorder;
    protected BorderUIResource borderTitledBorder;
    protected IconUIResource iconCloseTitlePane;
    protected FontUIResource fontBold;
    protected FontUIResource fontItalic;
    protected FontUIResource fontRegular;
    protected FontUIResource fontMedium;
    protected ColorUIResource backgroundSeparator;
    protected ColorUIResource foregroundSeparator;
    protected ColorUIResource backgroundToolTip;
    protected ColorUIResource foregroundToolTip;
    protected BorderUIResource borderToolTip;

    @Override
    public void installTheme() {
        this.installColor();
        this.installDefaultColor();
        this.installFonts();
        this.installBorders();
        this.installIcons();
    }

    @Override
    public void installUIDefault(UIDefaults table) {
    }

    protected abstract void installColor();

    protected void installDefaultColor() {
        this.colorIconTabbedPane = this.textColor;
        this.colorDisabledIconTabbedPane = this.disableTextColor;
        this.borderColorTaskPane = this.backgroundTaskPane = this.backgroundPrimary;
        this.contentBackgroundTaskPane = this.backgroundPrimary;
        this.withoutIconSelectedBackgroundToggleButton = this.buttonBackgroundColorMouseHover;
        this.withoutIconBackgroundToggleButton = this.buttonBackgroundColor;
        this.colorTextTitledBorder = this.textColor;
        this.arrowButtonBackgroundSpinner = this.backgroundTextField;
        this.selectionBackgroundTree = this.backgroundPrimary;
        this.selectionBorderColorTree = this.backgroundPrimary;
        this.foregroundTable = this.textColor;
        this.foregroundTableHeader = this.textColor;
        this.selectionForegroundTable = this.textColor;
        this.arrowButtonColorScrollBar = this.buttonBackgroundColor;
        this.thumbDarkShadowColorScrollBar = this.thumbColorScrollBar;
        this.thumbHighlightColorScrollBar = this.thumbColorScrollBar;
        this.thumbShadowColorScrollBar = this.thumbColorScrollBar;
        this.arrowButtonOnClickColorScrollBar = this.buttonBackgroundColorMouseHover;
        this.mouseHoverColorScrollBar = this.thumbColorScrollBar;
        this.menuTextColor = this.textColor;
        this.menuDisableBackground = MaterialColors.TRANSPANENT;
        this.buttonDisabledForeground = this.disableTextColor;
        this.buttonDefaultTextColor = this.textColor;
        this.buttonTextColor = this.textColor;
        this.foregroundToolTip = this.textColor;
        this.disabledColorSlider = this.buttonDisabledBackground;
        this.dockingBackgroundToolBar = this.backgroundPrimary;
        this.floatingBackgroundToolBar = this.textColor;
    }

    protected void installFonts() {
        this.fontBold = MaterialFontFactory.getInstance().getFont(MaterialFontFactory.BOLD);
        this.fontItalic = MaterialFontFactory.getInstance().getFont(MaterialFontFactory.ITALIC);
        this.fontMedium = MaterialFontFactory.getInstance().getFont(MaterialFontFactory.MEDIUM);
        this.fontRegular = MaterialFontFactory.getInstance().getFont(MaterialFontFactory.REGULAR);
    }

    protected void installIcons() {
        this.iconComputerFileChooser = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.COMPUTER, this.textColor);
        this.iconDirectoryFileChooser = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.FOLDER, this.textColor);
        this.iconFileFileChooser = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.INSERT_DRIVE_FILE, this.textColor);
        this.iconFloppyDriveFileChooser = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.SAVE, this.textColor);
        this.iconHardDriveFileChooser = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.STORAGE, this.textColor);
        this.iconHomeFileChooser = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.HOME, this.textColor);
        this.iconListFileChooser = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.MENU, this.textColor);
        this.iconDetailsFileChooser = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.VIEW_MODULE, this.textColor);
        this.iconNewFolderFileChooser = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.CREATE_NEW_FOLDER, this.textColor);
        this.iconUpFolderFileChooser = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.ARROW_BACK, this.textColor);
        this.iconCloseTitlePane = MaterialImageFactory.getInstance().getImage(MaterialIconFont.CLOSE, 25, this.textColor);
        this.previousButtonIconSpinner = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.ARROW_DROP_DOWN, this.textColor);
        this.nextButtonIconSpinner = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.ARROW_DROP_UP, this.textColor);
        this.selectedCheckBoxIcon = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.CHECK_BOX, this.highlightBackgroundPrimary);
        this.unselectedCheckBoxIcon = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.CHECK_BOX_OUTLINE_BLANK, this.textColor);
        this.disabledUnselectedCheckBoxIcon = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.CHECK_BOX_OUTLINE_BLANK, this.disableTextColor);
        this.disabledSelectedCheckBoxIcon = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.CHECK_BOX, this.disableTextColor);
        this.selectedCheckBoxIconSelectionRowTable = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.CHECK_BOX, this.highlightBackgroundPrimary);
        this.unselectedCheckBoxIconSelectionRowTable = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.CHECK_BOX_OUTLINE_BLANK, this.highlightBackgroundPrimary);
        this.selectedCheckBoxIconTable = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.CHECK_BOX, this.highlightBackgroundPrimary);
        this.unselectedCheckBoxIconTable = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.CHECK_BOX_OUTLINE_BLANK, this.highlightBackgroundPrimary);
        this.closedIconTree = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.KEYBOARD_ARROW_RIGHT, this.textColor);
        this.openIconTree = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.KEYBOARD_ARROW_DOWN, this.highlightBackgroundPrimary);
        this.noCollapsedTaskPane = MaterialImageFactory.getInstance().getImage(MaterialIconFont.KEYBOARD_ARROW_RIGHT);
        this.yesCollapsedTaskPane = MaterialImageFactory.getInstance().getImage(MaterialIconFont.KEYBOARD_ARROW_DOWN);
        this.warningIconOptionPane = MaterialImageFactory.getInstance().getImage("warning");
        this.errorIconIconOptionPane = MaterialImageFactory.getInstance().getImage("error");
        this.questionIconOptionPane = MaterialImageFactory.getInstance().getImage("question");
        this.informationIconOptionPane = MaterialImageFactory.getInstance().getImage("information");
        this.leafIconTree = MaterialImageFactory.getInstance().getImage("blank");
        this.unselectedIconToggleButton = MaterialImageFactory.getInstance().getImage(MaterialIconFont.TOGGLE_OFF, 26, this.textColor);
        this.selectedIconToggleButton = MaterialImageFactory.getInstance().getImage(MaterialIconFont.TOGGLE_ON, 26, this.highlightBackgroundPrimary);
        this.disabledUnselectedIconToggleButton = MaterialImageFactory.getInstance().getImage(MaterialIconFont.TOGGLE_OFF, 26, this.disableTextColor);
        this.disabledSelectedIconToggleButton = MaterialImageFactory.getInstance().getImage(MaterialIconFont.TOGGLE_ON, 26, this.disableTextColor);
        this.selectedRadioButtonIcon = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.RADIO_BUTTON_CHECKED, this.highlightBackgroundPrimary);
        this.unselectedRadioButtonIcon = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.RADIO_BUTTON_UNCHECKED, this.textColor);
        this.disabledSelectedRadioButtonIcon = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.RADIO_BUTTON_CHECKED, this.disableTextColor);
        this.disabledUnselectedRadioButtonIcon = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.RADIO_BUTTON_UNCHECKED, this.disableTextColor);
        this.topIconTabbedPane = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.EXPAND_LESS, this.colorIconTabbedPane);
        this.disabledTopIconTabbedPane = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.EXPAND_LESS, this.colorDisabledIconTabbedPane);
        this.bottomIconTabbedPane = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.EXPAND_MORE, this.colorIconTabbedPane);
        this.disabledBottomIconTabbedPane = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.EXPAND_MORE, this.colorDisabledIconTabbedPane);
        this.leftIconTabbedPane = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.CHEVRON_LEFT, this.colorIconTabbedPane);
        this.disabledLeftIconTabbedPane = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.CHEVRON_LEFT, this.colorDisabledIconTabbedPane);
        this.rightIconTabbedPane = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.CHEVRON_RIGHT, this.colorIconTabbedPane);
        this.disabledRightIconTabbedPane = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.CHEVRON_RIGHT, this.colorDisabledIconTabbedPane);
        this.buttonIconComboBox = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.KEYBOARD_ARROW_DOWN, this.textColor);
        this.buttonSelectIconComboBox = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.KEYBOARD_ARROW_UP, this.textColor);
        this.buttonDisabledIconComboBox = MaterialImageFactory.getInstance().getImage((IMaterialIconCode)MaterialIconFont.KEYBOARD_ARROW_DOWN, this.disableTextColor);
    }

    protected void installBorders() {
        this.buttonBorder = new BorderUIResource(BorderFactory.createEmptyBorder(8, 12, 8, 12));
        this.borderMenu = new BorderUIResource(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.borderMenuBar = MaterialBorders.LIGHT_SHADOW_BORDER;
        this.borderPopupMenu = MaterialBorders.LIGHT_LINE_BORDER;
        this.borderSpinner = new BorderUIResource(BorderFactory.createLineBorder(this.backgroundTextField));
        this.arrowButtonBorderSpinner = new BorderUIResource(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.arrowButtonBackgroundSpinner), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.borderPanel = new BorderUIResource(BorderFactory.createEmptyBorder());
        this.arrowButtonBorderScrollBar = new BorderUIResource(BorderFactory.createEmptyBorder());
        this.borderSlider = new BorderUIResource(BorderFactory.createCompoundBorder(MaterialBorders.LIGHT_LINE_BORDER, BorderFactory.createEmptyBorder(15, 15, 15, 15)));
        this.cellBorderTableHeader = new BorderUIResource(BorderFactory.createCompoundBorder(MaterialBorders.LIGHT_LINE_BORDER, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.borderToolBar = MaterialBorders.LIGHT_SHADOW_BORDER;
        this.borderTextField = new BorderUIResource(BorderFactory.createEmptyBorder(2, 2, 1, 2));
        this.borderTaskPane = new BorderUIResource(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        this.focusCellHighlightBorder = new BorderUIResource(BorderFactory.createEmptyBorder());
        this.borderItemList = new BorderUIResource(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        this.tabInsetsTabbedPane = new InsetsUIResource(6, 10, 10, 10);
        this.selectedTabInsetsTabbedPane = new InsetsUIResource(6, 10, 10, 10);
        this.borderFrameRootPane = new BorderUIResource(BorderFactory.createEmptyBorder());
        this.borderDialogRootPane = MaterialBorders.LIGHT_SHADOW_BORDER;
        this.borderProgressBar = MaterialBorders.LIGHT_LINE_BORDER;
        this.withoutIconSelectedBorderToggleButton = new BorderUIResource(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10), BorderFactory.createLineBorder(this.withoutIconSelectedBackgroundToggleButton, 1)));
        this.withoutIconBorderToggleButton = new BorderUIResource(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10), BorderFactory.createLineBorder(this.withoutIconBackgroundToggleButton, 1)));
        this.dividierBorderSplitPane = new BorderUIResource(BorderFactory.createEmptyBorder());
        this.borderTree = new BorderUIResource(BorderFactory.createEmptyBorder(3, 2, 3, 2));
        this.borderComboBox = MaterialBorders.roundedLineColorBorder(this.textColor, this.getArchBorderComboBox());
        this.borderItemComboBox = new BorderUIResource(BorderFactory.createLineBorder(this.backgroundPrimary));
        this.borderList = MaterialBorders.DEFAULT_SHADOW_BORDER;
        this.borderToolTip = MaterialBorders.roundedLineColorBorder(this.backgroundToolTip, 4);
    }

    @Override
    public abstract String getName();

    @Override
    public ColorUIResource getBackgroundPrimary() {
        return this.backgroundPrimary;
    }

    @Override
    public ColorUIResource getHighlightBackgroundPrimary() {
        return this.highlightBackgroundPrimary;
    }

    @Override
    public ColorUIResource getTextColor() {
        return this.textColor;
    }

    @Override
    public ColorUIResource getDisableTextColor() {
        return this.disableTextColor;
    }

    @Override
    public ColorUIResource getButtonBackgroundColor() {
        return this.buttonBackgroundColor;
    }

    @Override
    public ColorUIResource getButtonTextColor() {
        return this.buttonTextColor;
    }

    @Override
    public ColorUIResource getButtonBackgroundColorMouseHover() {
        return this.buttonBackgroundColorMouseHover;
    }

    @Override
    public ColorUIResource getButtonDefaultBackgroundColor() {
        return this.buttonDefaultBackgroundColor;
    }

    @Override
    public ColorUIResource getButtonDefaultTextColor() {
        return this.buttonDefaultTextColor;
    }

    @Override
    public ColorUIResource getButtonDefaultBackgroundColorMouseHover() {
        return this.buttonDefaultBackgroundColorMouseHover;
    }

    @Override
    public ColorUIResource getButtonDisabledBackground() {
        return this.buttonDisabledBackground;
    }

    @Override
    public ColorUIResource getButtonDisabledForeground() {
        return this.buttonDisabledForeground;
    }

    @Override
    public ColorUIResource getButtonDisableTextColor() {
        return this.getDisableTextColor();
    }

    @Override
    public ColorUIResource getButtonFocusColor() {
        return this.buttonFocusColor;
    }

    @Override
    public ColorUIResource getButtonDefaultFocusColor() {
        return this.buttonDefaultFocusColor;
    }

    @Override
    public ColorUIResource getButtonBorderColor() {
        return this.buttonBorderColor;
    }

    @Override
    public ColorUIResource getButtonColorHighlight() {
        return this.buttonColorHighlight;
    }

    @Override
    public BorderUIResource getButtonBorder() {
        return this.buttonBorder;
    }

    @Override
    public FontUIResource getButtonFont() {
        return this.getFontBold();
    }

    @Override
    public boolean getMouseHoverButtonEnable() {
        return true;
    }

    @Override
    public boolean getButtonFocusable() {
        return true;
    }

    @Override
    public boolean getButtonBorderEnable() {
        return true;
    }

    @Override
    public boolean getButtonBorderEnableToAll() {
        return false;
    }

    @Override
    public int getArcButton() {
        return 0;
    }

    @Override
    public boolean getOpaqueButton() {
        return false;
    }

    @Override
    public ColorUIResource getBackgroundSeparator() {
        return this.backgroundSeparator;
    }

    @Override
    public ColorUIResource getForegroundSeparator() {
        return this.foregroundSeparator;
    }

    @Override
    public ColorUIResource getBackgroundToolTip() {
        return this.backgroundToolTip;
    }

    @Override
    public ColorUIResource getForegroundToolTip() {
        return this.foregroundToolTip;
    }

    @Override
    public BorderUIResource getBorderToolTip() {
        return this.borderToolTip;
    }

    @Override
    public IconUIResource getUnselectedCheckBoxIcon() {
        return this.unselectedCheckBoxIcon;
    }

    @Override
    public IconUIResource getSelectedCheckBoxIcon() {
        return this.selectedCheckBoxIcon;
    }

    @Override
    public IconUIResource getDisabledUnselectedCheckBoxIcon() {
        return this.disabledUnselectedCheckBoxIcon;
    }

    @Override
    public IconUIResource getDisabledSelectedCheckBoxIcon() {
        return this.disabledSelectedCheckBoxIcon;
    }

    @Override
    public ColorUIResource getSelectedInDropDownBackgroundComboBox() {
        return this.selectedInDropDownBackgroundComboBox;
    }

    @Override
    public ColorUIResource getSelectedForegroundComboBox() {
        return this.selectedForegroundComboBox;
    }

    @Override
    public BorderUIResource getBorderComboBox() {
        return this.borderComboBox;
    }

    @Override
    public BorderUIResource getBorderItemComboBox() {
        return this.borderItemComboBox;
    }

    @Override
    public IconUIResource getButtonIconComboBox() {
        return this.buttonIconComboBox;
    }

    @Override
    public IconUIResource getButtonSelectIconComboBox() {
        return this.buttonSelectIconComboBox;
    }

    @Override
    public IconUIResource getButtonDisabledIconComboBox() {
        return this.buttonDisabledIconComboBox;
    }

    @Override
    public void setButtonDisabledIconComboBox(IconUIResource buttonDisabledIconComboBox) {
        this.buttonDisabledIconComboBox = buttonDisabledIconComboBox;
    }

    @Override
    public boolean getMouseHoverEnableComboBox() {
        return false;
    }

    @Override
    public boolean getLightWeightPopupEnabledComboBox() {
        return true;
    }

    @Override
    public boolean getFocusableComboBox() {
        return true;
    }

    @Override
    public int getArchBorderComboBox() {
        return 0;
    }

    @Override
    public ColorUIResource getMenuBackground() {
        return this.menuBackground;
    }

    @Override
    public ColorUIResource getMenuTextColor() {
        return this.menuTextColor;
    }

    @Override
    public ColorUIResource getMenuBackgroundMouseHover() {
        return this.menuBackgroundMouseHover;
    }

    @Override
    public ColorUIResource getMenuDisableBackground() {
        return this.menuDisableBackground;
    }

    @Override
    public BorderUIResource getBorderMenu() {
        return this.borderMenu;
    }

    @Override
    public BorderUIResource getBorderMenuBar() {
        return this.borderMenuBar;
    }

    @Override
    public Icon getMenuArrowIcon() {
        return new MaterialMenuArrowIcon();
    }

    @Override
    public ColorUIResource getMenuArrowHoverColor() {
        return this.textColor;
    }

    @Override
    public int getMenuArrowHeight() {
        return 8;
    }

    @Override
    public int getMenuArrowWidth() {
        return 4;
    }

    @Override
    public boolean getMouseHoverEnableMenu() {
        return true;
    }

    @Override
    public IconUIResource getUnselectedRadioButtonIcon() {
        return this.unselectedRadioButtonIcon;
    }

    @Override
    public IconUIResource getSelectedRadioButtonIcon() {
        return this.selectedRadioButtonIcon;
    }

    @Override
    public IconUIResource getDisabledUnselectedRadioButtonIcon() {
        return this.disabledUnselectedRadioButtonIcon;
    }

    @Override
    public IconUIResource getDisabledSelectedRadioButtonIcon() {
        return this.disabledSelectedRadioButtonIcon;
    }

    @Override
    public BorderUIResource getBorderPopupMenu() {
        return this.borderPopupMenu;
    }

    @Override
    public ColorUIResource getArrowButtonBackgroundSpinner() {
        return this.arrowButtonBackgroundSpinner;
    }

    @Override
    public ColorUIResource getMouseHoverButtonColorSpinner() {
        return this.mouseHoverButtonColorSpinner;
    }

    @Override
    public BorderUIResource getBorderSpinner() {
        return this.borderSpinner;
    }

    @Override
    public BorderUIResource getArrowButtonBorderSpinner() {
        return this.arrowButtonBorderSpinner;
    }

    @Override
    public IconUIResource getPreviousButtonIconSpinner() {
        return this.previousButtonIconSpinner;
    }

    @Override
    public IconUIResource getNextButtonIconSpinner() {
        return this.nextButtonIconSpinner;
    }

    @Override
    public boolean getMouseHoverEnableSpinner() {
        return true;
    }

    @Override
    public BorderUIResource getBorderPanel() {
        return this.borderPanel;
    }

    @Override
    public ColorUIResource getTrackColorScrollBar() {
        return this.trackColorScrollBar;
    }

    @Override
    public ColorUIResource getThumbColorScrollBar() {
        return this.thumbColorScrollBar;
    }

    @Override
    public ColorUIResource getThumbDarkShadowColorScrollBar() {
        return this.thumbDarkShadowColorScrollBar;
    }

    @Override
    public ColorUIResource getThumbHighlightColorScrollBar() {
        return this.thumbHighlightColorScrollBar;
    }

    @Override
    public ColorUIResource getThumbShadowColorScrollBar() {
        return this.thumbShadowColorScrollBar;
    }

    @Override
    public ColorUIResource getMouseHoverColorScrollBar() {
        return this.mouseHoverColorScrollBar;
    }

    @Override
    public ColorUIResource getArrowButtonColorScrollBar() {
        return this.arrowButtonColorScrollBar;
    }

    @Override
    public ColorUIResource getArrowButtonOnClickColorScrollBar() {
        return this.arrowButtonOnClickColorScrollBar;
    }

    @Override
    public BorderUIResource getArrowButtonBorderScrollBar() {
        return this.arrowButtonBorderScrollBar;
    }

    @Override
    public boolean getMouseHoverEnableScrollBar() {
        return true;
    }

    @Override
    public boolean getEnableArrowScrollBar() {
        return false;
    }

    @Override
    public ColorUIResource getTrackColorSlider() {
        return this.trackColorSlider;
    }

    @Override
    public ColorUIResource getHaloColorSlider() {
        return this.haloColorSlider;
    }

    @Override
    public ColorUIResource getDisabledColorSlider() {
        return this.disabledColorSlider;
    }

    @Override
    public BorderUIResource getBorderSlider() {
        return this.borderSlider;
    }

    @Override
    public ColorUIResource getHighlightColorTabbedPane() {
        return this.highlightColorTabbedPane;
    }

    @Override
    public ColorUIResource getBorderHighlightColorTabbedPane() {
        return this.borderHighlightColorTabbedPane;
    }

    @Override
    public ColorUIResource getFocusColorLineTabbedPane() {
        return this.focusColorLineTabbedPane;
    }

    @Override
    public ColorUIResource getDisableColorTabTabbedPane() {
        return this.disableColorTabTabbedPane;
    }

    @Override
    public InsetsUIResource getTabInsetsTabbedPane() {
        return this.tabInsetsTabbedPane;
    }

    @Override
    public InsetsUIResource getSelectedTabInsetsTabbedPane() {
        return this.selectedTabInsetsTabbedPane;
    }

    @Override
    public IconUIResource getDisabledBottomIconTabbedPane() {
        return this.disabledBottomIconTabbedPane;
    }

    @Override
    public IconUIResource getDisabledTopIconTabbedPane() {
        return this.disabledTopIconTabbedPane;
    }

    @Override
    public IconUIResource getDisabledLeftIconTabbedPane() {
        return this.disabledLeftIconTabbedPane;
    }

    @Override
    public IconUIResource getDisabledRightIconTabbedPane() {
        return this.disabledRightIconTabbedPane;
    }

    @Override
    public IconUIResource getBottomIconTabbedPane() {
        return this.bottomIconTabbedPane;
    }

    @Override
    public IconUIResource getTopIconTabbedPane() {
        return this.topIconTabbedPane;
    }

    @Override
    public IconUIResource getLeftIconTabbedPane() {
        return this.leftIconTabbedPane;
    }

    @Override
    public IconUIResource getRightIconTabbedPane() {
        return this.rightIconTabbedPane;
    }

    @Override
    public ColorUIResource getColorIconTabbedPane() {
        return this.colorIconTabbedPane;
    }

    @Override
    public ColorUIResource getColorDisabledIconTabbedPane() {
        return this.colorDisabledIconTabbedPane;
    }

    @Override
    public int getLinePositionYTabbedPane() {
        return 56;
    }

    @Override
    public int getLinePositionXTabbedPane() {
        return 0;
    }

    @Override
    public int getLineWithTabbedPane() {
        return 5;
    }

    @Override
    public int getLineHeightTabbedPane() {
        return 3;
    }

    @Override
    public int getLineArchTabbedPane() {
        return 0;
    }

    @Override
    public int getIndentTabbedPane() {
        return 4;
    }

    @Override
    public int getSpacerTabbedPane() {
        return 20;
    }

    @Override
    public int getHeightTabTabbedPane() {
        return 18;
    }

    @Override
    public boolean getMouseHoverEnableTabbedPane() {
        return true;
    }

    @Override
    public ColorUIResource getBackgroundTable() {
        return this.backgroundTable;
    }

    @Override
    public ColorUIResource getForegroundTable() {
        return this.foregroundTable;
    }

    @Override
    public ColorUIResource getSelectionBackgroundTable() {
        return this.selectionBackgroundTable;
    }

    @Override
    public ColorUIResource getSelectionForegroundTable() {
        return this.selectionForegroundTable;
    }

    @Override
    public ColorUIResource getGridColorTable() {
        return this.gridColorTable;
    }

    @Override
    public ColorUIResource getAlternateRowBackgroundTable() {
        return this.alternateRowBackgroundTable;
    }

    @Override
    public BorderUIResource getBorderTable() {
        return this.borderTable;
    }

    @Override
    public IconUIResource getUnselectedCheckBoxIconTable() {
        return this.unselectedCheckBoxIconTable;
    }

    @Override
    public IconUIResource getSelectedCheckBoxIconTable() {
        return this.selectedCheckBoxIconTable;
    }

    @Override
    public IconUIResource getUnselectedCheckBoxIconSelectionRowTable() {
        return this.unselectedCheckBoxIconSelectionRowTable;
    }

    @Override
    public IconUIResource getSelectedCheckBoxIconSelectionRowTable() {
        return this.selectedCheckBoxIconSelectionRowTable;
    }

    @Override
    public boolean getTableFocusable() {
        return true;
    }

    @Override
    public boolean getTableOpaque() {
        return false;
    }

    @Override
    public int getHeightRowTable() {
        return 10;
    }

    @Override
    public ColorUIResource getBackgroundTableHeader() {
        return this.backgroundTableHeader;
    }

    @Override
    public ColorUIResource getForegroundTableHeader() {
        return this.foregroundTableHeader;
    }

    @Override
    public BorderUIResource getBorderTableHeader() {
        return this.borderTableHeader;
    }

    @Override
    public BorderUIResource getCellBorderTableHeader() {
        return this.cellBorderTableHeader;
    }

    @Override
    public ColorUIResource getDockingBackgroundToolBar() {
        return this.dockingBackgroundToolBar;
    }

    @Override
    public ColorUIResource getFloatingBackgroundToolBar() {
        return this.floatingBackgroundToolBar;
    }

    @Override
    public BorderUIResource getBorderToolBar() {
        return this.borderToolBar;
    }

    @Override
    public ColorUIResource getBackgroundTextField() {
        return this.backgroundTextField;
    }

    @Override
    public ColorUIResource getInactiveForegroundTextField() {
        return this.inactiveForegroundTextField;
    }

    @Override
    public ColorUIResource getInactiveBackgroundTextField() {
        return this.inactiveBackgroundTextField;
    }

    @Override
    public ColorUIResource getSelectionBackgroundTextField() {
        return this.selectionBackgroundTextField;
    }

    @Override
    public ColorUIResource getSelectionForegroundTextField() {
        return this.selectionForegroundTextField;
    }

    @Override
    public ColorUIResource getDisabledBackgroudnTextField() {
        return this.disabledBackgroudnTextField;
    }

    @Override
    public ColorUIResource getDisabledForegroundTextField() {
        return this.disabledForegroundTextField;
    }

    @Override
    public ColorUIResource getInactiveColorLineTextField() {
        return this.inactiveColorLineTextField;
    }

    @Override
    public ColorUIResource getActiveColorLineTextField() {
        return this.activeColorLineTextField;
    }

    @Override
    public BorderUIResource getBorderTextField() {
        return this.borderTextField;
    }

    @Override
    public char getEchoCharPasswordField() {
        return '\u2022';
    }

    @Override
    public ColorUIResource getSelectionForegroundTree() {
        return this.selectionForegroundTree;
    }

    @Override
    public ColorUIResource getSelectionBackgroundTree() {
        return this.selectionBackgroundTree;
    }

    @Override
    public ColorUIResource getSelectionBorderColorTree() {
        return this.selectionBorderColorTree;
    }

    @Override
    public IconUIResource getClosedIconTree() {
        return this.closedIconTree;
    }

    @Override
    public IconUIResource getOpenIconTree() {
        return this.openIconTree;
    }

    @Override
    public IconUIResource getLeafIconTree() {
        return this.leafIconTree;
    }

    @Override
    public BorderUIResource getBorderTree() {
        return this.borderTree;
    }

    @Override
    public IconUIResource getUnselectedIconToggleButton() {
        return this.unselectedIconToggleButton;
    }

    @Override
    public IconUIResource getSelectedIconToggleButton() {
        return this.selectedIconToggleButton;
    }

    @Override
    public IconUIResource getDisabledUnselectedIconToggleButton() {
        return this.disabledUnselectedIconToggleButton;
    }

    @Override
    public IconUIResource getDisabledSelectedIconToggleButton() {
        return this.disabledSelectedIconToggleButton;
    }

    @Override
    public boolean isWithoutIconToggleButton() {
        return this.withoutIconToggleButton;
    }

    @Override
    public ColorUIResource getWithoutIconSelectedBackgroundToggleButton() {
        return this.withoutIconSelectedBackgroundToggleButton;
    }

    @Override
    public ColorUIResource getWithoutIconSelectedForegoundToggleButton() {
        return this.withoutIconSelectedForegoundToggleButton;
    }

    @Override
    public ColorUIResource getWithoutIconBackgroundToggleButton() {
        return this.withoutIconBackgroundToggleButton;
    }

    @Override
    public ColorUIResource getWithoutIconForegroundToggleButton() {
        return this.withoutIconForegroundToggleButton;
    }

    @Override
    public BorderUIResource getWithoutIconSelectedBorderToggleButton() {
        return this.withoutIconSelectedBorderToggleButton;
    }

    @Override
    public BorderUIResource getWithoutIconBorderToggleButton() {
        return this.withoutIconBorderToggleButton;
    }

    @Override
    public ColorUIResource getTitleBackgroundGradientStartTaskPane() {
        return this.titleBackgroundGradientStartTaskPane;
    }

    @Override
    public ColorUIResource getTitleBackgroundGradientEndTaskPane() {
        return this.titleBackgroundGradientEndTaskPane;
    }

    @Override
    public ColorUIResource getTitleColorTaskPane() {
        return this.titleColorTaskPane;
    }

    @Override
    public ColorUIResource getTitleOverTaskPane() {
        return this.titleOverTaskPane;
    }

    @Override
    public ColorUIResource getSpecialTitleOverTaskPane() {
        return this.specialTitleOverTaskPane;
    }

    @Override
    public ColorUIResource getBackgroundTaskPane() {
        return this.backgroundTaskPane;
    }

    @Override
    public ColorUIResource getBorderColorTaskPane() {
        return this.borderColorTaskPane;
    }

    @Override
    public ColorUIResource getContentBackgroundTaskPane() {
        return this.contentBackgroundTaskPane;
    }

    @Override
    public BorderUIResource getBorderTaskPane() {
        return this.borderTaskPane;
    }

    @Override
    public IconUIResource getYesCollapsedTaskPane() {
        return this.yesCollapsedTaskPane;
    }

    @Override
    public IconUIResource getNoCollapsedTaskPane() {
        return this.noCollapsedTaskPane;
    }

    @Override
    public boolean getMouseHoverEnableTaskPane() {
        return true;
    }

    @Override
    public int getArchTaskPane() {
        return this.archTaskPane;
    }

    @Override
    public ColorUIResource getSelectionBackgroundList() {
        return this.selectionBackgroundList;
    }

    @Override
    public ColorUIResource getSelectionForegroundList() {
        return this.selectionForegroundList;
    }

    @Override
    public BorderUIResource getFocusCellHighlightBorder() {
        return this.focusCellHighlightBorder;
    }

    @Override
    public BorderUIResource getBorderItemList() {
        return this.borderItemList;
    }

    @Override
    public BorderUIResource getBorderList() {
        return this.borderList;
    }

    @Override
    public BorderUIResource getBorderFrameRootPane() {
        return this.borderFrameRootPane;
    }

    @Override
    public BorderUIResource getBorderDialogRootPane() {
        return this.borderDialogRootPane;
    }

    @Override
    public IconUIResource getIconComputerFileChooser() {
        return this.iconComputerFileChooser;
    }

    @Override
    public IconUIResource getIconDirectoryFileChooser() {
        return this.iconDirectoryFileChooser;
    }

    @Override
    public IconUIResource getIconFileFileChooser() {
        return this.iconFileFileChooser;
    }

    @Override
    public IconUIResource getIconFloppyDriveFileChooser() {
        return this.iconFloppyDriveFileChooser;
    }

    @Override
    public IconUIResource getIconHardDriveFileChooser() {
        return this.iconHardDriveFileChooser;
    }

    @Override
    public IconUIResource getIconHomeFileChooser() {
        return this.iconHomeFileChooser;
    }

    @Override
    public IconUIResource getIconListFileChooser() {
        return this.iconListFileChooser;
    }

    @Override
    public IconUIResource getIconDetailsFileChooser() {
        return this.iconDetailsFileChooser;
    }

    @Override
    public IconUIResource getIconNewFolderFileChooser() {
        return this.iconNewFolderFileChooser;
    }

    @Override
    public IconUIResource getIconUpFolderFileChooser() {
        return this.iconUpFolderFileChooser;
    }

    @Override
    public ColorUIResource getBackgroundOptionPane() {
        return this.backgroundOptionPane;
    }

    @Override
    public IconUIResource getWarningIconOptionPane() {
        return this.warningIconOptionPane;
    }

    @Override
    public IconUIResource getErrorIconIconOptionPane() {
        return this.errorIconIconOptionPane;
    }

    @Override
    public IconUIResource getQuestionIconOptionPane() {
        return this.questionIconOptionPane;
    }

    @Override
    public IconUIResource getInformationIconOptionPane() {
        return this.informationIconOptionPane;
    }

    @Override
    public boolean getEnableIconOptionPane() {
        return false;
    }

    @Override
    public ColorUIResource getBackgroundProgressBar() {
        return this.backgroundProgressBar;
    }

    @Override
    public ColorUIResource getForegroundProgressBar() {
        return this.foregroundProgressBar;
    }

    @Override
    public BorderUIResource getBorderProgressBar() {
        return this.borderProgressBar;
    }

    @Override
    public ColorUIResource getColorDividierSplitPane() {
        return this.colorDividierSplitPane;
    }

    @Override
    public ColorUIResource getColorDividierFocusSplitPane() {
        return this.colorDividierFocusSplitPane;
    }

    @Override
    public int getSizeDividierSplitPane() {
        return this.sizeDividierSplitPane;
    }

    @Override
    public BorderUIResource getDividierBorderSplitPane() {
        return this.dividierBorderSplitPane;
    }

    @Override
    public ColorUIResource getColorTextTitledBorder() {
        return this.colorTextTitledBorder;
    }

    @Override
    public BorderUIResource getBorderTitledBorder() {
        return this.borderTitledBorder;
    }

    @Override
    public IconUIResource getIconCloseTitlePane() {
        return this.iconCloseTitlePane;
    }

    @Override
    public FontUIResource getFontBold() {
        return this.fontBold;
    }

    @Override
    public FontUIResource getFontItalic() {
        return this.fontItalic;
    }

    @Override
    public FontUIResource getFontRegular() {
        return this.fontRegular;
    }

    @Override
    public FontUIResource getFontMedium() {
        return this.fontMedium;
    }

    @Override
    public void setDisabledColorSlider(ColorUIResource disabledColorSlider) {
        this.disabledColorSlider = disabledColorSlider;
    }

    @Override
    public void setDisabledUnselectedIconToggleButton(IconUIResource disabledUnselectedIconToggleButton) {
        this.disabledUnselectedIconToggleButton = disabledUnselectedIconToggleButton;
    }

    @Override
    public void setDisabledSelectedIconToggleButton(IconUIResource disabledSelectedIconToggleButton) {
        this.disabledSelectedIconToggleButton = disabledSelectedIconToggleButton;
    }

    @Override
    public void setDisabledUnselectedRadioButtonIcon(IconUIResource disabledUnselectedRadioButtonIcon) {
        this.disabledUnselectedRadioButtonIcon = disabledUnselectedRadioButtonIcon;
    }

    @Override
    public void setDisabledSelectedRadioButtonIcon(IconUIResource disabledSelectedRadioButtonIcon) {
        this.disabledSelectedRadioButtonIcon = disabledSelectedRadioButtonIcon;
    }

    @Override
    public void setDisabledUnselectedCheckBoxIcon(IconUIResource disabledUnselectedCheckBoxIcon) {
        this.disabledUnselectedCheckBoxIcon = disabledUnselectedCheckBoxIcon;
    }

    @Override
    public void setDisabledSelectedCheckBoxIcon(IconUIResource disabledSelectedCheckBoxIcon) {
        this.disabledSelectedCheckBoxIcon = disabledSelectedCheckBoxIcon;
    }

    @Override
    public void setButtonIconComboBox(IconUIResource buttonIconComboBox) {
        this.buttonIconComboBox = buttonIconComboBox;
    }

    @Override
    public void setButtonSelectIconComboBox(IconUIResource buttonSelectIconComboBox) {
        this.buttonSelectIconComboBox = buttonSelectIconComboBox;
    }

    @Override
    public void setBackgroundToolTip(ColorUIResource backgroundToolTip) {
        this.backgroundToolTip = backgroundToolTip;
    }

    @Override
    public void setForegroundToolTip(ColorUIResource foregroundToolTip) {
        this.foregroundToolTip = foregroundToolTip;
    }

    @Override
    public void setBorderToolTip(BorderUIResource borderToolTip) {
        this.borderToolTip = borderToolTip;
    }

    @Override
    public void setDisabledBottomIconTabbedPane(IconUIResource disabledBottomIconTabbedPane) {
        this.disabledBottomIconTabbedPane = disabledBottomIconTabbedPane;
    }

    @Override
    public void setDisabledTopIconTabbedPane(IconUIResource disabledTopIconTabbedPane) {
        this.disabledTopIconTabbedPane = disabledTopIconTabbedPane;
    }

    @Override
    public void setDisabledLeftIconTabbedPane(IconUIResource disabledLeftIconTabbedPane) {
        this.disabledLeftIconTabbedPane = disabledLeftIconTabbedPane;
    }

    @Override
    public void setDisabledRightIconTabbedPane(IconUIResource disabledRightIconTabbedPane) {
        this.disabledRightIconTabbedPane = disabledRightIconTabbedPane;
    }

    @Override
    public void setBottomIconTabbedPane(IconUIResource bottomIconTabbedPane) {
        this.bottomIconTabbedPane = bottomIconTabbedPane;
    }

    @Override
    public void setTopIconTabbedPane(IconUIResource topIconTabbedPane) {
        this.topIconTabbedPane = topIconTabbedPane;
    }

    @Override
    public void setLeftIconTabbedPane(IconUIResource leftIconTabbedPane) {
        this.leftIconTabbedPane = leftIconTabbedPane;
    }

    @Override
    public void setRightIconTabbedPane(IconUIResource rightIconTabbedPane) {
        this.rightIconTabbedPane = rightIconTabbedPane;
    }

    @Override
    public void setColorIconTabbedPane(ColorUIResource colorIconTabbedPane) {
        this.colorIconTabbedPane = colorIconTabbedPane;
    }

    @Override
    public void setColorDisabledIconTabbedPane(ColorUIResource colorDisabledIconTabbedPane) {
        this.colorDisabledIconTabbedPane = colorDisabledIconTabbedPane;
    }

    @Override
    public void setPreviousButtonIconSpinner(IconUIResource previousButtonIconSpinner) {
        this.previousButtonIconSpinner = previousButtonIconSpinner;
    }

    @Override
    public void setNextButtonIconSpinner(IconUIResource nextButtonIconSpinner) {
        this.nextButtonIconSpinner = nextButtonIconSpinner;
    }

    public void setBorderItemComboBox(BorderUIResource borderItemComboBox) {
        this.borderItemComboBox = borderItemComboBox;
    }

    @Override
    public void setArchTaskPane(int archTaskPane) {
        this.archTaskPane = archTaskPane;
    }

    @Override
    public void setTitleColorTaskPane(ColorUIResource titleColorTaskPane) {
        this.titleColorTaskPane = titleColorTaskPane;
    }

    @Override
    public void setBackgroundSeparator(ColorUIResource backgroundSeparator) {
        this.backgroundSeparator = backgroundSeparator;
    }

    @Override
    public void setForegroundSeparator(ColorUIResource foregroundSeparator) {
        this.foregroundSeparator = foregroundSeparator;
    }

    @Override
    public void setLeafIconTree(IconUIResource leafIconTree) {
        this.leafIconTree = leafIconTree;
    }

    @Override
    public void setBorderTree(BorderUIResource borderTree) {
        this.borderTree = borderTree;
    }

    @Override
    public void setIconCloseTitlePane(IconUIResource iconCloseTitlePane) {
        this.iconCloseTitlePane = iconCloseTitlePane;
    }

    @Override
    public void setDisabledBackgroudnTextField(ColorUIResource disabledBackgroudnTextField) {
        this.disabledBackgroudnTextField = disabledBackgroudnTextField;
    }

    @Override
    public void setDisabledForegroundTextField(ColorUIResource disabledForegroundTextField) {
        this.disabledForegroundTextField = disabledForegroundTextField;
    }

    @Override
    public void setColorTextTitledBorder(ColorUIResource colorTextTitledBorder) {
        this.colorTextTitledBorder = colorTextTitledBorder;
    }

    @Override
    public void setBorderTitledBorder(BorderUIResource borderTitledBorder) {
        this.borderTitledBorder = borderTitledBorder;
    }

    @Override
    public void setColorDividierSplitPane(ColorUIResource colorDividierSplitPane) {
        this.colorDividierSplitPane = colorDividierSplitPane;
    }

    @Override
    public void setColorDividierFocusSplitPane(ColorUIResource colorDividierFocusSplitPane) {
        this.colorDividierFocusSplitPane = colorDividierFocusSplitPane;
    }

    @Override
    public void setSizeDividierSplitPane(int sizeDividierSplitPane) {
        this.sizeDividierSplitPane = sizeDividierSplitPane;
    }

    @Override
    public void setDividierBorderSplitPane(BorderUIResource dividierBorderSplitPane) {
        this.dividierBorderSplitPane = dividierBorderSplitPane;
    }

    @Override
    public void setUnselectedIconToggleButton(IconUIResource unselectedIconToggleButton) {
        this.unselectedIconToggleButton = unselectedIconToggleButton;
    }

    @Override
    public void setSelectedIconToggleButton(IconUIResource selectedIconToggleButton) {
        this.selectedIconToggleButton = selectedIconToggleButton;
    }

    @Override
    public void setWithoutIconToggleButton(boolean withoutIconToggleButton) {
        this.withoutIconToggleButton = withoutIconToggleButton;
    }

    @Override
    public void setWithoutIconSelectedBackgroundToggleButton(ColorUIResource withoutIconSelectedBackgroundToggleButton) {
        this.withoutIconSelectedBackgroundToggleButton = withoutIconSelectedBackgroundToggleButton;
    }

    @Override
    public void setWithoutIconSelectedForegoundToggleButton(ColorUIResource withoutIconSelectedForegoundToggleButton) {
        this.withoutIconSelectedForegoundToggleButton = withoutIconSelectedForegoundToggleButton;
    }

    @Override
    public void setWithoutIconBackgroundToggleButton(ColorUIResource withoutIconBackgroundToggleButton) {
        this.withoutIconBackgroundToggleButton = withoutIconBackgroundToggleButton;
    }

    @Override
    public void setWithoutIconForegroundToggleButton(ColorUIResource withoutIconForegroundToggleButton) {
        this.withoutIconForegroundToggleButton = withoutIconForegroundToggleButton;
    }

    @Override
    public void setWithoutIconSelectedBorderToggleButton(BorderUIResource withoutIconSelectedBorderToggleButton) {
        this.withoutIconSelectedBorderToggleButton = withoutIconSelectedBorderToggleButton;
    }

    @Override
    public void setWithoutIconBorderToggleButton(BorderUIResource withoutIconBorderToggleButton) {
        this.withoutIconBorderToggleButton = withoutIconBorderToggleButton;
    }

    @Override
    public void setBackgroundPrimary(ColorUIResource backgroundPrimary) {
        this.backgroundPrimary = backgroundPrimary;
    }

    @Override
    public void setHighlightBackgroundPrimary(ColorUIResource highlightBackgroundPrimary) {
        this.highlightBackgroundPrimary = highlightBackgroundPrimary;
    }

    @Override
    public void setTextColor(ColorUIResource textColor) {
        this.textColor = textColor;
    }

    @Override
    public void setDisableTextColor(ColorUIResource disableTextColor) {
        this.disableTextColor = disableTextColor;
    }

    @Override
    public void setButtonBackgroundColor(ColorUIResource buttonBackgroundColor) {
        this.buttonBackgroundColor = buttonBackgroundColor;
    }

    @Override
    public void setButtonTextColor(ColorUIResource buttonTextColor) {
        this.buttonTextColor = buttonTextColor;
    }

    @Override
    public void setButtonBackgroundColorMouseHover(ColorUIResource buttonBackgroundColorMouseHover) {
        this.buttonBackgroundColorMouseHover = buttonBackgroundColorMouseHover;
    }

    @Override
    public void setButtonDefaultBackgroundColor(ColorUIResource buttonDefaultBackgroundColor) {
        this.buttonDefaultBackgroundColor = buttonDefaultBackgroundColor;
    }

    @Override
    public void setButtonDefaultTextColor(ColorUIResource buttonDefaultTextColor) {
        this.buttonDefaultTextColor = buttonDefaultTextColor;
    }

    @Override
    public void setButtonDefaultBackgroundColorMouseHover(ColorUIResource buttonDefaultBackgroundColorMouseHover) {
        this.buttonDefaultBackgroundColorMouseHover = buttonDefaultBackgroundColorMouseHover;
    }

    @Override
    public void setButtonDisabledBackground(ColorUIResource buttonDisabledBackground) {
        this.buttonDisabledBackground = buttonDisabledBackground;
    }

    @Override
    public void setButtonDisabledForeground(ColorUIResource buttonDisabledForeground) {
        this.buttonDisabledForeground = buttonDisabledForeground;
    }

    @Override
    public void setButtonFocusColor(ColorUIResource buttonFocusColor) {
        this.buttonFocusColor = buttonFocusColor;
    }

    @Override
    public void setButtonDefaultFocusColor(ColorUIResource buttonDefaultFocusColor) {
        this.buttonDefaultFocusColor = buttonDefaultFocusColor;
    }

    @Override
    public void setButtonBorderColor(ColorUIResource buttonBorderColor) {
        this.buttonBorderColor = buttonBorderColor;
    }

    @Override
    public void setButtonColorHighlight(ColorUIResource buttonColorHighlight) {
        this.buttonColorHighlight = buttonColorHighlight;
    }

    @Override
    public void setButtonBorder(BorderUIResource buttonBorder) {
        this.buttonBorder = buttonBorder;
    }

    @Override
    public void setUnselectedCheckBoxIcon(IconUIResource unselectedCheckBoxIcon) {
        this.unselectedCheckBoxIcon = unselectedCheckBoxIcon;
    }

    @Override
    public void setSelectedCheckBoxIcon(IconUIResource selectedCheckBoxIcon) {
        this.selectedCheckBoxIcon = selectedCheckBoxIcon;
    }

    @Override
    public void setSelectedInDropDownBackgroundComboBox(ColorUIResource selectedInDropDownBackgroundComboBox) {
        this.selectedInDropDownBackgroundComboBox = selectedInDropDownBackgroundComboBox;
    }

    @Override
    public void setSelectedForegroundComboBox(ColorUIResource selectedForegroundComboBox) {
        this.selectedForegroundComboBox = selectedForegroundComboBox;
    }

    @Override
    public void setBorderComboBox(BorderUIResource borderComboBox) {
        this.borderComboBox = borderComboBox;
    }

    @Override
    public void setMenuBackground(ColorUIResource menuBackground) {
        this.menuBackground = menuBackground;
    }

    @Override
    public void setMenuTextColor(ColorUIResource menuTextColor) {
        this.menuTextColor = menuTextColor;
    }

    @Override
    public void setMenuBackgroundMouseHover(ColorUIResource menuBackgroundMouseHover) {
        this.menuBackgroundMouseHover = menuBackgroundMouseHover;
    }

    @Override
    public void setMenuDisableBackground(ColorUIResource menuDisableBackground) {
        this.menuDisableBackground = menuDisableBackground;
    }

    @Override
    public void setBorderMenu(BorderUIResource borderMenu) {
        this.borderMenu = borderMenu;
    }

    @Override
    public void setBorderMenuBar(BorderUIResource borderMenuBar) {
        this.borderMenuBar = borderMenuBar;
    }

    @Override
    public void setUnselectedRadioButtonIcon(IconUIResource unselectedRadioButtonIcon) {
        this.unselectedRadioButtonIcon = unselectedRadioButtonIcon;
    }

    @Override
    public void setSelectedRadioButtonIcon(IconUIResource selectedRadioButtonIcon) {
        this.selectedRadioButtonIcon = selectedRadioButtonIcon;
    }

    @Override
    public void setBorderPopupMenu(BorderUIResource borderPopupMenu) {
        this.borderPopupMenu = borderPopupMenu;
    }

    @Override
    public void setArrowButtonBackgroundSpinner(ColorUIResource arrowButtonBackgroundSpinner) {
        this.arrowButtonBackgroundSpinner = arrowButtonBackgroundSpinner;
    }

    @Override
    public void setMouseHoverButtonColorSpinner(ColorUIResource mouseHoverButtonColorSpinner) {
        this.mouseHoverButtonColorSpinner = mouseHoverButtonColorSpinner;
    }

    @Override
    public void setBorderSpinner(BorderUIResource borderSpinner) {
        this.borderSpinner = borderSpinner;
    }

    @Override
    public void setArrowButtonBorderSpinner(BorderUIResource arrowButtonBorderSpinner) {
        this.arrowButtonBorderSpinner = arrowButtonBorderSpinner;
    }

    @Override
    public void setBorderPanel(BorderUIResource borderPanel) {
        this.borderPanel = borderPanel;
    }

    @Override
    public void setTrackColorScrollBar(ColorUIResource trackColorScrollBar) {
        this.trackColorScrollBar = trackColorScrollBar;
    }

    @Override
    public void setThumbColorScrollBar(ColorUIResource thumbColorScrollBar) {
        this.thumbColorScrollBar = thumbColorScrollBar;
    }

    @Override
    public void setThumbDarkShadowColorScrollBar(ColorUIResource thumbDarkShadowColorScrollBar) {
        this.thumbDarkShadowColorScrollBar = thumbDarkShadowColorScrollBar;
    }

    @Override
    public void setThumbHighlightColorScrollBar(ColorUIResource thumbHighlightColorScrollBar) {
        this.thumbHighlightColorScrollBar = thumbHighlightColorScrollBar;
    }

    @Override
    public void setThumbShadowColorScrollBar(ColorUIResource thumbShadowColorScrollBar) {
        this.thumbShadowColorScrollBar = thumbShadowColorScrollBar;
    }

    @Override
    public void setMouseHoverColorScrollBar(ColorUIResource mouseHoverColorScrollBar) {
        this.mouseHoverColorScrollBar = mouseHoverColorScrollBar;
    }

    @Override
    public void setArrowButtonColorScrollBar(ColorUIResource arrowButtonColorScrollBar) {
        this.arrowButtonColorScrollBar = arrowButtonColorScrollBar;
    }

    @Override
    public void setArrowButtonOnClickColorScrollBar(ColorUIResource arrowButtonOnClickColorScrollBar) {
        this.arrowButtonOnClickColorScrollBar = arrowButtonOnClickColorScrollBar;
    }

    @Override
    public void setArrowButtonBorderScrollBar(BorderUIResource arrowButtonBorderScrollBar) {
        this.arrowButtonBorderScrollBar = arrowButtonBorderScrollBar;
    }

    @Override
    public void setTrackColorSlider(ColorUIResource trackColorSlider) {
        this.trackColorSlider = trackColorSlider;
    }

    @Override
    public void setHaloColorSlider(ColorUIResource haloColorSlider) {
        this.haloColorSlider = haloColorSlider;
    }

    @Override
    public void setBorderSlider(BorderUIResource borderSlider) {
        this.borderSlider = borderSlider;
    }

    @Override
    public void setHighlightColorTabbedPane(ColorUIResource highlightColorTabbedPane) {
        this.highlightColorTabbedPane = highlightColorTabbedPane;
    }

    @Override
    public void setBorderHighlightColorTabbedPane(ColorUIResource borderHighlightColorTabbedPane) {
        this.borderHighlightColorTabbedPane = borderHighlightColorTabbedPane;
    }

    @Override
    public void setFocusColorLineTabbedPane(ColorUIResource focusColorLineTabbedPane) {
        this.focusColorLineTabbedPane = focusColorLineTabbedPane;
    }

    @Override
    public void setDisableColorTabTabbedPane(ColorUIResource disableColorTabTabbedPane) {
        this.disableColorTabTabbedPane = disableColorTabTabbedPane;
    }

    @Override
    public void setTabInsetsTabbedPane(InsetsUIResource tabInsetsTabbedPane) {
        this.tabInsetsTabbedPane = tabInsetsTabbedPane;
    }

    @Override
    public void setSelectedTabInsetsTabbedPane(InsetsUIResource selectedTabInsetsTabbedPane) {
        this.selectedTabInsetsTabbedPane = selectedTabInsetsTabbedPane;
    }

    @Override
    public void setBackgroundTable(ColorUIResource backgroundTable) {
        this.backgroundTable = backgroundTable;
    }

    @Override
    public void setBackgroundTableHeader(ColorUIResource backgroundTableHeader) {
        this.backgroundTableHeader = backgroundTableHeader;
    }

    @Override
    public void setForegroundTable(ColorUIResource foregroundTable) {
        this.foregroundTable = foregroundTable;
    }

    @Override
    public void setForegroundTableHeader(ColorUIResource foregroundTableHeader) {
        this.foregroundTableHeader = foregroundTableHeader;
    }

    @Override
    public void setSelectionBackgroundTable(ColorUIResource selectionBackgroundTable) {
        this.selectionBackgroundTable = selectionBackgroundTable;
    }

    @Override
    public void setSelectionForegroundTable(ColorUIResource selectionForegroundTable) {
        this.selectionForegroundTable = selectionForegroundTable;
    }

    @Override
    public void setGridColorTable(ColorUIResource gridColorTable) {
        this.gridColorTable = gridColorTable;
    }

    @Override
    public void setAlternateRowBackgroundTable(ColorUIResource alternateRowBackgroundTable) {
        this.alternateRowBackgroundTable = alternateRowBackgroundTable;
    }

    @Override
    public void setBorderTable(BorderUIResource borderTable) {
        this.borderTable = borderTable;
    }

    @Override
    public void setBorderTableHeader(BorderUIResource borderTableHeader) {
        this.borderTableHeader = borderTableHeader;
    }

    @Override
    public void setCellBorderTableHeader(BorderUIResource cellBorderTableHeader) {
        this.cellBorderTableHeader = cellBorderTableHeader;
    }

    @Override
    public void setUnselectedCheckBoxIconTable(IconUIResource unselectedCheckBoxIconTable) {
        this.unselectedCheckBoxIconTable = unselectedCheckBoxIconTable;
    }

    @Override
    public void setSelectedCheckBoxIconTable(IconUIResource selectedCheckBoxIconTable) {
        this.selectedCheckBoxIconTable = selectedCheckBoxIconTable;
    }

    @Override
    public void setUnselectedCheckBoxIconSelectionRowTable(IconUIResource unselectedCheckBoxIconSelectionRowTable) {
        this.unselectedCheckBoxIconSelectionRowTable = unselectedCheckBoxIconSelectionRowTable;
    }

    @Override
    public void setSelectedCheckBoxIconSelectionRowTable(IconUIResource selectedCheckBoxIconSelectionRowTable) {
        this.selectedCheckBoxIconSelectionRowTable = selectedCheckBoxIconSelectionRowTable;
    }

    @Override
    public void setDockingBackgroundToolBar(ColorUIResource dockingBackgroundToolBar) {
        this.dockingBackgroundToolBar = dockingBackgroundToolBar;
    }

    @Override
    public void setFloatingBackgroundToolBar(ColorUIResource floatingBackgroundToolBar) {
        this.floatingBackgroundToolBar = floatingBackgroundToolBar;
    }

    @Override
    public void setBorderToolBar(BorderUIResource borderToolBar) {
        this.borderToolBar = borderToolBar;
    }

    @Override
    public void setSelectionForegroundTree(ColorUIResource selectionForegroundTree) {
        this.selectionForegroundTree = selectionForegroundTree;
    }

    @Override
    public void setSelectionBackgroundTree(ColorUIResource selectionBackgroundTree) {
        this.selectionBackgroundTree = selectionBackgroundTree;
    }

    @Override
    public void setSelectionBorderColorTree(ColorUIResource selectionBorderColorTree) {
        this.selectionBorderColorTree = selectionBorderColorTree;
    }

    @Override
    public void setClosedIconTree(IconUIResource closedIconTree) {
        this.closedIconTree = closedIconTree;
    }

    @Override
    public void setOpenIconTree(IconUIResource openIconTree) {
        this.openIconTree = openIconTree;
    }

    @Override
    public void setBackgroundTextField(ColorUIResource backgroundTextField) {
        this.backgroundTextField = backgroundTextField;
    }

    @Override
    public void setInactiveForegroundTextField(ColorUIResource inactiveForegroundTextField) {
        this.inactiveForegroundTextField = inactiveForegroundTextField;
    }

    @Override
    public void setInactiveBackgroundTextField(ColorUIResource inactiveBackgroundTextField) {
        this.inactiveBackgroundTextField = inactiveBackgroundTextField;
    }

    @Override
    public void setSelectionBackgroundTextField(ColorUIResource selectionBackgroundTextField) {
        this.selectionBackgroundTextField = selectionBackgroundTextField;
    }

    @Override
    public void setSelectionForegroundTextField(ColorUIResource selectionForegroundTextField) {
        this.selectionForegroundTextField = selectionForegroundTextField;
    }

    @Override
    public void setInactiveColorLineTextField(ColorUIResource inactiveColorLineTextField) {
        this.inactiveColorLineTextField = inactiveColorLineTextField;
    }

    @Override
    public void setActiveColorLineTextField(ColorUIResource activeColorLineTextField) {
        this.activeColorLineTextField = activeColorLineTextField;
    }

    @Override
    public void setBorderTextField(BorderUIResource borderTextField) {
        this.borderTextField = borderTextField;
    }

    @Override
    public void setTitleBackgroundGradientStartTaskPane(ColorUIResource titleBackgroundGradientStartTaskPane) {
        this.titleBackgroundGradientStartTaskPane = titleBackgroundGradientStartTaskPane;
    }

    @Override
    public void setTitleBackgroundGradientEndTaskPane(ColorUIResource titleBackgroundGradientEndTaskPane) {
        this.titleBackgroundGradientEndTaskPane = titleBackgroundGradientEndTaskPane;
    }

    @Override
    public void setTitleOverTaskPane(ColorUIResource titleOverTaskPane) {
        this.titleOverTaskPane = titleOverTaskPane;
    }

    @Override
    public void setSpecialTitleOverTaskPane(ColorUIResource specialTitleOverTaskPane) {
        this.specialTitleOverTaskPane = specialTitleOverTaskPane;
    }

    @Override
    public void setBackgroundTaskPane(ColorUIResource backgroundTaskPane) {
        this.backgroundTaskPane = backgroundTaskPane;
    }

    @Override
    public void setBorderColorTaskPane(ColorUIResource borderColorTaskPane) {
        this.borderColorTaskPane = borderColorTaskPane;
    }

    @Override
    public void setContentBackgroundTaskPane(ColorUIResource contentBackgroundTaskPane) {
        this.contentBackgroundTaskPane = contentBackgroundTaskPane;
    }

    @Override
    public void setBorderTaskPane(BorderUIResource borderTaskPane) {
        this.borderTaskPane = borderTaskPane;
    }

    @Override
    public void setYesCollapsedTaskPane(IconUIResource yesCollapsedTaskPane) {
        this.yesCollapsedTaskPane = yesCollapsedTaskPane;
    }

    @Override
    public void setNoCollapsedTaskPane(IconUIResource noCollapsedTaskPane) {
        this.noCollapsedTaskPane = noCollapsedTaskPane;
    }

    @Override
    public void setSelectionBackgroundList(ColorUIResource selectionBackgroundList) {
        this.selectionBackgroundList = selectionBackgroundList;
    }

    @Override
    public void setSelectionForegroundList(ColorUIResource selectionForegroundList) {
        this.selectionForegroundList = selectionForegroundList;
    }

    @Override
    public void setFocusCellHighlightBorder(BorderUIResource focusCellHighlightBorder) {
        this.focusCellHighlightBorder = focusCellHighlightBorder;
    }

    @Override
    public void setBorderItemList(BorderUIResource borderItemList) {
        this.borderItemList = borderItemList;
    }

    @Override
    public void setBorderList(BorderUIResource borderList) {
        this.borderList = borderList;
    }

    @Override
    public void setBorderFrameRootPane(BorderUIResource borderFrameRootPane) {
        this.borderFrameRootPane = borderFrameRootPane;
    }

    @Override
    public void setBorderDialogRootPane(BorderUIResource borderDialogRootPane) {
        this.borderDialogRootPane = borderDialogRootPane;
    }

    @Override
    public void setBackgroundOptionPane(ColorUIResource backgroundOptionPane) {
        this.backgroundOptionPane = backgroundOptionPane;
    }

    @Override
    public void setWarningIconOptionPane(IconUIResource warningIconOptionPane) {
        this.warningIconOptionPane = warningIconOptionPane;
    }

    @Override
    public void setErrorIconIconOptionPane(IconUIResource errorIconIconOptionPane) {
        this.errorIconIconOptionPane = errorIconIconOptionPane;
    }

    @Override
    public void setQuestionIconOptionPane(IconUIResource questionIconOptionPane) {
        this.questionIconOptionPane = questionIconOptionPane;
    }

    @Override
    public void setInformationIconOptionPane(IconUIResource informationIconOptionPane) {
        this.informationIconOptionPane = informationIconOptionPane;
    }

    @Override
    public void setIconComputerFileChooser(IconUIResource iconComputerFileChooser) {
        this.iconComputerFileChooser = iconComputerFileChooser;
    }

    @Override
    public void setIconDirectoryFileChooser(IconUIResource iconDirectoryFileChooser) {
        this.iconDirectoryFileChooser = iconDirectoryFileChooser;
    }

    @Override
    public void setIconFileFileChooser(IconUIResource iconFileFileChooser) {
        this.iconFileFileChooser = iconFileFileChooser;
    }

    @Override
    public void setIconFloppyDriveFileChooser(IconUIResource iconFloppyDriveFileChooser) {
        this.iconFloppyDriveFileChooser = iconFloppyDriveFileChooser;
    }

    @Override
    public void setIconHardDriveFileChooser(IconUIResource iconHardDriveFileChooser) {
        this.iconHardDriveFileChooser = iconHardDriveFileChooser;
    }

    @Override
    public void setIconHomeFileChooser(IconUIResource iconHomeFileChooser) {
        this.iconHomeFileChooser = iconHomeFileChooser;
    }

    @Override
    public void setIconListFileChooser(IconUIResource iconListFileChooser) {
        this.iconListFileChooser = iconListFileChooser;
    }

    @Override
    public void setIconDetailsFileChooser(IconUIResource iconDetailsFileChooser) {
        this.iconDetailsFileChooser = iconDetailsFileChooser;
    }

    @Override
    public void setIconNewFolderFileChooser(IconUIResource iconNewFolderFileChooser) {
        this.iconNewFolderFileChooser = iconNewFolderFileChooser;
    }

    @Override
    public void setIconUpFolderFileChooser(IconUIResource iconUpFolderFileChooser) {
        this.iconUpFolderFileChooser = iconUpFolderFileChooser;
    }

    @Override
    public void setBackgroundProgressBar(ColorUIResource backgroundProgressBar) {
        this.backgroundProgressBar = backgroundProgressBar;
    }

    @Override
    public void setForegroundProgressBar(ColorUIResource foregroundProgressBar) {
        this.foregroundProgressBar = foregroundProgressBar;
    }

    @Override
    public void setBorderProgressBar(BorderUIResource borderProgressBar) {
        this.borderProgressBar = borderProgressBar;
    }

    @Override
    public void setFontBold(FontUIResource fontBold) {
        this.fontBold = fontBold;
    }

    @Override
    public void setFontItalic(FontUIResource fontItalic) {
        this.fontItalic = fontItalic;
    }

    @Override
    public void setFontRegular(FontUIResource fontRegular) {
        this.fontRegular = fontRegular;
    }

    @Override
    public void setFontMedium(FontUIResource fontMedium) {
        this.fontMedium = fontMedium;
    }
}

