/*
 * Decompiled with CFR 0.152.
 */
package convex.net.message;

import convex.core.Result;
import convex.core.data.ACell;
import convex.core.data.Hash;
import convex.core.data.prim.CVMLong;
import convex.net.Connection;
import convex.net.MessageType;
import convex.net.message.Message;

public class MessageRemote
extends Message {
    private final Connection connection;

    protected MessageRemote(Connection conn, MessageType type, ACell payload) {
        super(type, payload);
        this.connection = conn;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public MessageRemote withConnection(Connection peerConnection) {
        return new MessageRemote(peerConnection, this.type, this.payload);
    }

    @Override
    public boolean reportResult(Result res) {
        res = res.withID(this.getID());
        Connection pc = this.getConnection();
        if (pc == null || pc.isClosed()) {
            return false;
        }
        try {
            return pc.sendResult(res);
        }
        catch (Exception t) {
            log.debug("Error reporting result: {}", (Object)t.getMessage());
            return false;
        }
    }

    @Override
    public boolean reportResult(CVMLong id, ACell reply) {
        Connection pc = this.getConnection();
        if (pc == null || pc.isClosed()) {
            return false;
        }
        try {
            return pc.sendResult(id, reply);
        }
        catch (Exception t) {
            log.debug("Error reporting result: {}", (Object)t.getMessage());
            return false;
        }
    }

    @Override
    public String getOriginString() {
        Connection pc = this.getConnection();
        if (pc == null) {
            return "Disconnected message";
        }
        return pc.getRemoteAddress().toString();
    }

    @Override
    public boolean sendData(ACell data) {
        Connection pc = this.getConnection();
        if (pc == null) {
            return false;
        }
        try {
            pc.sendData(data);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean sendMissingData(Hash hash) {
        Connection pc = this.getConnection();
        if (pc == null) {
            return false;
        }
        try {
            pc.sendMissingData(hash);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

