/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.AString;
import convex.core.data.ASymbolic;
import convex.core.data.BlobBuilder;
import convex.core.data.Format;
import convex.core.data.StringShort;
import convex.core.data.Strings;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import java.nio.ByteBuffer;

public class Keyword
extends ASymbolic
implements Comparable<Keyword> {
    public static final int MAX_CHARS = 128;
    public static final int MIN_CHARS = 1;

    private Keyword(StringShort name) {
        super(name);
    }

    @Override
    public AType getType() {
        return Types.KEYWORD;
    }

    public static Keyword create(String name) {
        if (name == null) {
            return null;
        }
        return Keyword.create(Strings.create(name));
    }

    public static Keyword unsafeCreate(String rawName) {
        return Keyword.unsafeCreate((StringShort)Strings.create(rawName));
    }

    public static Keyword unsafeCreate(StringShort rawName) {
        return new Keyword(rawName);
    }

    public static Keyword create(AString name) {
        if (name == null) {
            return null;
        }
        if (!Keyword.validateName(name)) {
            return null;
        }
        return new Keyword((StringShort)name);
    }

    public static Keyword createChecked(AString aString) {
        Keyword k = Keyword.create(aString);
        if (k == null) {
            throw new IllegalArgumentException("Invalid keyword name: " + aString);
        }
        return k;
    }

    public static Keyword createChecked(String aString) {
        Keyword k = Keyword.create(aString);
        if (k == null) {
            throw new IllegalArgumentException("Invalid keyword name: " + aString);
        }
        return k;
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    public static Keyword read(ByteBuffer bb) throws BadFormatException {
        int len = 0xFF & bb.get();
        AString name = Format.readUTF8String(bb, len);
        Keyword kw = Keyword.create(name);
        if (kw == null) {
            throw new BadFormatException("Can't read keyword (probably invalid name)");
        }
        return kw;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = 51;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        bs[pos++] = (byte)this.name.count();
        return this.name.encodeRawData(bs, pos);
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append(':');
        bb.append(this.name);
        return bb.check(limit);
    }

    @Override
    public int estimatedEncodingSize() {
        return (int)(this.name.count() + 3L);
    }

    @Override
    public boolean equals(ACell other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Keyword)) {
            return false;
        }
        return this.name.equals(((Keyword)other).name);
    }

    @Override
    public int compareTo(Keyword k) {
        return this.name.compareTo(k.name);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (!Keyword.validateName(this.name)) {
            throw new InvalidDataException("Invalid Keyword name: " + this.name, this);
        }
    }

    @Override
    public int getRefCount() {
        return 0;
    }

    @Override
    public byte getTag() {
        return 51;
    }

    @Override
    public ACell toCanonical() {
        return this;
    }

    @Override
    public AString toCVMString(long limit) {
        return Strings.COLON.append(this.name);
    }
}

