/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.BlobBuilder;
import convex.core.data.BlobTree;
import convex.core.data.Format;
import convex.core.exceptions.BadFormatException;
import convex.core.lang.RT;
import convex.core.util.Utils;
import java.nio.ByteBuffer;
import java.util.Random;
import org.bouncycastle.util.Arrays;

public class Blobs {
    static final int CHUNK_SHIFT = 12;
    public static final int MAX_ENCODING_LENGTH = Math.max(Blob.MAX_ENCODING_LENGTH, 645);

    public static <T extends ABlob> T createRandom(long length) {
        return Blobs.createRandom(new Random(), length);
    }

    public static <T extends ABlob> T createRandom(Random r, long length) {
        if (length <= 4096L) {
            return (T)Blob.createRandom(r, length);
        }
        BlobBuilder bb = new BlobBuilder();
        while (length > 4096L) {
            bb.append((ABlob)Blobs.createRandom(r, 4096L));
            length -= 4096L;
        }
        bb.append((ABlob)Blobs.createRandom(r, length));
        return (T)bb.toBlob();
    }

    public static ABlob toCanonical(ABlob a) {
        long length = a.count();
        if (length <= 4096L) {
            return a.toFlatBlob();
        }
        return BlobTree.create(a);
    }

    public static ABlob fromHex(String a) {
        long slength = a.length();
        if ((slength & 1L) != 0L) {
            return null;
        }
        Blob fullBlob = Blob.fromHex(a);
        long length = slength / 2L;
        if (length <= 4096L) {
            return fullBlob;
        }
        return BlobTree.create((ABlob)fullBlob);
    }

    public static ABlob parse(Object o) {
        if (o instanceof ABlob) {
            ABlob b = (ABlob)o;
            if (b.isRegularBlob()) {
                return b;
            }
            return null;
        }
        if (o instanceof ACell) {
            o = RT.jvm((ACell)o);
        }
        if (!(o instanceof String)) {
            return null;
        }
        String s = (String)o;
        return Blobs.parse(s);
    }

    public static ABlob parse(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).startsWith("0x")) {
            s = s.substring(2);
        }
        return Blobs.fromHex(s);
    }

    public static ABlob read(ByteBuffer bb) throws BadFormatException {
        long len = Format.readVLCLong(bb);
        if (len < 0L) {
            throw new BadFormatException("Negative blob length?");
        }
        if (len > 4096L) {
            return BlobTree.read(bb, len);
        }
        byte[] buff = new byte[Utils.checkedInt(len)];
        bb.get(buff);
        return Blob.wrap(buff);
    }

    public static <T extends ABlob> T readFromBlob(Blob source) throws BadFormatException {
        int sLen = source.length;
        if (sLen < 2) {
            throw new BadFormatException("Trying to read Blob from insufficient source of size " + sLen);
        }
        long len = Format.readVLCLong(source.store, source.offset + 1);
        ABlob result = null;
        if (len < 0L) {
            throw new BadFormatException("Negative blob length?");
        }
        result = len > 4096L ? BlobTree.read(source, len) : Blob.read(source, len);
        result.attachEncoding(source);
        return (T)result;
    }

    public static ABlob createFilled(int value, long length) {
        byte fillByte = (byte)value;
        if (length <= 4096L) {
            byte[] bs = new byte[Utils.checkedInt(length)];
            Arrays.fill(bs, fillByte);
            return Blob.wrap(bs);
        }
        int n = BlobTree.childCount(length);
        long subSize = BlobTree.childSize(length);
        ABlob fullChild = Blobs.createFilled(fillByte, subSize);
        ABlob[] children = new ABlob[n];
        for (int i = 0; i < n - 1; ++i) {
            children[i] = fullChild;
        }
        long lastSize = length - (long)(n - 1) * subSize;
        children[n - 1] = lastSize == subSize ? fullChild : Blobs.createFilled(fillByte, lastSize);
        return BlobTree.createWithChildren(children);
    }
}

