/*
 * Decompiled with CFR 0.152.
 */
package convex.core;

import convex.core.Belief;
import convex.core.Block;
import convex.core.BlockResult;
import convex.core.ErrorCodes;
import convex.core.MergeContext;
import convex.core.Order;
import convex.core.Result;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.ABlobMap;
import convex.core.data.ACell;
import convex.core.data.AMap;
import convex.core.data.AVector;
import convex.core.data.AccountKey;
import convex.core.data.Address;
import convex.core.data.BlobMap;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.data.Maps;
import convex.core.data.PeerStatus;
import convex.core.data.Ref;
import convex.core.data.RefSoft;
import convex.core.data.SignedData;
import convex.core.data.Vectors;
import convex.core.data.prim.CVMLong;
import convex.core.exceptions.BadSignatureException;
import convex.core.exceptions.InvalidDataException;
import convex.core.init.Init;
import convex.core.lang.AOp;
import convex.core.lang.Context;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.transactions.ATransaction;
import convex.core.util.Utils;
import java.io.IOException;
import java.util.function.Consumer;

public class Peer {
    private final AccountKey peerKey;
    private final transient AKeyPair keyPair;
    private final SignedData<Belief> belief;
    private final long timestamp;
    private final AVector<State> states;
    private final AVector<BlockResult> blockResults;

    private Peer(AKeyPair kp, SignedData<Belief> belief, AVector<State> states, AVector<BlockResult> results, long timeStamp) {
        this.keyPair = kp;
        this.peerKey = kp.getAccountKey();
        this.belief = belief;
        this.states = states;
        this.blockResults = results;
        this.timestamp = timeStamp;
    }

    public static Peer fromData(AKeyPair keyPair, AMap<Keyword, ACell> peerData) {
        SignedData belief = (SignedData)peerData.get(Keywords.BELIEF);
        AVector results = (AVector)peerData.get(Keywords.RESULTS);
        AVector states = (AVector)peerData.get(Keywords.STATES);
        long timestamp = ((Belief)belief.getValue()).getTimestamp();
        return new Peer(keyPair, belief, states, results, timestamp);
    }

    public AMap<Keyword, ACell> toData() {
        return Maps.of(Keywords.BELIEF, this.belief, Keywords.RESULTS, this.blockResults, Keywords.STATES, this.states);
    }

    public static Peer create(AKeyPair peerKP, State initialState) {
        Belief belief = Belief.createSingleOrder(peerKP);
        SignedData<Belief> sb = peerKP.signData(belief);
        AVector<State> states = Vectors.of(initialState);
        ACell.createPersisted(sb);
        ACell.createPersisted(states);
        RefSoft sbr = Ref.forHash(sb.getHash());
        if (sbr == null) {
            throw new Error("Belief not correctly persisted! " + sb.getHash());
        }
        return new Peer(peerKP, sb, states, Vectors.empty(), initialState.getTimeStamp().longValue());
    }

    public static Peer create(AKeyPair peerKP, State initialState, Belief remoteBelief) {
        Peer peer = Peer.create(peerKP, initialState);
        try {
            peer = peer.mergeBeliefs(remoteBelief);
            return peer;
        }
        catch (Throwable e) {
            throw (RuntimeException)Utils.sneakyThrow(e);
        }
    }

    public static Peer restorePeer(AStore store, AKeyPair keyPair) throws IOException {
        AMap<Keyword, ACell> peerData = Peer.getPeerData(store);
        if (peerData == null) {
            return null;
        }
        Peer peer = Peer.fromData(keyPair, peerData);
        return peer;
    }

    public static AMap<Keyword, ACell> getPeerData(AStore store) throws IOException {
        Stores.setCurrent(store);
        Hash root = store.getRootHash();
        Ref ref = store.refForHash(root);
        if (ref == null) {
            return null;
        }
        if (ref.getStatus() < 2) {
            return null;
        }
        AMap peerData = (AMap)ref.getValue();
        return peerData;
    }

    public static Peer createGenesisPeer(AKeyPair keyPair, State genesisState) {
        if (keyPair == null) {
            throw new IllegalArgumentException("Peer initialisation requires a keypair");
        }
        if (genesisState == null) {
            genesisState = Init.createState(Utils.listOf(keyPair.getAccountKey()));
            genesisState = genesisState.withTimestamp(Utils.getCurrentTimestamp());
        }
        return Peer.create(keyPair, genesisState);
    }

    public MergeContext getMergeContext() {
        return MergeContext.create(this.keyPair, this.timestamp, this.getConsensusState());
    }

    public Peer updateTimestamp(long newTimestamp) {
        if (newTimestamp < this.timestamp) {
            return this;
        }
        return new Peer(this.keyPair, this.belief, this.states, this.blockResults, this.timestamp);
    }

    public <T extends ACell> Context<T> executeQuery(ACell form, Address address) {
        State state = this.getConsensusState();
        if (address == null) {
            address = Init.CORE_ADDRESS;
        }
        Context ctx = Context.createFake(state, address);
        if (state.getAccount(address) == null) {
            return ctx.withError(ErrorCodes.NOBODY, "Account does not exist for query: " + address);
        }
        Context ectx = ctx.expandCompile(form);
        if (ectx.isExceptional()) {
            return ectx;
        }
        AOp op = ectx.getResult();
        Context rctx = ctx.run(op);
        return rctx;
    }

    public long estimateCost(ATransaction trans) {
        Address address = trans.getOrigin();
        State state = this.getConsensusState();
        Context ctx = this.executeDryRun(trans);
        return state.getBalance(address) - ctx.getState().getBalance(address);
    }

    public <T extends ACell> Context<T> executeDryRun(ATransaction transaction) {
        Context ctx = this.getConsensusState().applyTransaction(transaction);
        return ctx;
    }

    public <T extends ACell> Context<T> executeQuery(ACell form) {
        return this.executeQuery(form, Init.getGenesisAddress());
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public AccountKey getPeerKey() {
        return this.peerKey;
    }

    public Address getController() {
        PeerStatus ps = this.getConsensusState().getPeer(this.peerKey);
        if (ps == null) {
            return null;
        }
        return ps.getController();
    }

    public AKeyPair getKeyPair() {
        return this.keyPair;
    }

    public Belief getBelief() {
        return this.belief.getValue();
    }

    public SignedData<Belief> getSignedBelief() {
        return this.belief;
    }

    public <T extends ACell> SignedData<T> sign(T value) {
        return SignedData.create(this.keyPair, value);
    }

    public State getConsensusState() {
        return this.states.get(this.states.count() - 1L);
    }

    public Peer mergeBeliefs(Belief ... beliefs) throws BadSignatureException, InvalidDataException {
        Belief belief = this.getBelief();
        MergeContext mc = MergeContext.create(this.keyPair, this.timestamp, this.getConsensusState());
        Belief newBelief = belief.merge(mc, beliefs);
        long ocp = this.getConsensusPoint();
        Order newOrder = newBelief.getOrder(this.peerKey);
        if (ocp > newBelief.getOrder(this.peerKey).getConsensusPoint()) {
            System.err.println("Receding consensus? Old CP=" + ocp + ", New CP=" + newOrder.getConsensusPoint());
            Belief belief2 = belief.merge(mc, beliefs);
        }
        return this.updateConsensus(newBelief);
    }

    private Peer updateConsensus(Belief newBelief) {
        if (this.belief.getValue() == newBelief) {
            return this;
        }
        Order myOrder = newBelief.getOrder(this.peerKey);
        long consensusPoint = myOrder.getConsensusPoint();
        AVector<SignedData<Block>> blocks = myOrder.getBlocks();
        AVector<State> newStates = this.states;
        AVector<BlockResult> newResults = this.blockResults;
        for (long stateIndex = this.states.count() - 1L; stateIndex < consensusPoint; ++stateIndex) {
            State s = newStates.get(stateIndex);
            SignedData<Block> block = blocks.get(stateIndex);
            BlockResult br = s.applyBlock(block.getValue());
            newStates = newStates.append(br.getState());
            newResults = newResults.append(br);
        }
        SignedData<Belief> sb = this.keyPair.signData(newBelief);
        return new Peer(this.keyPair, sb, newStates, newResults, this.timestamp);
    }

    public Peer persistState(Consumer<Ref<ACell>> noveltyHandler) {
        SignedData<Belief> sb = this.belief;
        sb.announce(noveltyHandler);
        AVector<State> newStates = this.states;
        newStates = ACell.createPersisted(newStates).getValue();
        AVector<BlockResult> newResults = this.blockResults;
        newResults = ACell.createPersisted(newResults).getValue();
        return new Peer(this.keyPair, sb, newStates, newResults, this.timestamp);
    }

    public AVector<State> getStates() {
        return this.states;
    }

    public Result getResult(long blockIndex, long txIndex) {
        return this.blockResults.get(blockIndex).getResult(txIndex);
    }

    public BlockResult getBlockResult(long i) {
        return this.blockResults.get(i);
    }

    public Peer proposeBlock(Block block) {
        Belief b = this.getBelief();
        BlobMap<AccountKey, SignedData<Order>> orders = b.getOrders();
        Order myOrder = b.getOrder(this.peerKey);
        if (myOrder == null) {
            myOrder = Order.create();
        }
        Order newChain = myOrder.append(this.sign(block));
        SignedData<Order> newSignedOrder = this.sign(newChain);
        ABlobMap newChains = orders.assoc(this.peerKey, newSignedOrder);
        Belief newBelief = b.withOrders((BlobMap<AccountKey, SignedData<Order>>)newChains);
        return this.updateConsensus(newBelief);
    }

    public long getConsensusPoint() {
        Order order = this.getPeerOrder();
        if (order == null) {
            return 0L;
        }
        return order.getConsensusPoint();
    }

    public Order getPeerOrder() {
        return this.getBelief().getOrder(this.peerKey);
    }

    public Order getOrder(AccountKey peerKey) {
        return this.getBelief().getOrder(peerKey);
    }

    public State asOf(CVMLong timestamp) {
        return Utils.stateAsOf(this.states, timestamp);
    }

    public AVector<State> asOfRange(CVMLong timestamp, long interval, int count) {
        return Utils.statesAsOfRange(this.states, timestamp, interval, count);
    }

    public Hash getNetworkID() {
        return ((State)this.getStates().get(0)).getHash();
    }
}

