/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.peer;

import convex.cli.peer.SessionItem;
import convex.core.data.AccountKey;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Session {
    protected List<SessionItem> items = new ArrayList<SessionItem>();

    public void load(File filename) throws IOException {
        this.items.clear();
        if (filename.exists()) {
            FileInputStream stream = new FileInputStream(filename);
            Properties values2 = new Properties();
            values2.load(stream);
            for (String name : values2.stringPropertyNames()) {
                String line = values2.getProperty(name, "");
                SessionItem item = SessionItem.createFromString(line);
                this.items.add(item);
            }
        }
    }

    public void addPeer(AccountKey accountKey, String hostname, String etchFilename) {
        SessionItem item = SessionItem.create(accountKey, hostname, etchFilename);
        this.items.add(item);
    }

    public void removePeer(AccountKey accountKey) {
        for (SessionItem item : this.items) {
            if (!item.getAccountKey().equals(accountKey)) continue;
            this.items.remove(item);
            return;
        }
    }

    public void store(File filename) throws IOException {
        FileOutputStream stream = new FileOutputStream(filename);
        Properties values2 = new Properties();
        int index = 0;
        for (SessionItem item : this.items) {
            values2.setProperty(String.valueOf(index), item.toString());
            ++index;
        }
        values2.store(stream, "Convex Session");
    }

    public int getSize() {
        return this.items.size();
    }

    public boolean isPeer(AccountKey accountKey) {
        SessionItem item = this.getItemFromAccountKey(accountKey);
        return item != null;
    }

    public SessionItem getItemFromIndex(int index) {
        return this.items.get(index);
    }

    public SessionItem getItemFromAccountKey(AccountKey accountKey) {
        for (SessionItem item : this.items) {
            if (!item.getAccountKey().equals(accountKey)) continue;
            return item;
        }
        return null;
    }

    public String[] getPeerHostnameList() {
        String[] result = new String[this.items.size()];
        int index = 0;
        for (SessionItem item : this.items) {
            result[index] = item.getHostname();
            ++index;
        }
        return result;
    }
}

