/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import ch.qos.logback.classic.Level;
import convex.api.Convex;
import convex.api.ConvexRemote;
import convex.cli.Account;
import convex.cli.CLIError;
import convex.cli.ExitCodes;
import convex.cli.Helpers;
import convex.cli.Key;
import convex.cli.Local;
import convex.cli.Peer;
import convex.cli.Query;
import convex.cli.Status;
import convex.cli.Transaction;
import convex.cli.output.RecordOutput;
import convex.cli.peer.SessionItem;
import convex.core.Result;
import convex.core.crypto.AKeyPair;
import convex.core.crypto.PFXTools;
import convex.core.data.AccountKey;
import convex.core.data.Address;
import convex.core.init.Init;
import convex.core.util.Utils;
import java.io.Console;
import java.io.File;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="convex", subcommands={Account.class, Key.class, Local.class, Peer.class, Query.class, Status.class, Transaction.class, CommandLine.HelpCommand.class}, usageHelpAutoWidth=true, sortOptions=false, mixinStandardHelpOptions=true, descriptionHeading="%nDescription:%n%n", parameterListHeading="%nParameters:%n", optionListHeading="%nOptions:%n", commandListHeading="%nCommands:%n", versionProvider=VersionProvider.class, description={"Convex Command Line Interface"})
public class Main
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(Main.class);
    CommandLine commandLine = new CommandLine(this);
    @CommandLine.Option(names={"-c", "--config"}, scope=CommandLine.ScopeType.INHERIT, description={"Use the specified config file. If not specified, will check ~/.convex/convex.config%n All parameters to this app can be set by removing the leading '--', and adding a leading 'convex.'.%n So to set the keystore filename you can write 'convex.keystore=my_keystore_filename.dat'%nTo set a sub command such as `./convex peer start index=4` index parameter you need to write 'convex.peer.start.index=4'"})
    private String configFilename;
    @CommandLine.Option(names={"-e", "--etch"}, scope=CommandLine.ScopeType.INHERIT, description={"Convex Etch database filename. A temporary storage file will be created if required."})
    private String etchStoreFilename;
    @CommandLine.Option(names={"-k", "--keystore"}, defaultValue="~/.convex/keystore.pfx", scope=CommandLine.ScopeType.INHERIT, description={"Keystore filename. Default: ${DEFAULT-VALUE}"})
    private String keyStoreFilename;
    @CommandLine.Option(names={"-p", "--password"}, scope=CommandLine.ScopeType.INHERIT, description={"Password to read/write to the Keystore"})
    private String password;
    @CommandLine.Option(names={"-pi", "--password-interactive"}, scope=CommandLine.ScopeType.INHERIT, description={"Specify to request an interactive password prompt if not otherwise specified"})
    private boolean passwordInteractive;
    @CommandLine.Option(names={"-s", "--session"}, defaultValue="~/.convex/session.conf", scope=CommandLine.ScopeType.INHERIT, description={"Session filename. Default: ${DEFAULT-VALUE}"})
    private String sessionFilename;
    @CommandLine.Option(names={"-v", "--verbose"}, scope=CommandLine.ScopeType.INHERIT, description={"Show more verbose log information. You can increase verbosity by using multiple -v or -vvv"})
    private boolean[] verbose = new boolean[0];
    boolean passwordAcquired = false;
    private boolean keyStoreLoaded = false;
    private KeyStore keyStore = null;

    public Main() {
        this.commandLine = this.commandLine.setExecutionExceptionHandler(new ExceptionHandler());
    }

    @Override
    public void run() {
        CommandLine.usage(new Main(), System.out);
    }

    public static void main(String[] args2) {
        Main mainApp = new Main();
        int result = mainApp.mainExecute(args2);
        System.exit(result);
    }

    public int mainExecute(String[] args2) {
        this.commandLine.setUsageHelpLongOptionsMaxWidth(40).setUsageHelpWidth(160);
        try {
            this.commandLine.parseArgs(args2);
            this.loadConfig();
        }
        catch (Throwable t) {
            System.err.println("unable to parse arguments " + t);
        }
        ch.qos.logback.classic.Logger parentLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
        Level[] verboseLevels = new Level[]{Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE, Level.ALL};
        parentLogger.setLevel(Level.WARN);
        if (this.verbose.length > 0 && this.verbose.length <= verboseLevels.length) {
            parentLogger.setLevel(verboseLevels[this.verbose.length]);
            log.info("set level to {}", (Object)parentLogger.getLevel());
        }
        int result = 0;
        result = this.commandLine.execute(args2);
        return result;
    }

    protected boolean loadConfig() {
        String filename = null;
        if (this.configFilename != null && !this.configFilename.isEmpty()) {
            filename = Helpers.expandTilde(this.configFilename);
        }
        if (filename != null) {
            File configFile = new File(filename);
            if (configFile.exists()) {
                CommandLine.PropertiesDefaultProvider defaultProvider = new CommandLine.PropertiesDefaultProvider(configFile);
                this.commandLine.setDefaultValueProvider(defaultProvider);
                return true;
            }
            log.warn("Config file does not exist: " + this.configFilename);
            return false;
        }
        return false;
    }

    public String getSessionFilename() {
        if (this.sessionFilename != null) {
            return Helpers.expandTilde(this.sessionFilename.strip());
        }
        return null;
    }

    public String getPassword() {
        if (!this.passwordAcquired) {
            if (this.passwordInteractive) {
                Console console = System.console();
                this.password = console.readLine("Password: ", new Object[0]);
            } else if (this.password == null) {
                log.warn("No password for keystore: defaulting to blank password");
                this.password = "";
            }
            this.passwordAcquired = true;
        }
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getKeyStoreFilename() {
        if (this.keyStoreFilename != null) {
            return Helpers.expandTilde(this.keyStoreFilename).strip();
        }
        return null;
    }

    public String getEtchStoreFilename() {
        if (this.etchStoreFilename != null) {
            return Helpers.expandTilde(this.etchStoreFilename).strip();
        }
        return null;
    }

    public KeyStore getKeystore() {
        if (!this.keyStoreLoaded) {
            this.keyStore = this.loadKeyStore(false);
            this.keyStoreLoaded = true;
        }
        return this.keyStore;
    }

    public KeyStore getKeystore(boolean create) {
        if (!this.keyStoreLoaded) {
            this.keyStore = this.loadKeyStore(create);
            if (this.keyStore == null) {
                throw new CLIError("Keystore does not exist!");
            }
            this.keyStoreLoaded = true;
        }
        return this.keyStore;
    }

    KeyStore loadKeyStore(boolean isCreate) {
        String password = this.getPassword();
        File keyFile = new File(this.getKeyStoreFilename());
        try {
            if (keyFile.exists()) {
                this.keyStore = PFXTools.loadStore(keyFile, password);
            } else if (isCreate) {
                log.warn("No keystore exists, creating at: " + keyFile.getCanonicalPath());
                Helpers.createPath(keyFile);
                this.keyStore = PFXTools.createStore(keyFile, password);
            }
        }
        catch (Exception t) {
            throw new CLIError("Unable to read keystore at: " + keyFile, t);
        }
        this.keyStoreLoaded = true;
        return this.keyStore;
    }

    public AKeyPair loadKeyFromStore(String publicKey) {
        if (publicKey == null) {
            return null;
        }
        AKeyPair keyPair = null;
        if ((publicKey = publicKey.trim()) != null) {
            publicKey = publicKey.toLowerCase().replaceFirst("^0x", "").strip();
        }
        if (publicKey.isEmpty()) {
            return null;
        }
        String password = this.getPassword();
        File keyFile = new File(this.getKeyStoreFilename());
        try {
            if (!keyFile.exists()) {
                throw new Error("Cannot find keystore file " + keyFile.getCanonicalPath());
            }
            KeyStore keyStore = PFXTools.loadStore(keyFile, password);
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (alias.indexOf(publicKey) != 0) continue;
                log.trace("found keypair " + alias);
                keyPair = PFXTools.getKeyPair(keyStore, alias, password);
                break;
            }
        }
        catch (Throwable t) {
            throw new CLIError("Cannot load key store", t);
        }
        return keyPair;
    }

    public Convex connectToSessionPeer(String hostname, int port, Address address, AKeyPair keyPair) {
        ConvexRemote convex = null;
        try {
            SessionItem item;
            if (port == 0 && (item = Helpers.getSessionItem(this.getSessionFilename())) != null) {
                port = item.getPort();
            }
            if (port == 0) {
                throw new Error("Cannot find a local port or you have not set a valid port number");
            }
            InetSocketAddress host2 = new InetSocketAddress(hostname.strip(), port);
            convex = Convex.connect(host2, address, keyPair);
        }
        catch (Throwable t) {
            throw new Error("Cannot connect to a local peer " + t);
        }
        return convex;
    }

    public Convex connectAsPeer(int peerIndex) throws Error {
        ConvexRemote convex = null;
        try {
            SessionItem item = Helpers.getSessionItem(this.getSessionFilename(), peerIndex);
            AccountKey peerKey = item.getAccountKey();
            log.debug("peer public key {}", (Object)peerKey.toHexString());
            AKeyPair keyPair = this.loadKeyFromStore(peerKey.toHexString());
            log.debug("peer key pair {}", (Object)keyPair.getAccountKey().toHexString());
            Address address = Init.getGenesisPeerAddress(peerIndex);
            log.debug("peer address {}", (Object)address);
            InetSocketAddress host2 = item.getHostAddress();
            log.debug("connect to peer {}", (Object)host2);
            convex = Convex.connect(host2, address, keyPair);
        }
        catch (Throwable t) {
            throw new Error("Cannot connect as a peer " + t);
        }
        return convex;
    }

    public List<AKeyPair> generateKeyPairs(int count) {
        ArrayList<AKeyPair> keyPairList = new ArrayList<AKeyPair>(count);
        for (int index = 0; index < count; ++index) {
            AKeyPair keyPair = AKeyPair.generate();
            keyPairList.add(keyPair);
            this.addKeyPairToStore(keyPair);
        }
        return keyPairList;
    }

    public void addKeyPairToStore(AKeyPair keyPair) {
        String password = this.getPassword();
        KeyStore keyStore = this.getKeystore();
        if (keyStore == null) {
            throw new CLIError("Trying to add key pair but keystore does not exist");
        }
        try {
            PFXTools.setKeyPair(keyStore, keyPair, password);
        }
        catch (Throwable t) {
            throw new CLIError("Cannot store the key to the key store " + t);
        }
    }

    void saveKeyStore() {
        if (this.keyStore == null) {
            throw new CLIError("Trying to save a keystore that has not been loaded!");
        }
        try {
            PFXTools.saveStore(this.keyStore, new File(this.getKeyStoreFilename()), this.password);
        }
        catch (Throwable t) {
            throw (RuntimeException)Utils.sneakyThrow(t);
        }
    }

    int[] getPortList(String[] ports, int count) throws NumberFormatException {
        Pattern rangePattern = Pattern.compile("([0-9]+)\\s*-\\s*([0-9]*)");
        List<String> portTextList = Helpers.splitArrayParameter(ports);
        ArrayList<Integer> portList = new ArrayList<Integer>();
        int countLeft = count;
        for (int index = 0; index < portTextList.size() && countLeft > 0; ++index) {
            String item = portTextList.get(index);
            Matcher matcher = rangePattern.matcher(item);
            if (matcher.matches()) {
                int portFrom = Integer.parseInt(matcher.group(1));
                int portTo = portFrom + count + 1;
                if (!matcher.group(2).isEmpty()) {
                    portTo = Integer.parseInt(matcher.group(2));
                }
                for (int portIndex = portFrom; portIndex <= portTo && countLeft > 0; ++portIndex, --countLeft) {
                    portList.add(portIndex);
                }
                continue;
            }
            if (item.strip().length() == 0) continue;
            portList.add(Integer.parseInt(item));
            --countLeft;
        }
        return portList.stream().mapToInt(Integer::intValue).toArray();
    }

    public void println(String s) {
        if (s == null) {
            s = "null";
        }
        this.commandLine.getOut().println(s);
    }

    public void printError(Result result) {
        this.commandLine.getErr().println(result.toString());
    }

    public void printResult(Result result) {
        this.commandLine.getOut().println(result.toString());
    }

    public void printRecord(RecordOutput output) {
        output.writeToStream(this.commandLine.getOut());
    }

    public void println(Object value) {
        this.println(Utils.toString(value));
    }

    private class ExceptionHandler
    implements CommandLine.IExecutionExceptionHandler {
        private ExceptionHandler() {
        }

        @Override
        public int handleExecutionException(Exception ex, CommandLine commandLine, CommandLine.ParseResult parseResult) throws Exception {
            PrintWriter err = commandLine.getErr();
            if (ex instanceof CLIError) {
                CLIError ce = (CLIError)ex;
                err.println(ce.getMessage());
                Throwable cause = ce.getCause();
                if (cause != null) {
                    err.println("Underlying cause: ");
                    cause.printStackTrace(err);
                }
            } else {
                ex.printStackTrace(err);
            }
            return ExitCodes.getExitCode(ex);
        }
    }

    public static final class VersionProvider
    implements CommandLine.IVersionProvider {
        @Override
        public String[] getVersion() throws Exception {
            String s = Main.class.getPackage().getImplementationVersion();
            return new String[]{s};
        }
    }
}

