/*
 * Decompiled with CFR 0.152.
 */
package convex.peer;

import convex.core.Peer;
import convex.core.State;
import convex.core.crypto.AKeyPair;
import convex.core.data.Hash;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.store.AStore;
import convex.core.store.Stores;
import convex.core.util.Utils;
import convex.peer.ConnectionManager;
import convex.peer.IServerEvent;
import convex.peer.Server;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class API {
    private static final Logger log = LoggerFactory.getLogger(API.class.getName());

    public static Server launchPeer(Map<Keyword, Object> peerConfig) {
        HashMap<Keyword, Object> config = new HashMap<Keyword, Object>(peerConfig);
        if (!(config.containsKey(Keywords.STATE) || config.containsKey(Keywords.STORE) || config.containsKey(Keywords.SOURCE))) {
            throw new IllegalArgumentException("Peer launch requires a genesis :state, remote :source or existing :store in config");
        }
        if (!config.containsKey(Keywords.KEYPAIR)) {
            throw new IllegalArgumentException("Peer launch requires a " + Keywords.KEYPAIR + " in config");
        }
        try {
            InetAddress ip;
            if (!config.containsKey(Keywords.PORT)) {
                config.put(Keywords.PORT, null);
            }
            if (!config.containsKey(Keywords.STORE)) {
                config.put(Keywords.STORE, Stores.getGlobalStore());
            }
            if (!config.containsKey(Keywords.RESTORE)) {
                config.put(Keywords.RESTORE, true);
            }
            if (!config.containsKey(Keywords.PERSIST)) {
                config.put(Keywords.PERSIST, true);
            }
            if (!config.containsKey(Keywords.AUTO_MANAGE)) {
                config.put(Keywords.AUTO_MANAGE, true);
            }
            if (config.containsKey(Keywords.URL) && !config.containsKey(Keywords.BIND_ADDRESS) && !(ip = InetAddress.getByName((String)config.get(Keywords.URL))).isAnyLocalAddress() && !ip.isLoopbackAddress()) {
                config.put(Keywords.BIND_ADDRESS, "0.0.0.0");
            }
            Server server = Server.create(config);
            server.launch();
            return server;
        }
        catch (Throwable t) {
            log.error("Error launching peer: ", t);
            t.printStackTrace();
            throw (RuntimeException)Utils.sneakyThrow(t);
        }
    }

    public static List<Server> launchLocalPeers(List<AKeyPair> keyPairs, State genesisState) {
        return API.launchLocalPeers(keyPairs, genesisState, null, null);
    }

    public static List<Server> launchLocalPeers(List<AKeyPair> keyPairs, State genesisState, int[] peerPorts, IServerEvent event) {
        Server server;
        int count = keyPairs.size();
        ArrayList<Server> serverList = new ArrayList<Server>();
        HashMap<Keyword, Object> config = new HashMap<Keyword, Object>();
        config.put(Keywords.PORT, null);
        config.put(Keywords.STATE, genesisState);
        AStore store = Stores.current();
        config.put(Keywords.STORE, store);
        config.put(Keywords.AUTO_MANAGE, true);
        if (event != null) {
            config.put(Keywords.EVENT_HOOK, event);
        }
        for (int i = 0; i < count; ++i) {
            AKeyPair keyPair = keyPairs.get(i);
            config.put(Keywords.KEYPAIR, keyPair);
            if (peerPorts != null) {
                if (peerPorts.length > i) {
                    config.put(Keywords.PORT, peerPorts[i]);
                } else {
                    config.put(Keywords.PORT, 0);
                }
            }
            server = API.launchPeer(config);
            serverList.add(server);
        }
        Server genesisServer = (Server)serverList.get(0);
        genesisServer.setHostname("localhost:" + genesisServer.getPort());
        for (int i = 1; i < count; ++i) {
            server = (Server)serverList.get(i);
            ConnectionManager cm = server.getConnectionManager();
            cm.connectToPeer(genesisServer.getHostAddress());
            genesisServer.getConnectionManager().connectToPeer(server.getHostAddress());
            server.setHostname("localhost:" + server.getPort());
        }
        return serverList;
    }

    public static boolean isNetworkReady(List<Server> serverList, long timeoutMillis) {
        boolean isReady = false;
        long timeoutTime = Utils.getTimeMillis() + timeoutMillis;
        while (timeoutTime > Utils.getTimeMillis()) {
            isReady = true;
            Hash consensusHash = null;
            for (Server server : serverList) {
                Peer peer = server.getPeer();
                if (consensusHash == null) {
                    consensusHash = peer.getConsensusState().getHash();
                }
                if (consensusHash.equals(peer.getConsensusState().getHash())) continue;
                isReady = false;
            }
            if (isReady) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return isReady;
    }
}

