/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.AObject;
import convex.core.data.ASet;
import convex.core.data.Blob;
import convex.core.data.BlobBuilder;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.IRefFunction;
import convex.core.data.IValidated;
import convex.core.data.IWriteable;
import convex.core.data.RefDirect;
import convex.core.data.RefSoft;
import convex.core.data.Strings;
import convex.core.data.prim.CVMBool;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.RT;
import convex.core.store.AStore;
import convex.core.store.Stores;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public abstract class Ref<T extends ACell>
extends AObject
implements Comparable<Ref<T>>,
IWriteable,
IValidated {
    public static final int UNKNOWN = 0;
    public static final int STORED = 1;
    public static final int PERSISTED = 2;
    public static final int VALIDATED = 3;
    public static final int ANNOUNCED = 4;
    public static final int INTERNAL = 5;
    public static final int MARKED = 15;
    public static final int MAX_STATUS = 5;
    public static final int STATUS_MASK = 15;
    public static final int KNOWN_EMBEDDED_MASK = 16;
    public static final int NON_EMBEDDED_MASK = 32;
    public static final int EMBEDDING_MASK = 48;
    public static final int VERIFIED_MASK = 64;
    public static final int BAD_MASK = 128;
    public static final int VERIFICATION_MASK = 192;
    public static final int INTERNAL_FLAGS = 85;
    public static final int INVALID = -1;
    public static final RefDirect<?> NULL_VALUE = RefDirect.create(null, Hash.NULL_HASH, 85);
    public static final RefDirect<CVMBool> TRUE_VALUE = RefDirect.create(CVMBool.TRUE, Hash.TRUE_HASH, 85);
    public static final RefDirect<CVMBool> FALSE_VALUE = RefDirect.create(CVMBool.FALSE, Hash.FALSE_HASH, 85);
    public static final int INDIRECT_ENCODING_LENGTH = 33;
    protected Hash hash;
    protected int flags;

    protected Ref(Hash hash, int flags) {
        this.hash = hash;
        this.flags = flags;
    }

    public int getStatus() {
        return this.flags & 0xF;
    }

    public int flagsWithStatus(int newStatus) {
        return this.flags & 0xFFFFFFF0 | newStatus & 0xF;
    }

    public int getFlags() {
        return this.flags;
    }

    public Ref<T> withMinimumStatus(int newStatus) {
        int status = this.getStatus();
        if (status >= (newStatus &= 0xF)) {
            return this;
        }
        if (status > 5) {
            throw new IllegalArgumentException("Ref status not recognised: " + newStatus);
        }
        int newFlags = this.flags & 0xFFFFFFF0 | newStatus;
        return this.withFlags(newFlags);
    }

    public abstract Ref<T> withFlags(int var1);

    public abstract T getValue();

    public int hashCode() {
        return this.getHash().hashCode();
    }

    @Override
    public boolean print(BlobBuilder bb, long limit) {
        bb.append("#ref {:hash #hash ");
        bb.append(this.hash == null ? "nil" : this.hash.toString());
        bb.append(", :flags ");
        bb.append(Integer.toString(this.flags));
        bb.append("}");
        return bb.check(limit);
    }

    public String toString() {
        BlobBuilder sb = new BlobBuilder();
        this.print(sb, 10000L);
        return Strings.create(sb.toBlob()).toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Ref)) {
            return false;
        }
        return this.equals((Ref)o);
    }

    public abstract boolean equals(Ref<T> var1);

    @Override
    public int compareTo(Ref<T> a) {
        if (this == a) {
            return 0;
        }
        return this.getHash().compareTo(a.getHash());
    }

    public abstract Hash getHash();

    public final Hash cachedHash() {
        return this.hash;
    }

    public static <T extends ACell> Ref<T> get(T value) {
        if (value == null) {
            return NULL_VALUE;
        }
        return value.getRef();
    }

    public static <T extends ACell> Ref<T> get(Object value) {
        if (value == null) {
            return NULL_VALUE;
        }
        if (value instanceof ACell) {
            return ((ACell)value).getRef();
        }
        return ((ACell)RT.cvm(value)).getRef();
    }

    public static <T extends ACell> RefSoft<T> forHash(Hash hash) {
        return RefSoft.createForHash(hash);
    }

    public Ref<T> markEmbedded(boolean isEmbedded) {
        int newFlags;
        this.flags = newFlags = Ref.mergeFlags(this.flags, isEmbedded ? 16 : 32);
        return this;
    }

    public Ref<T> setFlags(int newFlags) {
        this.flags = newFlags;
        return this;
    }

    public static <T extends ACell> Ref<T> readRaw(ByteBuffer data) {
        Hash h = Hash.readRaw(data);
        RefSoft<T> ref = Ref.forHash(h);
        return ref.markEmbedded(false);
    }

    @Override
    public void validate() throws InvalidDataException {
        if (this.hash != null) {
            this.hash.validate();
        }
        if (this.getStatus() < 3) {
            T o = this.getValue();
            ((ACell)o).validate();
        }
    }

    public abstract boolean isDirect();

    public boolean isPersisted() {
        return this.getStatus() >= 2;
    }

    public boolean isMarked() {
        return this.getStatus() >= 15;
    }

    public <R extends ACell> Ref<R> persist(Consumer<Ref<ACell>> noveltyHandler) {
        int status = this.getStatus();
        if (status >= 2) {
            return this;
        }
        AStore store = Stores.current();
        return store.storeRef(this, 2, noveltyHandler);
    }

    public <R extends ACell> Ref<R> persist() {
        return this.persist(null);
    }

    public static Set<Ref<?>> accumulateRefSet(Object a) {
        HashSet hs = new HashSet();
        Ref.accumulateRefSet(a, hs);
        return hs;
    }

    private static void accumulateRefSet(Object a, HashSet<Ref<?>> hs) {
        if (a instanceof Ref) {
            Ref ref = (Ref)a;
            if (hs.contains(ref)) {
                return;
            }
            hs.add(ref);
            Ref.accumulateRefSet(ref.getValue(), hs);
        } else if (a instanceof ACell) {
            ACell rc = (ACell)a;
            rc.updateRefs(r -> {
                Ref.accumulateRefSet(r, hs);
                return r;
            });
        }
    }

    public static <T extends ACell> Ref<T>[] updateRefs(Ref<T>[] refs, IRefFunction func) {
        Ref<T>[] newRefs = refs;
        int n = refs.length;
        for (int i = 0; i < n; ++i) {
            Ref<T> ref = refs[i];
            Ref<?> newRef = func.apply(ref);
            if (ref == newRef) continue;
            if (newRefs == refs) {
                newRefs = (Ref[])refs.clone();
            }
            newRefs[i] = newRef;
        }
        return newRefs;
    }

    public static <T extends ACell> Ref<T>[] createArray(T[] values) {
        int n = values.length;
        Ref[] refs = new Ref[n];
        for (int i = 0; i < n; ++i) {
            refs[i] = Ref.get(values[i]);
        }
        return refs;
    }

    public ASet<ACell> addAllToSet(ASet<ACell> store) {
        store = store.includeRef(this);
        T rc = this.getValue();
        int n = ((ACell)rc).getRefCount();
        for (int i = 0; i < n; ++i) {
            Ref rr = ((ACell)rc).getRef(i);
            if (rr.isEmbedded()) continue;
            store = rr.addAllToSet(store);
        }
        return store;
    }

    public final boolean isEmbedded() {
        if ((this.flags & 0x10) != 0) {
            return true;
        }
        if ((this.flags & 0x20) != 0) {
            return false;
        }
        boolean em = Format.isEmbedded(this.getValue());
        this.flags |= em ? 16 : 32;
        return em;
    }

    public Ref<T> toDirect() {
        return RefDirect.create(this.getValue(), this.hash, this.flags);
    }

    public <R extends ACell> Ref<R> persistShallow() {
        return this.persistShallow(null);
    }

    public <R extends ACell> Ref<R> persistShallow(Consumer<Ref<ACell>> noveltyHandler) {
        AStore store = Stores.current();
        return store.storeTopRef(this, 1, noveltyHandler);
    }

    public abstract Ref<T> withValue(T var1);

    @Override
    public final int encode(byte[] bs, int pos) {
        if (this.isEmbedded()) {
            T value = this.getValue();
            if (value == null) {
                bs[pos++] = 0;
                return pos;
            }
            return ((ACell)value).encode(bs, pos);
        }
        bs[pos++] = 32;
        return this.getHash().encodeRawData(bs, pos);
    }

    @Override
    public final ByteBuffer write(ByteBuffer bb) {
        if (this.isEmbedded()) {
            return Format.write(bb, this.getValue());
        }
        bb = bb.put((byte)32);
        return this.getHash().writeToBuffer(bb);
    }

    @Override
    protected Blob createEncoding() {
        if (this.isEmbedded()) {
            return Format.encodedBlob(this.getValue());
        }
        byte[] bs = new byte[33];
        Hash h = this.getHash();
        int pos = 0;
        bs[pos++] = 32;
        pos = h.encodeRawData(bs, pos);
        return Blob.wrap(bs, 0, pos);
    }

    public final long getEncodingLength() {
        if (this.isEmbedded()) {
            T value = this.getValue();
            if (value == null) {
                return 1L;
            }
            return ((ACell)value).getEncodingLength();
        }
        return 33L;
    }

    public long getMemorySize() {
        T value = this.getValue();
        if (value == null) {
            return 0L;
        }
        return ((ACell)value).getMemorySize();
    }

    public void findMissing(HashSet<Hash> missingSet) {
        if (this.getStatus() >= 2) {
            return;
        }
        if (this.isMissing()) {
            missingSet.add(this.getHash());
        } else {
            T val = this.getValue();
            int n = ((ACell)val).getRefCount();
            for (int i = 0; i < n; ++i) {
                Ref r = ((ACell)val).getRef(i);
                r.findMissing(missingSet);
            }
        }
    }

    public abstract boolean isMissing();

    public static int mergeFlags(int a, int b) {
        return (a | b) & 0xFFFFFFF0 | Math.max(a & 0xF, b & 0xF);
    }

    public abstract Ref<T> ensureCanonical();
}

