/*
 * Decompiled with CFR 0.152.
 */
package convex.cli;

import convex.api.Convex;
import convex.cli.Account;
import convex.cli.CLIError;
import convex.cli.Main;
import convex.cli.output.RecordOutput;
import convex.core.crypto.AKeyPair;
import convex.core.data.Address;
import convex.core.util.Utils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="create", mixinStandardHelpOptions=true, description={"Creates an account using a public/private key from the keystore.%nYou must provide a valid keystore password to the keystore.%nIf the keystore is not at the default location also the keystore filename."})
public class AccountCreate
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(AccountCreate.class);
    @CommandLine.ParentCommand
    private Account accountParent;
    @CommandLine.Option(names={"--public-key"}, defaultValue="", description={"Hex string of the public key in the Keystore to use to create an account.%nYou only need to enter in the first distinct hex values of the public key.%nFor example: 0xf0234 or f0234"})
    private String keystorePublicKey;
    @CommandLine.Option(names={"--port"}, description={"Port number to connect to a peer."})
    private int port = 0;
    @CommandLine.Option(names={"--host"}, defaultValue="localhost", description={"Hostname to connect to a peer. Default: ${DEFAULT-VALUE}"})
    private String hostname;
    @CommandLine.Option(names={"-f", "--fund"}, description={"Fund the account with the default fund amount."})
    private boolean isFund;

    @Override
    public void run() {
        Main mainParent = this.accountParent.mainParent;
        RecordOutput output = new RecordOutput();
        AKeyPair keyPair = null;
        if (!this.keystorePublicKey.isEmpty() && (keyPair = mainParent.loadKeyFromStore(this.keystorePublicKey)) == null) {
            throw new CLIError("Cannot find the provided public key in keystore: " + this.keystorePublicKey);
        }
        if (keyPair == null) {
            List<AKeyPair> keyPairList = mainParent.generateKeyPairs(1);
            keyPair = keyPairList.get(0);
            output.addField("Public Key", keyPair.getAccountKey().toHexString());
        }
        Convex convex = null;
        try {
            convex = mainParent.connectAsPeer(0);
            Address address = convex.createAccountSync(keyPair.getAccountKey());
            output.addField("Address", address.longValue());
            if (this.isFund) {
                convex.transferSync(address, 100000000L);
                convex = mainParent.connectToSessionPeer(this.hostname, this.port, address, keyPair);
                Long balance = convex.getBalance(address);
                output.addField("Balance", balance);
            }
            output.addField("Account usage", String.format("to use this key can use the options --address=%d --public-key=%s", address.toLong(), Utils.toFriendlyHexString(keyPair.getAccountKey().toHexString(), 6)));
            output.writeToStream(mainParent.commandLine.getOut());
        }
        catch (Throwable t) {
            throw new CLIError("Error creating account", t);
        }
    }
}

