/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.ASequence;
import convex.core.data.AVector;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.data.VectorLeaf;
import convex.core.data.Vectors;
import convex.core.exceptions.InvalidDataException;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class VectorArray<T extends ACell>
extends AVector<T> {
    private final T[] array;
    private final int offset;
    private final int stride;

    protected VectorArray(long count, T[] array, int offset, int stride) {
        super(count);
        this.array = array;
        this.offset = offset;
        this.stride = stride;
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int estimatedEncodingSize() {
        return 100;
    }

    @Override
    public T get(long i) {
        if (i < 0L || i >= this.count) {
            throw new IndexOutOfBoundsException("Index: " + i);
        }
        return this.array[this.offset + (int)(i * (long)this.stride)];
    }

    @Override
    public AVector<T> appendChunk(VectorLeaf<T> chunkVector) {
        return this.toVector().appendChunk(chunkVector);
    }

    @Override
    public VectorLeaf<T> getChunk(long offset) {
        return this.toVector().getChunk(offset);
    }

    @Override
    public AVector<T> append(T value) {
        return this.toVector().append(value);
    }

    @Override
    public boolean isFullyPacked() {
        return false;
    }

    @Override
    public boolean anyMatch(Predicate<? super T> pred) {
        return false;
    }

    @Override
    public boolean allMatch(Predicate<? super T> pred) {
        return false;
    }

    @Override
    public <R extends ACell> AVector<R> map(Function<? super T, ? extends R> mapper) {
        return null;
    }

    @Override
    public <R extends ACell> AVector<R> concat(ASequence<R> b) {
        return this.toVector().concat((ASequence)b);
    }

    @Override
    public <R> R reduce(BiFunction<? super R, ? super T, ? extends R> func, R value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Spliterator<T> spliterator(long position) {
        return null;
    }

    @Override
    public ListIterator<T> listIterator(long index) {
        return null;
    }

    @Override
    public boolean isCanonical() {
        return false;
    }

    @Override
    public final boolean isCVMValue() {
        return false;
    }

    @Override
    public AVector<T> updateRefs(IRefFunction func) {
        return this.toVector().updateRefs(func);
    }

    @Override
    public long commonPrefixLength(AVector<T> b) {
        return this.toVector().commonPrefixLength(b);
    }

    @Override
    public AVector<T> next() {
        if (this.count == 0L) {
            return null;
        }
        return this.slice(1L, this.count - 1L);
    }

    @Override
    public <R extends ACell> AVector<R> assoc(long i, R value) {
        return this.toVector().assoc(i, (ACell)value);
    }

    @Override
    public long longIndexOf(Object value) {
        return 0L;
    }

    @Override
    public long longLastIndexOf(Object value) {
        return 0L;
    }

    @Override
    public void forEach(Consumer<? super T> action) {
    }

    @Override
    public void visitElementRefs(Consumer<Ref<T>> f) {
    }

    @Override
    public Ref<T> getElementRef(long index) {
        return Ref.get(this.get(index));
    }

    @Override
    public <R extends ACell> VectorArray<R> subVector(long start, long length) {
        this.checkRange(start, length);
        if (length == this.count) {
            return this;
        }
        return new VectorArray(length, this.array, this.offset + (int)(start * (long)this.stride), this.stride);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        return this.toVector().encode(bs, pos);
    }

    @Override
    public AVector<T> toVector() {
        if (this.stride == 1) {
            Vectors.create(this.array, this.offset, (int)this.count);
        }
        return Vectors.create(this.toCellArray());
    }

    @Override
    public void validateCell() throws InvalidDataException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        return this.toVector().encodeRaw(bs, pos);
    }

    @Override
    public int getRefCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AVector<T> toCanonical() {
        return this.toVector();
    }

    @Override
    protected <R> void copyToArray(R[] arr, int offset) {
    }
}

