/*
 * Decompiled with CFR 0.152.
 */
package convex.net.message;

import convex.core.Result;
import convex.core.data.ACell;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.data.prim.CVMLong;
import convex.core.store.AStore;
import convex.net.MessageType;
import convex.net.message.Message;
import convex.peer.Server;
import java.util.function.Consumer;

public class MessageLocal
extends Message {
    protected Server server;
    protected AStore store;
    protected Consumer<Result> resultHandler;

    protected MessageLocal(MessageType type, ACell payload, Server server, Consumer<Result> handler) {
        super(type, payload);
        this.server = server;
        this.resultHandler = handler;
    }

    public static MessageLocal create(MessageType type, ACell payload, Server server, Consumer<Result> handler) {
        return new MessageLocal(type, payload, server, handler);
    }

    @Override
    public boolean reportResult(Result res) {
        this.resultHandler.accept(res);
        return true;
    }

    @Override
    public boolean reportResult(CVMLong id, ACell reply) {
        this.resultHandler.accept(Result.create(id, reply));
        return true;
    }

    @Override
    public String getOriginString() {
        return "Local Peer";
    }

    @Override
    public boolean sendData(ACell data) {
        if (data != null) {
            this.store.storeRef(data.getRef(), 1, null);
        }
        return true;
    }

    @Override
    public boolean sendMissingData(Hash hash) {
        Ref ref = this.server.getStore().refForHash(hash);
        if (ref != null) {
            this.store.storeRef(ref, 1, null);
        }
        return true;
    }
}

