/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.data.ACell;
import convex.core.data.Format;
import convex.core.data.Hash;
import convex.core.data.Ref;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Utils;

public class RefDirect<T extends ACell>
extends Ref<T> {
    private final T value;

    private RefDirect(T value, Hash hash, int flags) {
        super(hash, flags);
        this.value = value;
    }

    public static <T extends ACell> RefDirect<T> create(T value, Hash hash, int status) {
        int flags = status & 0xF;
        return new RefDirect<T>(value, hash, flags);
    }

    public static <T extends ACell> RefDirect<T> create(T value, Hash hash) {
        return RefDirect.create(value, hash, 0);
    }

    public static <T extends ACell> RefDirect<T> create(T value) {
        if (value == null) {
            return Ref.NULL_VALUE;
        }
        return RefDirect.create(value, null, 0);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public Hash getHash() {
        Hash newHash;
        if (this.hash != null) {
            return this.hash;
        }
        this.hash = newHash = this.value == null ? Hash.NULL_HASH : ((ACell)this.value).getHash();
        return newHash;
    }

    @Override
    public Ref<T> toDirect() {
        return this;
    }

    @Override
    public boolean equalsValue(Ref<T> a) {
        if (a == this) {
            return true;
        }
        if (this.hash != null && a.hash != null) {
            return this.hash.equals(a.hash);
        }
        return Utils.equals(this.value, a.getValue());
    }

    @Override
    public void validate() throws InvalidDataException {
        super.validate();
        if (this.isEmbedded() != Format.isEmbedded(this.value)) {
            throw new InvalidDataException("Embedded flag is wrong!", this);
        }
        if (this.value == null && this != Ref.NULL_VALUE) {
            throw new InvalidDataException("Null ref not singleton!", this);
        }
    }

    @Override
    public Ref<T> withValue(T newValue) {
        if (newValue != this.value) {
            return new RefDirect<T>(newValue, this.hash, this.flags);
        }
        return this;
    }

    @Override
    public int estimatedEncodingSize() {
        if (this.value == null) {
            return 1;
        }
        return this.isEmbedded() ? this.value.estimatedEncodingSize() : 33;
    }

    @Override
    public boolean isMissing() {
        return false;
    }

    @Override
    public RefDirect<T> withFlags(int newFlags) {
        return new RefDirect<T>(this.value, this.hash, newFlags);
    }
}

