/*
 * Decompiled with CFR 0.152.
 */
package convex.core.data;

import convex.core.crypto.Hashing;
import convex.core.data.AArrayBlob;
import convex.core.data.ABlob;
import convex.core.data.ACell;
import convex.core.data.Blob;
import convex.core.data.type.AType;
import convex.core.data.type.Types;
import convex.core.exceptions.InvalidDataException;
import convex.core.util.Errors;
import convex.core.util.Utils;
import java.nio.ByteBuffer;

public class Hash
extends AArrayBlob {
    public static final int LENGTH = 32;
    public static final AType TYPE = Types.BLOB;
    public static final Hash NULL_HASH = Hashing.sha3(new byte[]{0});
    public static final Hash TRUE_HASH = Hashing.sha3(new byte[]{-79});
    public static final Hash FALSE_HASH = Hashing.sha3(new byte[]{-80});
    public static final Hash EMPTY_HASH = Hashing.sha3(new byte[0]);

    private Hash(byte[] hashBytes, int offset) {
        super(hashBytes, offset, 32);
    }

    private Hash(byte[] hashBytes) {
        super(hashBytes, 0, 32);
    }

    public static Hash wrap(byte[] hashBytes) {
        return new Hash(hashBytes);
    }

    public static Hash wrap(AArrayBlob data) {
        if (data instanceof Hash) {
            return (Hash)data;
        }
        return Hash.wrap(data.getInternalArray(), data.getInternalOffset());
    }

    public static Hash wrap(byte[] hashBytes, int offset) {
        if (offset < 0 || offset + 32 > hashBytes.length) {
            throw new IllegalArgumentException(Errors.badRange(offset, 32L));
        }
        return new Hash(hashBytes, offset);
    }

    @Override
    public boolean equals(ABlob other) {
        if (other == null) {
            return false;
        }
        if (other instanceof Hash) {
            return this.equals((Hash)other);
        }
        if (other.count() != 32L) {
            return false;
        }
        if (other.getType() != TYPE) {
            return false;
        }
        return other.equalsBytes(this.store, this.offset);
    }

    public boolean equals(Hash other) {
        if (other == this) {
            return true;
        }
        return Utils.arrayEquals(other.store, other.offset, this.store, this.offset, 32);
    }

    public int firstInt() {
        return Utils.readInt(this.store, this.offset);
    }

    public static Hash fromHex(String hexString) {
        byte[] bs = Utils.hexToBytes(hexString);
        if (bs == null) {
            return null;
        }
        if (bs.length != 32) {
            return null;
        }
        return Hash.wrap(bs);
    }

    public static Hash wrap(AArrayBlob data, int offset, int length) {
        return Hash.wrap(data.store, data.offset + offset);
    }

    public static Hash compute(ACell value) {
        if (value == null) {
            return NULL_HASH;
        }
        return value.getHash();
    }

    public static Hash readRaw(ByteBuffer bb) {
        byte[] bs = new byte[32];
        bb.get(bs);
        return Hash.wrap(bs);
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = 49;
        bs[pos++] = 32;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public boolean isCanonical() {
        return false;
    }

    @Override
    public final boolean isCVMValue() {
        return true;
    }

    @Override
    public int estimatedEncodingSize() {
        return 33;
    }

    @Override
    public long getEncodingLength() {
        return 34L;
    }

    @Override
    public Blob getChunk(long i) {
        if (i != 0L) {
            throw new IndexOutOfBoundsException(Errors.badIndex(i));
        }
        return this.toBlob();
    }

    @Override
    public void validateCell() throws InvalidDataException {
        if (this.length != 32) {
            throw new InvalidDataException("Address length must be 32 bytes = 256 bits", this);
        }
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    public boolean isRegularBlob() {
        return true;
    }

    @Override
    public byte getTag() {
        return 49;
    }

    @Override
    public Blob toCanonical() {
        return this.toBlob();
    }
}

