/*
 * Decompiled with CFR 0.152.
 */
package convex.core.crypto;

import convex.core.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Symmetric {
    static final BouncyCastleProvider PROVIDER = new BouncyCastleProvider();
    private static final String SYMMETRIC_ENCRYPTION_ALGO = "AES/CBC/PKCS5Padding";
    private static final int IV_LENGTH = 16;
    private static final String SYMMETRIC_KEY_ALGORITHM = "AES";
    private static final int KEY_LENGTH = 128;

    public static byte[] encrypt(SecretKey key, String data) {
        return Symmetric.encrypt(key, data.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] encrypt(SecretKey key, byte[] data) {
        Cipher cipher = null;
        byte[] iv = null;
        try {
            cipher = Cipher.getInstance(SYMMETRIC_ENCRYPTION_ALGO);
            cipher.init(1, key);
            iv = cipher.getIV();
        }
        catch (Exception e) {
            throw new Error("Failed to initialise encryption cipher", e);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            bos.write(iv);
        }
        catch (IOException e) {
            throw new Error("Problem writing IV with value " + Utils.toHexString(iv), e);
        }
        CipherOutputStream cos = new CipherOutputStream(bos, cipher);
        try {
            cos.write(data);
            cos.flush();
            cos.close();
        }
        catch (IOException e) {
            throw new Error("Error encrypting data,e");
        }
        return bos.toByteArray();
    }

    public static String decryptString(SecretKey key, byte[] encryptedData) {
        return new String(Symmetric.decrypt(key, encryptedData), StandardCharsets.UTF_8);
    }

    public static byte[] decrypt(SecretKey key, byte[] encryptedData) {
        ByteArrayInputStream bis = new ByteArrayInputStream(encryptedData);
        try {
            return Symmetric.decrypt(key, bis);
        }
        catch (IOException e) {
            throw new Error("Unexpected IO exception", e);
        }
    }

    public static byte[] decrypt(SecretKey key, InputStream bis) throws IOException {
        byte[] iv = new byte[16];
        int x = bis.read(iv, 0, 16);
        if (x != 16) {
            throw new Error("IV not read correctly, " + x + " byes read");
        }
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(SYMMETRIC_ENCRYPTION_ALGO);
            IvParameterSpec ivParamSpec = new IvParameterSpec(iv);
            cipher.init(2, (Key)key, ivParamSpec);
        }
        catch (Exception e) {
            throw new Error("Failed to initialise decryption cipher", e);
        }
        CipherInputStream cis = new CipherInputStream(bis, cipher);
        try {
            return Utils.readBytes(cis);
        }
        catch (IOException e) {
            throw new Error("Failed to decrypt from input stream", e);
        }
    }

    public static SecretKey createSecretKey() {
        KeyGenerator kgen;
        try {
            kgen = KeyGenerator.getInstance(SYMMETRIC_KEY_ALGORITHM);
            kgen.init(128);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("Key generator not initialised sucessfully", e);
        }
        SecretKey key = kgen.generateKey();
        return key;
    }
}

