/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.peer;

import convex.cli.CLIError;
import convex.cli.mixins.RemotePeerMixin;
import convex.cli.peer.APeerCommand;
import convex.cli.peer.Peer;
import convex.core.crypto.AKeyPair;
import convex.core.data.AccountKey;
import convex.core.data.Address;
import convex.core.data.Keyword;
import convex.core.data.Keywords;
import convex.core.store.AStore;
import convex.etch.EtchStore;
import convex.peer.API;
import convex.peer.Server;
import convex.restapi.RESTServer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="start", mixinStandardHelpOptions=true, description={"Start a local peer."})
public class PeerStart
extends APeerCommand {
    private static final Logger log = LoggerFactory.getLogger(PeerStart.class);
    @CommandLine.ParentCommand
    private Peer peerParent;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--reset"}, description={"Reset and delete the etch database if it exists. Default: ${DEFAULT-VALUE}"})
    private boolean isReset;
    @CommandLine.Option(names={"--peer-port"}, defaultValue="18888", description={"Port number for the peer. Default is ${DEFAULT-VALUE}. If set to 0, will choose a random port."})
    private int port = 0;
    @CommandLine.Option(names={"--url"}, description={"URL for the peer to publish. If not provided, the peer will have no public URL."})
    private String url;
    @CommandLine.Option(names={"--norest"}, description={"Disable REST srever."})
    private boolean norest;
    @CommandLine.Option(names={"--api-port"}, description={"Port for REST API."})
    private Integer apiport;
    @CommandLine.Mixin
    protected RemotePeerMixin peerMixin;
    @CommandLine.Option(names={"-a", "--address"}, description={"Account address to use for the peer controller."})
    private String controllerAddress;

    private AKeyPair findPeerKey(EtchStore store) {
        AKeyPair kp = this.checkPeerKey();
        if (kp != null) {
            return kp;
        }
        String specifiedKey = this.peerKeyMixin.getPublicKey();
        if (specifiedKey != null) {
            throw new CLIError(78, "Peer key not found in Store: " + specifiedKey);
        }
        this.paranoia("--peer-key not sepcified");
        log.debug("--peer-key not available, attempting to infer from store");
        try {
            List peerList = API.listPeers((AStore)store);
            if (peerList.size() == 0) {
                throw new CLIError(78, "No peers configured in Etch store " + String.valueOf(store) + ". Consider using `convex peer create` or `convex peer genesis` first.");
            }
            if (peerList.size() > 1) {
                throw new CLIError(78, "Multiple peers configured in Etch store " + String.valueOf(store) + ". specify which one you want with --peer-key.");
            }
            AccountKey peerKey = (AccountKey)peerList.get(0);
            AKeyPair pkp = this.storeMixin.loadKeyFromStore(peerKey.toHexString(), this.peerKeyMixin.getKeyPassword());
            return pkp;
        }
        catch (IOException e) {
            log.debug("IO Exception trying to read etch peer list", (Throwable)e);
            return null;
        }
    }

    @Override
    public void execute() throws InterruptedException {
        this.storeMixin.ensureKeyStore();
        try (EtchStore store = this.etchMixin.getEtchStore();){
            AKeyPair peerKey = this.findPeerKey(store);
            if (peerKey == null) {
                this.informWarning("No --peer-key specified or inferred from Etch Store " + String.valueOf(store));
                this.showUsage();
                return;
            }
            this.inform("Preparing to start peer: " + String.valueOf(peerKey.getAccountKey()));
            Address controller = Address.parse((String)this.controllerAddress);
            if (controller == null) {
                this.paranoia("--address for peer controller not specified");
                log.debug("Controller address not specified.");
            }
            try (RESTServer restServer = null;){
                HashMap<Keyword, Object> config = new HashMap<Keyword, Object>();
                config.put(Keywords.KEYPAIR, peerKey);
                config.put(Keywords.STORE, store);
                Server server = API.launchPeer(config);
                if (!this.norest) {
                    restServer = RESTServer.create((Server)server);
                    restServer.start(this.apiport);
                }
                while (server.isRunning() && !Thread.currentThread().isInterrupted()) {
                    Thread.sleep(400L);
                }
                this.informSuccess("Peer shutdown completed");
            }
        }
    }
}

