/*
 * Decompiled with CFR 0.152.
 */
package convex.cli.account;

import convex.api.Convex;
import convex.cli.CLIError;
import convex.cli.account.AAccountCommand;
import convex.cli.account.Account;
import convex.core.data.Address;
import convex.core.exceptions.ResultException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="fund", aliases={"fu"}, mixinStandardHelpOptions=true, description={"Transfers funds to account using a public/private key from the keystore.%nYou must provide a valid keystore password to the keystore and a valid address.%nIf the keystore is not at the default location also the keystore filename."})
public class AccountFund
extends AAccountCommand {
    private static final Logger log = LoggerFactory.getLogger(AccountFund.class);
    @CommandLine.ParentCommand
    private Account accountParent;
    @CommandLine.Option(names={"-a", "--address"}, description={"Account address to use to request funds."})
    private long addressNumber;
    @CommandLine.Parameters(paramLabel="amount", defaultValue="100000000", description={"Amount to fund the account"})
    private long amount;

    @Override
    public void execute() throws InterruptedException {
        if (this.addressNumber == 0L) {
            log.warn("--address. You need to provide a valid address number");
            return;
        }
        Convex convex = null;
        Address address = Address.create((long)this.addressNumber);
        convex = this.connect();
        convex.transferSync(address, this.amount);
        try {
            Long balance = convex.getBalance(address);
            this.println(balance);
        }
        catch (ResultException e) {
            throw new CLIError("Error getting balance: " + String.valueOf(e.getResult().getValue()), e);
        }
    }
}

