/*
 * Decompiled with CFR 0.152.
 */
package mdlaf.components.tree;

import java.awt.Cursor;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import mdlaf.components.tree.MaterialTreeCellEditor;
import mdlaf.components.tree.MaterialTreeCellRenderer;
import mdlaf.utils.MaterialDrawingUtils;

public class MaterialTreeUI
extends BasicTreeUI {
    public static ComponentUI createUI(JComponent c) {
        return new MaterialTreeUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        MaterialTreeCellRenderer renderer = new MaterialTreeCellRenderer();
        MaterialTreeCellEditor editor = new MaterialTreeCellEditor(this.tree, renderer);
        this.tree.setCellRenderer(renderer);
        this.tree.setCellEditor(editor);
        this.tree.setRowHeight(0);
        this.tree.setInvokesStopCellEditing(true);
        this.setLeftChildIndent(10);
        this.setRightChildIndent(10);
        this.tree.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.tree.setCursor(Cursor.getDefaultCursor());
        super.uninstallUI(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        g = MaterialDrawingUtils.getAliasedGraphics(g);
        super.paint(g, c);
    }

    @Override
    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
    }

    @Override
    protected void paintHorizontalLine(Graphics g, JComponent c, int y, int left, int right) {
    }
}

