/*
 * Decompiled with CFR 0.152.
 */
package convex.core.lang.impl;

import convex.core.data.ACell;
import convex.core.data.AVector;
import convex.core.data.Format;
import convex.core.data.IRefFunction;
import convex.core.data.Ref;
import convex.core.exceptions.BadFormatException;
import convex.core.exceptions.InvalidDataException;
import convex.core.lang.AOp;
import convex.core.lang.Context;
import convex.core.lang.Symbols;
import convex.core.lang.impl.AClosure;
import convex.core.util.Utils;
import java.nio.ByteBuffer;

public class Fn<T extends ACell>
extends AClosure<T> {
    private final AVector<ACell> params;
    private final AOp<T> body;
    private Long variadic = null;

    private Fn(AVector<ACell> params, AOp<T> body, AVector<ACell> lexicalEnv) {
        super(lexicalEnv);
        this.params = params;
        this.body = body;
    }

    public static <T extends ACell, I> Fn<T> create(AVector<ACell> params, AOp<T> body) {
        AVector<ACell> binds = Context.EMPTY_BINDINGS;
        return new Fn<T>(params, body, binds);
    }

    @Override
    public <F extends AClosure<T>> F withEnvironment(AVector<ACell> env) {
        if (this.lexicalEnv == env) {
            return (F)this;
        }
        return (F)new Fn<T>(this.params, this.body, env);
    }

    @Override
    public boolean hasArity(int n) {
        long var = this.checkVariadic();
        long pc = this.params.count();
        if (var >= 0L) {
            return (long)n >= pc - 2L;
        }
        return (long)n == pc;
    }

    private Long checkVariadic() {
        if (this.variadic != null) {
            return this.variadic;
        }
        long pc = this.params.count();
        int i = 0;
        while ((long)i < pc - 1L) {
            Object param = this.params.get(i);
            if (Symbols.AMPERSAND.equals((ACell)param)) {
                this.variadic = i + 1;
                return this.variadic;
            }
            ++i;
        }
        this.variadic = -1L;
        return -1L;
    }

    @Override
    public Context<T> invoke(Context context, ACell[] args) {
        AVector<ACell> savedBindings = context.getLocalBindings();
        Context<T> boundContext = (context = context.withLocalBindings(this.lexicalEnv)).updateBindings(this.params, args);
        if (boundContext.isExceptional()) {
            return boundContext.withLocalBindings(savedBindings);
        }
        Context<T> ctx = boundContext.execute(this.body);
        return ctx.withLocalBindings(savedBindings);
    }

    @Override
    public boolean isCanonical() {
        return true;
    }

    @Override
    public int encode(byte[] bs, int pos) {
        bs[pos++] = -49;
        return this.encodeRaw(bs, pos);
    }

    @Override
    public int encodeRaw(byte[] bs, int pos) {
        pos = this.params.encode(bs, pos);
        pos = this.body.encode(bs, pos);
        pos = this.lexicalEnv.encode(bs, pos);
        return pos;
    }

    @Override
    public int estimatedEncodingSize() {
        return 1 + this.params.estimatedEncodingSize() + this.body.estimatedEncodingSize() + this.lexicalEnv.estimatedEncodingSize();
    }

    public static <T extends ACell> Fn<T> read(ByteBuffer bb) throws BadFormatException {
        try {
            AVector params = (AVector)Format.read(bb);
            if (params == null) {
                throw new BadFormatException("Null parameters to Fn");
            }
            AOp body = (AOp)Format.read(bb);
            if (body == null) {
                throw new BadFormatException("Null body in Fn");
            }
            AVector lexicalEnv = (AVector)Format.read(bb);
            return new Fn<T>(params, body, lexicalEnv);
        }
        catch (ClassCastException e) {
            throw new BadFormatException("Bad Fn format", e);
        }
    }

    @Override
    public void print(StringBuilder sb) {
        sb.append("(fn ");
        this.printInternal(sb);
        sb.append(')');
    }

    @Override
    public void printInternal(StringBuilder sb) {
        sb.append('[');
        long size = this.params.count();
        for (long i = 0L; i < size; ++i) {
            if (i > 0L) {
                sb.append(' ');
            }
            Utils.print(sb, this.params.get(i));
        }
        sb.append(']');
        sb.append(' ');
        this.body.print(sb);
    }

    public AVector<ACell> getParams() {
        return this.params;
    }

    public AOp<T> getBody() {
        return this.body;
    }

    @Override
    public int getRefCount() {
        return this.params.getRefCount() + this.body.getRefCount() + this.lexicalEnv.getRefCount();
    }

    @Override
    public <R extends ACell> Ref<R> getRef(int i) {
        int pc = this.params.getRefCount();
        if (i < pc) {
            return this.params.getRef(i);
        }
        int bc = this.body.getRefCount();
        if ((i -= pc) < bc) {
            return this.body.getRef(i);
        }
        return this.lexicalEnv.getRef(i -= bc);
    }

    @Override
    public Fn<T> updateRefs(IRefFunction func) {
        ACell newParams = this.params.updateRefs(func);
        ACell newBody = this.body.updateRefs(func);
        ACell newLexicalEnv = this.lexicalEnv.updateRefs(func);
        if (this.params == newParams && this.body == newBody && this.lexicalEnv == newLexicalEnv) {
            return this;
        }
        return new Fn<T>((AVector<ACell>)newParams, newBody, this.lexicalEnv);
    }

    @Override
    public void validateCell() throws InvalidDataException {
        this.params.validateCell();
        this.body.validateCell();
        this.lexicalEnv.validateCell();
    }

    @Override
    public ACell toCanonical() {
        return this;
    }
}

