/*
 * Decompiled with CFR 0.152.
 */
package eu.thesimplecloud.clientserverapi.lib.connection;

import eu.thesimplecloud.clientserverapi.lib.connection.AbstractConnection;
import eu.thesimplecloud.clientserverapi.lib.packet.WrappedPacket;
import eu.thesimplecloud.clientserverapi.lib.promise.CommunicationPromise;
import eu.thesimplecloud.clientserverapi.lib.promise.ICommunicationPromise;
import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0004H\u0016\u00a8\u0006\u0011"}, d2={"Leu/thesimplecloud/clientserverapi/lib/connection/AbstractNettyConnection;", "Leu/thesimplecloud/clientserverapi/lib/connection/AbstractConnection;", "()V", "closeConnection", "Leu/thesimplecloud/clientserverapi/lib/promise/ICommunicationPromise;", "", "getChannel", "Lio/netty/channel/Channel;", "getHost", "", "isOpen", "", "sendPacket", "wrappedPacket", "Leu/thesimplecloud/clientserverapi/lib/packet/WrappedPacket;", "promise", "", "clientserverapi"})
public abstract class AbstractNettyConnection
extends AbstractConnection {
    @Override
    public synchronized void sendPacket(@NotNull WrappedPacket wrappedPacket, @NotNull ICommunicationPromise<? extends Object> promise) {
        Intrinsics.checkNotNullParameter((Object)wrappedPacket, (String)"wrappedPacket");
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        if (!this.isOpen()) {
            IOException exception = new IOException("Connection is closed. Packet to send was " + wrappedPacket.getPacketData().getSentPacketName() + ".");
            promise.tryFailure(exception);
            return;
        }
        Channel channel = this.getChannel();
        Intrinsics.checkNotNull((Object)channel);
        Channel channel2 = channel;
        channel2.eventLoop().execute(() -> AbstractNettyConnection.sendPacket$lambda$1(channel2, wrappedPacket, promise));
    }

    @Nullable
    public abstract Channel getChannel();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isOpen() {
        if (this.getChannel() == null) return false;
        Channel channel = this.getChannel();
        if (channel == null) return false;
        boolean bl = channel.isActive();
        if (!bl) return false;
        return true;
    }

    @Override
    @NotNull
    public ICommunicationPromise<Unit> closeConnection() {
        CommunicationPromise connectionPromise;
        block4: {
            block3: {
                block2: {
                    if (this.getChannel() == null) break block2;
                    Channel channel = this.getChannel();
                    Intrinsics.checkNotNull((Object)channel);
                    if (channel.isOpen()) break block3;
                }
                throw new IllegalStateException("Connection already closed.");
            }
            connectionPromise = new CommunicationPromise(2000L, false, 2, null);
            Channel channel = this.getChannel();
            if (channel == null || (channel = channel.close()) == null) break block4;
            channel.addListener(arg_0 -> AbstractNettyConnection.closeConnection$lambda$2(connectionPromise, arg_0));
        }
        return connectionPromise;
    }

    @Override
    @Nullable
    public String getHost() {
        if (!this.isOpen()) {
            return null;
        }
        Channel channel = this.getChannel();
        Intrinsics.checkNotNull((Object)channel);
        SocketAddress socketAddress = channel.remoteAddress();
        Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
        return ((InetSocketAddress)socketAddress).getHostString();
    }

    private static final void sendPacket$lambda$1$lambda$0(ICommunicationPromise $promise, Future it) {
        Intrinsics.checkNotNullParameter((Object)$promise, (String)"$promise");
        if (!it.isSuccess()) {
            $promise.tryFailure(it.cause());
        }
    }

    private static final void sendPacket$lambda$1(Channel $channel, WrappedPacket $wrappedPacket, ICommunicationPromise $promise) {
        Intrinsics.checkNotNullParameter((Object)$channel, (String)"$channel");
        Intrinsics.checkNotNullParameter((Object)$wrappedPacket, (String)"$wrappedPacket");
        Intrinsics.checkNotNullParameter((Object)$promise, (String)"$promise");
        $channel.writeAndFlush((Object)$wrappedPacket).addListener(arg_0 -> AbstractNettyConnection.sendPacket$lambda$1$lambda$0($promise, arg_0));
    }

    private static final void closeConnection$lambda$2(CommunicationPromise $connectionPromise, Future it) {
        Intrinsics.checkNotNullParameter((Object)$connectionPromise, (String)"$connectionPromise");
        $connectionPromise.trySuccess(Unit.INSTANCE);
    }
}

