/*
 * Decompiled with CFR 0.152.
 */
package works.lmz.logging.server;

import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import works.lmz.logging.server.ClientErrorData;
import works.lmz.logging.server.ClientErrorsLogger;

public class SmartClientErrorsLogger
implements ClientErrorsLogger {
    private static final Logger LOG = LoggerFactory.getLogger(ClientErrorsLogger.class);
    static int DEFAULT_LOG_CACHE_SIZE = 30;
    static int DEFAULT_EXPIRATION_TIME_SECONDS = 15;
    Cache<ClientErrorData, ValueWrapper> cache;

    public SmartClientErrorsLogger() {
        this(DEFAULT_EXPIRATION_TIME_SECONDS, DEFAULT_LOG_CACHE_SIZE, null);
    }

    public SmartClientErrorsLogger(int expiration, int logCacheSize, Ticker ticker) {
        if (ticker == null) {
            ticker = Ticker.systemTicker();
        }
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(1).ticker(ticker).expireAfterWrite((long)expiration, TimeUnit.SECONDS).maximumSize((long)logCacheSize).removalListener((RemovalListener)new RemovalListener<ClientErrorData, ValueWrapper>(){

            public void onRemoval(RemovalNotification<ClientErrorData, ValueWrapper> removalNotification) {
                int count = ((ValueWrapper)removalNotification.getValue()).count != null ? ((ValueWrapper)removalNotification.getValue()).count : 1;
                SmartClientErrorsLogger.this.writeClientError((ClientErrorData)removalNotification.getKey(), count);
            }
        }).build();
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
        service.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                SmartClientErrorsLogger.this.cache.cleanUp();
            }
        }, 0L, expiration / 2, TimeUnit.SECONDS);
    }

    @Override
    public void logClientError(ClientErrorData errorData) {
        try {
            ValueWrapper current;
            ValueWrapper valueWrapper = current = (ValueWrapper)this.cache.get((Object)errorData, (Callable)new Callable<ValueWrapper>(){

                @Override
                public ValueWrapper call() throws Exception {
                    return new ValueWrapper();
                }
            });
            Integer n = valueWrapper.count;
            Integer n2 = valueWrapper.count = Integer.valueOf(valueWrapper.count + 1);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            this.writeClientError(errorData, 1);
        }
    }

    public void writeClientError(ClientErrorData errorData, int count) {
        LOG.debug("Javascript error [{}]: {} \nat: {}:{}:{} \nstacktrace: {}", new Object[]{count, errorData.message, errorData.file, errorData.line, errorData.column, errorData.errorObj});
    }

    public static class ValueWrapper {
        Integer count = 0;
    }
}

