/*
 * Decompiled with CFR 0.152.
 */
package work.lingling.dagtask;

import android.util.Log;

public class LogUtil {
    private static String mClassName;
    private static String mMethod;
    private static int mLineNum;
    private static boolean mIsOpen;

    private LogUtil() {
    }

    public static void openLog(boolean mIsOpen) {
        LogUtil.mIsOpen = mIsOpen;
    }

    private static boolean isDebuggable() {
        return mIsOpen;
    }

    private static String getLogData(String tag, String msg) {
        return mMethod + "(" + mClassName + ":" + mLineNum + ") " + tag + ": " + msg;
    }

    private static void getClassData(StackTraceElement[] stackTraceElements) {
        mClassName = stackTraceElements[1].getFileName();
        mMethod = stackTraceElements[1].getMethodName();
        mLineNum = stackTraceElements[1].getLineNumber();
    }

    public static void v(String tag, String msg) {
        if (LogUtil.isDebuggable()) {
            LogUtil.getClassData(new Throwable().getStackTrace());
            Log.v((String)mClassName, (String)LogUtil.getLogData(tag, msg));
        }
    }

    public static void d(String tag, String msg) {
        if (LogUtil.isDebuggable()) {
            LogUtil.getClassData(new Throwable().getStackTrace());
            Log.d((String)mClassName, (String)LogUtil.getLogData(tag, msg));
        }
    }

    public static void i(String tag, String msg) {
        if (LogUtil.isDebuggable()) {
            LogUtil.getClassData(new Throwable().getStackTrace());
            Log.i((String)mClassName, (String)LogUtil.getLogData(tag, msg));
        }
    }

    public static void w(String tag, String msg) {
        if (LogUtil.isDebuggable()) {
            LogUtil.getClassData(new Throwable().getStackTrace());
            Log.w((String)mClassName, (String)LogUtil.getLogData(tag, msg));
        }
    }

    public static void e(String tag, String msg) {
        if (LogUtil.isDebuggable()) {
            LogUtil.getClassData(new Throwable().getStackTrace());
            Log.e((String)mClassName, (String)LogUtil.getLogData(tag, msg));
        }
    }

    public static void wtf(String tag, String msg) {
        if (LogUtil.isDebuggable()) {
            LogUtil.getClassData(new Throwable().getStackTrace());
            Log.wtf((String)mClassName, (String)LogUtil.getLogData(tag, msg));
        }
    }

    static {
        mIsOpen = true;
    }
}

