/*
 * Decompiled with CFR 0.152.
 */
package work.lingling.dagtask;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import work.lingling.dagtask.DAGCallBack;
import work.lingling.dagtask.IDAGCallBack;

public class IDAGTask
implements Runnable {
    private final boolean mIsSyn;
    private final AtomicInteger mAtomicInteger;
    private IDAGCallBack mDAGCallBack;
    private final Set<IDAGTask> mNextTaskSet;

    public IDAGTask() {
        this("");
    }

    public IDAGTask(boolean isSyn) {
        this("", isSyn);
    }

    public IDAGTask(String alias) {
        this(alias, false);
    }

    public IDAGTask(String alias, boolean IsSyn) {
        this.mIsSyn = IsSyn;
        this.mAtomicInteger = new AtomicInteger();
        this.mDAGCallBack = new DAGCallBack(alias);
        this.mNextTaskSet = new HashSet<IDAGTask>();
    }

    boolean getIsAsync() {
        return this.mIsSyn;
    }

    void addRely() {
        this.mAtomicInteger.incrementAndGet();
    }

    void deleteRely() {
        this.mAtomicInteger.decrementAndGet();
    }

    int getRely() {
        return this.mAtomicInteger.get();
    }

    void addNextDAGTask(IDAGTask DAGTask) {
        this.mNextTaskSet.add(DAGTask);
    }

    public void setDAGCallBack(IDAGCallBack DAGCallBack2) {
        this.mDAGCallBack = DAGCallBack2;
    }

    public void completeDAGTask() {
        for (IDAGTask DAGTask : this.mNextTaskSet) {
            DAGTask.deleteRely();
        }
        this.mDAGCallBack.onCompleteDAGTask();
    }

    @Override
    public void run() {
        this.mDAGCallBack.onStartDAGTask();
    }
}

