/*
 * Decompiled with CFR 0.152.
 */
package work.lingling.dagtask;

import android.os.Handler;
import android.os.Looper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import work.lingling.dagtask.DAGProject;
import work.lingling.dagtask.IDAGTask;

public class DAGScheduler {
    private Set<IDAGTask> mTaskSet;
    private Map<IDAGTask, Set<IDAGTask>> mTaskMap;
    private ArrayBlockingQueue<Runnable> mTaskBlockingDeque;
    private ThreadPoolExecutor mTaskThreadPool;

    public void start(DAGProject DAGProject2) {
        this.mTaskSet = DAGProject2.getDAGTaskSet();
        this.mTaskMap = DAGProject2.getDAGTaskMap();
        this.checkCircle();
        this.init();
        this.loop();
    }

    private void loop() {
        for (IDAGTask DAGTask : this.mTaskSet) {
            if (DAGTask.getRely() != 0) continue;
            this.mTaskBlockingDeque.add(DAGTask);
        }
        ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();
        singleThreadExecutor.execute(() -> this.lambda$loop$0(singleThreadExecutor));
    }

    private void init() {
        int codeTaskSize = Runtime.getRuntime().availableProcessors();
        int maxTaskSize = Math.max(Runtime.getRuntime().availableProcessors() * 2 + 1, this.mTaskSet.size());
        int keepAliveTime = 1000;
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        ArrayBlockingQueue<Runnable> taskBlockingDeque = new ArrayBlockingQueue<Runnable>(maxTaskSize - codeTaskSize);
        this.mTaskThreadPool = new ThreadPoolExecutor(codeTaskSize, maxTaskSize, keepAliveTime, timeUnit, taskBlockingDeque);
        this.mTaskBlockingDeque = new ArrayBlockingQueue(this.mTaskSet.size());
    }

    private void checkCircle() {
        HashSet<IDAGTask> tempTaskSet = new HashSet<IDAGTask>(this.mTaskSet);
        HashMap<IDAGTask, Object> tempTaskMap = new HashMap<IDAGTask, Object>();
        for (IDAGTask IDATask : this.mTaskMap.keySet()) {
            if (this.mTaskMap.get(IDATask) == null) continue;
            HashSet set = new HashSet(this.mTaskMap.get(IDATask));
            tempTaskMap.put(IDATask, set);
        }
        LinkedList<IDAGTask> resultTaskQueue = new LinkedList<IDAGTask>();
        LinkedList<IDAGTask> tempTaskQueue = new LinkedList<IDAGTask>();
        for (IDAGTask DAGTask : tempTaskSet) {
            if (tempTaskMap.get(DAGTask) != null) continue;
            tempTaskQueue.add(DAGTask);
        }
        while (!tempTaskQueue.isEmpty()) {
            IDAGTask tempDAGTask = (IDAGTask)tempTaskQueue.pop();
            resultTaskQueue.add(tempDAGTask);
            for (IDAGTask DAGTask : tempTaskMap.keySet()) {
                Set tempDAGSet = (Set)tempTaskMap.get(DAGTask);
                if (tempDAGSet == null || !tempDAGSet.contains(tempDAGTask)) continue;
                tempDAGSet.remove(tempDAGTask);
                if (tempDAGSet.size() != 0) continue;
                tempTaskQueue.add(DAGTask);
            }
        }
        if (resultTaskQueue.size() != tempTaskSet.size()) {
            throw new IllegalArgumentException("\u76f8\u4e92\u4f9d\u8d56\uff0c\u73a9\u5c41\u554a\uff0c\u6211\u4e0d\u8dd1\u4e86\uff01");
        }
    }

    /*
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$loop$0(ExecutorService singleThreadExecutor) {
        while (true) {
            try {
                block3: while (true) {
                    if (!this.mTaskBlockingDeque.isEmpty()) {
                        executedDAGTsk = (IDAGTask)this.mTaskBlockingDeque.take();
                        if (executedDAGTsk.getIsAsync()) {
                            handler = new Handler(Looper.getMainLooper());
                            handler.post((Runnable)executedDAGTsk);
                        } else {
                            this.mTaskThreadPool.execute(executedDAGTsk);
                        }
                        this.mTaskSet.remove(executedDAGTsk);
                        continue;
                    }
                    if (this.mTaskSet.isEmpty()) {
                        singleThreadExecutor.shutdown();
                        this.mTaskThreadPool.shutdown();
                        return;
                    }
                    iterator = this.mTaskSet.iterator();
                    while (true) {
                        if (iterator.hasNext()) ** break;
                        continue block3;
                        DAGTask = iterator.next();
                        if (DAGTask.getRely() != 0) continue;
                        this.mTaskBlockingDeque.put(DAGTask);
                        iterator.remove();
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

