/*
 * Decompiled with CFR 0.152.
 */
package com.github.robust.client.utils;

import android.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public abstract class FileUtil {
    public static boolean createDir(String path) {
        File parentFile;
        File file = new File(path);
        if (!file.exists() && (parentFile = file.getParentFile()) != null && !parentFile.exists()) {
            return parentFile.mkdir();
        }
        return true;
    }

    public static void deleteFile(String path) {
        File temp = new File(path);
        if (temp.exists()) {
            boolean del = temp.delete();
            if (del) {
                Log.i((String)"FileUtil", (String)("\u5220\u9664\u6587\u4ef6\u6210\u529f,\u6e90\u6587\u4ef6\u8def\u5f84\uff1a" + path));
            } else {
                Log.e((String)"FileUtil", (String)("\u5220\u9664\u6587\u4ef6\u5931\u8d25,\u6e90\u6587\u4ef6\u8def\u5f84\uff1a" + path));
            }
        }
    }

    public static void closeStream(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

