/*
 * Decompiled with CFR 0.152.
 */
package wf.bitcoin.javabitcoindrpcclient;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import wf.bitcoin.javabitcoindrpcclient.BitcoinRPCException;
import wf.bitcoin.javabitcoindrpcclient.GenericRpcException;
import wf.bitcoin.javabitcoindrpcclient.MapWrapperType;
import wf.bitcoin.javabitcoindrpcclient.SignatureHashType;

public interface BitcoindRpcClient {
    public String getBestBlockHash() throws GenericRpcException;

    public Block getBlock(int var1) throws GenericRpcException;

    public Block getBlock(String var1) throws GenericRpcException;

    public String getRawBlock(String var1) throws GenericRpcException;

    public BlockChainInfo getBlockChainInfo() throws GenericRpcException;

    public AddressInfo getAddressInfo(String var1) throws GenericRpcException;

    public int getBlockCount() throws GenericRpcException;

    public String getBlockHash(int var1) throws GenericRpcException;

    public BigDecimal getDifficulty();

    public List<String> getRawMemPool() throws GenericRpcException;

    public TxOut getTxOut(String var1, long var2);

    public TxOutSetInfo getTxOutSetInfo();

    public boolean verifyChain();

    public void stop();

    @Deprecated
    public List<String> generate(int var1) throws BitcoinRPCException;

    @Deprecated
    public List<String> generate(int var1, long var2) throws BitcoinRPCException;

    public List<String> generateToAddress(int var1, String var2) throws BitcoinRPCException;

    public List<String> generateToAddress(int var1, String var2, long var3) throws BitcoinRPCException;

    public MiningInfo getMiningInfo() throws GenericRpcException;

    public BigDecimal getNetworkHashPs();

    public void submitBlock(String var1);

    public void invalidateBlock(String var1) throws GenericRpcException;

    public void reconsiderBlock(String var1) throws GenericRpcException;

    public void addNode(String var1, String var2);

    public List<NodeInfo> getAddedNodeInfo(boolean var1, String var2);

    public long getConnectionCount();

    public NetTotals getNetTotals();

    public NetworkInfo getNetworkInfo() throws GenericRpcException;

    public List<PeerInfoResult> getPeerInfo();

    public void ping();

    public String createRawTransaction(List<TxInput> var1, List<TxOutput> var2) throws GenericRpcException;

    public DecodedScript decodeScript(String var1);

    public RawTransaction getRawTransaction(String var1) throws GenericRpcException;

    public List<RawTransaction> getRawTransactions(List<String> var1) throws GenericRpcException;

    public String getRawTransactionHex(String var1) throws GenericRpcException;

    public String sendRawTransaction(String var1) throws GenericRpcException;

    @Deprecated
    public String signRawTransaction(String var1, List<? extends TxInput> var2, List<String> var3) throws GenericRpcException;

    public SignedRawTransaction signRawTransactionWithKey(String var1, List<String> var2, List<? extends TxInput> var3, SignatureHashType var4);

    public MultiSig createMultiSig(int var1, List<String> var2) throws GenericRpcException;

    public SmartFeeResult estimateSmartFee(int var1);

    public AddressValidationResult validateAddress(String var1) throws GenericRpcException;

    public boolean verifyMessage(String var1, String var2, String var3);

    public MultiSig addMultiSigAddress(int var1, List<String> var2);

    @Deprecated
    public MultiSig addMultiSigAddress(int var1, List<String> var2, String var3);

    public void backupWallet(String var1);

    public String dumpPrivKey(String var1) throws GenericRpcException;

    public void dumpWallet(String var1);

    public void encryptWallet(String var1);

    @Deprecated
    public String getAccount(String var1) throws GenericRpcException;

    @Deprecated
    public String getAccountAddress(String var1) throws GenericRpcException;

    @Deprecated
    public List<String> getAddressesByAccount(String var1) throws GenericRpcException;

    public BigDecimal getBalance() throws GenericRpcException;

    public BigDecimal getBalance(String var1) throws GenericRpcException;

    public BigDecimal getBalance(String var1, int var2) throws GenericRpcException;

    public String getNewAddress() throws GenericRpcException;

    public String getNewAddress(String var1) throws GenericRpcException;

    public String getNewAddress(String var1, String var2) throws GenericRpcException;

    public String getRawChangeAddress();

    @Deprecated
    public BigDecimal getReceivedByAccount(String var1);

    public BigDecimal getReceivedByAddress(String var1) throws GenericRpcException;

    public BigDecimal getReceivedByAddress(String var1, int var2) throws GenericRpcException;

    public Transaction getTransaction(String var1);

    public BigDecimal getUnconfirmedBalance();

    public WalletInfo getWalletInfo();

    public Object importAddress(String var1, String var2, boolean var3) throws GenericRpcException;

    public void importPrivKey(String var1) throws GenericRpcException;

    public void importPrivKey(String var1, String var2) throws GenericRpcException;

    public void importPrivKey(String var1, String var2, boolean var3) throws GenericRpcException;

    public void importWallet(String var1);

    public void keyPoolRefill();

    @Deprecated
    public Map<String, Number> listAccounts() throws GenericRpcException;

    @Deprecated
    public Map<String, Number> listAccounts(int var1) throws GenericRpcException;

    @Deprecated
    public Map<String, Number> listAccounts(int var1, boolean var2) throws GenericRpcException;

    public List<LockedUnspent> listLockUnspent();

    public List<ReceivedAddress> listReceivedByAddress() throws GenericRpcException;

    public List<ReceivedAddress> listReceivedByAddress(int var1) throws GenericRpcException;

    public List<ReceivedAddress> listReceivedByAddress(int var1, boolean var2) throws GenericRpcException;

    public TransactionsSinceBlock listSinceBlock() throws GenericRpcException;

    public TransactionsSinceBlock listSinceBlock(String var1) throws GenericRpcException;

    public TransactionsSinceBlock listSinceBlock(String var1, int var2) throws GenericRpcException;

    public TransactionsSinceBlock listSinceBlock(String var1, int var2, boolean var3) throws GenericRpcException;

    public List<Transaction> listTransactions() throws GenericRpcException;

    public List<Transaction> listTransactions(String var1) throws GenericRpcException;

    public List<Transaction> listTransactions(String var1, int var2) throws GenericRpcException;

    public List<Transaction> listTransactions(String var1, int var2, int var3) throws GenericRpcException;

    public List<Unspent> listUnspent() throws GenericRpcException;

    public List<Unspent> listUnspent(int var1) throws GenericRpcException;

    public List<Unspent> listUnspent(int var1, int var2) throws GenericRpcException;

    public List<Unspent> listUnspent(int var1, int var2, String ... var3) throws GenericRpcException;

    public boolean lockUnspent(boolean var1, String var2, int var3) throws GenericRpcException;

    @Deprecated
    public boolean move(String var1, String var2, BigDecimal var3) throws GenericRpcException;

    @Deprecated
    public boolean move(String var1, String var2, BigDecimal var3, String var4) throws GenericRpcException;

    public boolean move(String var1, String var2, BigDecimal var3, int var4) throws GenericRpcException;

    public boolean move(String var1, String var2, BigDecimal var3, int var4, String var5) throws GenericRpcException;

    @Deprecated
    public String sendFrom(String var1, String var2, BigDecimal var3) throws GenericRpcException;

    @Deprecated
    public String sendFrom(String var1, String var2, BigDecimal var3, int var4) throws GenericRpcException;

    @Deprecated
    public String sendFrom(String var1, String var2, BigDecimal var3, int var4, String var5) throws GenericRpcException;

    @Deprecated
    public String sendFrom(String var1, String var2, BigDecimal var3, int var4, String var5, String var6) throws GenericRpcException;

    public String sendToAddress(String var1, BigDecimal var2) throws GenericRpcException;

    public String sendToAddress(String var1, BigDecimal var2, String var3) throws GenericRpcException;

    public String sendToAddress(String var1, BigDecimal var2, String var3, String var4) throws GenericRpcException;

    public boolean setTxFee(BigDecimal var1);

    public String signMessage(String var1, String var2);

    public void walletPassPhrase(String var1, long var2);

    public UtxoSet scanTxOutSet(List<ScanObject> var1);

    public Integer scanTxOutSetStatus() throws GenericRpcException;

    public Boolean abortScanTxOutSet() throws GenericRpcException;

    public UtxoSet scanTxOutSetAddresses(List<String> var1) throws GenericRpcException;

    public UtxoSet scanTxOutSetPubKey(String var1, int var2) throws GenericRpcException;

    @Deprecated
    public BigDecimal estimateFee(int var1) throws GenericRpcException;

    public static class ScanObject
    implements Serializable {
        private String descriptor;
        private Integer range;

        public ScanObject(String descriptor, Integer range) {
            this.descriptor = descriptor;
            this.range = range;
        }

        public String getDescriptor() {
            return this.descriptor;
        }

        public void setDescriptor(String descriptor) {
            this.descriptor = descriptor;
        }

        public Integer getRange() {
            return this.range;
        }

        public void setRange(Integer range) {
            this.range = range;
        }
    }

    public static interface UtxoSet {
        public Integer searchedItems();

        public BigDecimal totalAmount();

        public List<UnspentTxOutput> unspents();
    }

    public static interface UnspentTxOutput
    extends TxInput {
        @Override
        public String txid();

        @Override
        public Integer vout();

        @Override
        public String scriptPubKey();

        public String desc();

        @Override
        public BigDecimal amount();

        public int height();
    }

    public static interface RawTransactionSigningOrVerificationError {
        public String txId();

        public int vOut();

        public String scriptSig();

        public int n();

        public String error();
    }

    public static interface SignedRawTransaction {
        public String hex();

        public boolean complete();

        public List<RawTransactionSigningOrVerificationError> errors();
    }

    public static interface WalletInfo
    extends MapWrapperType,
    Serializable {
        public long walletVersion();

        public BigDecimal balance();

        public BigDecimal unconfirmedBalance();

        public BigDecimal immatureBalance();

        public long txCount();

        public long keyPoolOldest();

        public long keyPoolSize();

        public long unlockedUntil();

        public BigDecimal payTxFee();

        public String hdMasterKeyId();
    }

    public static interface Unspent
    extends TxInput,
    TxOutput,
    Serializable {
        @Deprecated
        public String account();

        public Integer confirmations();

        public String redeemScript();

        public String witnessScript();
    }

    public static interface TxOutput
    extends Serializable {
        public String address();

        public String label();

        public BigDecimal amount();

        public Boolean spendable();

        public Boolean solvable();

        public String desc();

        public Boolean safe();

        public byte[] data();
    }

    public static interface TxOutSetInfo
    extends MapWrapperType,
    Serializable {
        public long height();

        public String bestBlock();

        public long transactions();

        public long txouts();

        public long bytesSerialized();

        public String hashSerialized();

        public BigDecimal totalAmount();
    }

    public static interface TxOut
    extends MapWrapperType,
    Serializable {
        public String bestBlock();

        public long confirmations();

        public BigDecimal value();

        public String asm();

        public String hex();

        public long reqSigs();

        public String type();

        public List<String> addresses();

        public long version();

        public boolean coinBase();
    }

    public static interface TxInput
    extends Serializable {
        public String txid();

        public Integer vout();

        public String scriptPubKey();

        public BigDecimal amount();
    }

    public static interface TransactionsSinceBlock
    extends Serializable {
        public List<Transaction> transactions();

        public String lastBlock();
    }

    public static interface Transaction
    extends MapWrapperType,
    Serializable {
        public String account();

        public String address();

        public String category();

        public BigDecimal amount();

        public BigDecimal fee();

        public int confirmations();

        public String blockHash();

        public int blockIndex();

        public Date blockTime();

        public String txId();

        public Date time();

        public Date timeReceived();

        public String comment();

        public String commentTo();

        public boolean generated();

        public RawTransaction raw();
    }

    public static interface SmartFeeResult
    extends MapWrapperType,
    Serializable {
        public int blocks();

        public BigDecimal feeRate();

        public String errors();
    }

    public static interface ReceivedAddress
    extends MapWrapperType,
    Serializable {
        public String address();

        public String account();

        public BigDecimal amount();

        public int confirmations();
    }

    public static interface RawTransaction
    extends MapWrapperType,
    Serializable {
        public String error();

        public String hex();

        public String txId();

        public int version();

        public long lockTime();

        public long size();

        public long vsize();

        public String hash();

        public List<In> vIn();

        public List<Out> vOut();

        public String blockHash();

        public Integer confirmations();

        public Date time();

        public Date blocktime();

        public static interface Out
        extends MapWrapperType,
        Serializable {
            public BigDecimal value();

            public int n();

            public ScriptPubKey scriptPubKey();

            public TxInput toInput();

            public RawTransaction transaction();

            public static interface ScriptPubKey
            extends MapWrapperType,
            Serializable {
                public String asm();

                public String hex();

                public int reqSigs();

                public String type();

                public List<String> addresses();
            }
        }

        public static interface In
        extends TxInput,
        Serializable {
            public Map<String, Object> scriptSig();

            public long sequence();

            public RawTransaction getTransaction();

            public Out getTransactionOutput();
        }
    }

    public static interface PeerInfoResult
    extends MapWrapperType,
    Serializable {
        public long getId();

        public String getAddr();

        public String getAddrLocal();

        public String getServices();

        public long getLastSend();

        public long getLastRecv();

        public long getBytesSent();

        public long getBytesRecv();

        public long getConnTime();

        public int getTimeOffset();

        public BigDecimal getPingTime();

        public long getVersion();

        public String getSubVer();

        public boolean isInbound();

        public int getStartingHeight();

        public long getBanScore();

        public int getSyncedHeaders();

        public int getSyncedBlocks();

        public boolean isWhiteListed();
    }

    public static interface NodeInfo
    extends MapWrapperType,
    Serializable {
        public String addedNode();

        public boolean connected();

        public List<Address> addresses();
    }

    public static interface Network
    extends MapWrapperType,
    Serializable {
        public String name();

        public boolean limited();

        public boolean reachable();

        public String proxy();

        public boolean proxyRandomizeCredentials();
    }

    public static interface NetworkInfo
    extends MapWrapperType,
    Serializable {
        public long version();

        public String subversion();

        public long protocolVersion();

        public String localServices();

        public boolean localRelay();

        public long timeOffset();

        public long connections();

        public List<Network> networks();

        public BigDecimal relayFee();

        public List<String> localAddresses();

        public String warnings();
    }

    public static interface NetTotals
    extends MapWrapperType,
    Serializable {
        public long totalBytesRecv();

        public long totalBytesSent();

        public long timeMillis();

        public uploadTarget uploadTarget();

        public static interface uploadTarget
        extends MapWrapperType,
        Serializable {
            public long timeFrame();

            public int target();

            public boolean targetReached();

            public boolean serveHistoricalBlocks();

            public long bytesLeftInCycle();

            public long timeLeftInCycle();
        }
    }

    public static interface MultiSig
    extends MapWrapperType,
    Serializable {
        public String address();

        public String redeemScript();
    }

    public static interface MiningInfo
    extends MapWrapperType,
    Serializable {
        public int blocks();

        public int currentBlockSize();

        public int currentBlockWeight();

        public int currentBlockTx();

        public BigDecimal difficulty();

        public String errors();

        public BigDecimal networkHashps();

        public int pooledTx();

        public boolean testNet();

        public String chain();
    }

    public static interface LockedUnspent
    extends MapWrapperType,
    Serializable {
        public String txId();

        public int vout();
    }

    public static class ExtendedTxInput
    extends BasicTxInput {
        private String redeemScript;
        private String witnessScript;

        public ExtendedTxInput(String txid, int vout, String scriptPubKey, BigDecimal amount, String redeemScript, String witnessScript) {
            super(txid, vout, scriptPubKey, amount);
            this.redeemScript = redeemScript;
            this.witnessScript = witnessScript;
        }

        public String redeemScript() {
            return this.redeemScript;
        }

        public String witnessScript() {
            return this.witnessScript;
        }
    }

    public static interface DecodedScript
    extends MapWrapperType,
    Serializable {
        public String asm();

        public String hex();

        public String type();

        public int reqSigs();

        public List<String> addresses();

        public String p2sh();
    }

    public static interface AddressInfoLabel
    extends MapWrapperType,
    Serializable {
        public String name();

        public String purpose();
    }

    public static interface AddressInfo
    extends MapWrapperType,
    Serializable {
        public String address();

        public String scriptPubKey();

        public Boolean isMine();

        public Boolean isWatchOnly();

        public Boolean solvable();

        public String desc();

        public Boolean isScript();

        public Boolean isChange();

        public Boolean isWitness();

        public Integer witnessVersion();

        public String witnessProgram();

        public String script();

        public String hex();

        public List<String> pubKeys();

        public Integer sigsRequired();

        public String pubKey();

        public AddressInfo embedded();

        public Boolean isCompressed();

        public String label();

        public Long timestamp();

        public String hdKeyPath();

        public String hdSeedId();

        public String hdMasterFingerprint();

        public List<AddressInfoLabel> labels();
    }

    public static interface BlockChainInfo
    extends MapWrapperType,
    Serializable {
        public String chain();

        public Integer blocks();

        public Integer headers();

        public String bestBlockHash();

        public BigDecimal difficulty();

        public Long medianTime();

        public BigDecimal verificationProgress();

        public Boolean initialBlockDownload();

        public String chainWork();

        public Long sizeOnDisk();

        public Boolean pruned();

        public Integer pruneHeight();

        public Boolean automaticPruning();

        public Long pruneTargetSize();

        public String warnings();
    }

    public static interface Block
    extends MapWrapperType,
    Serializable {
        public String hash();

        public int confirmations();

        public int size();

        public int height();

        public int version();

        public String merkleRoot();

        public List<String> tx();

        public Date time();

        public long nonce();

        public String bits();

        public BigDecimal difficulty();

        public String previousHash();

        public String nextHash();

        public String chainwork();

        public Block previous() throws GenericRpcException;

        public Block next() throws GenericRpcException;
    }

    public static class BasicTxOutput
    implements TxOutput {
        private static final long serialVersionUID = 4906609252978270536L;
        public final String address;
        public final String label;
        public final BigDecimal amount;
        public final Boolean spendable;
        public final Boolean solvable;
        public final String desc;
        public final Boolean safe;
        public final byte[] data;

        public BasicTxOutput(String address, BigDecimal amount) {
            this(address, null, amount, null, null, null, null, null);
        }

        public BasicTxOutput(String address, BigDecimal amount, byte[] data) {
            this(address, null, amount, null, null, null, null, data);
        }

        public BasicTxOutput(String address, BigDecimal amount, Boolean spendable, byte[] data) {
            this(address, null, amount, spendable, null, null, null, data);
        }

        public BasicTxOutput(String address, String label, BigDecimal amount, Boolean spendable, Boolean solvable, String desc, Boolean safe, byte[] data) {
            this.address = address;
            this.label = label;
            this.amount = amount;
            this.spendable = spendable;
            this.solvable = solvable;
            this.desc = desc;
            this.safe = safe;
            this.data = data;
        }

        @Override
        public String address() {
            return this.address;
        }

        @Override
        public BigDecimal amount() {
            return this.amount;
        }

        @Override
        public byte[] data() {
            return this.data;
        }

        @Override
        public String label() {
            return this.label;
        }

        @Override
        public Boolean spendable() {
            return this.spendable;
        }

        @Override
        public Boolean solvable() {
            return this.solvable;
        }

        @Override
        public String desc() {
            return this.desc;
        }

        @Override
        public Boolean safe() {
            return this.safe;
        }
    }

    public static class BasicTxInput
    implements TxInput {
        public String txid;
        public Integer vout;
        public String scriptPubKey;
        public BigDecimal amount;

        public BasicTxInput(String txid, Integer vout) {
            this.txid = txid;
            this.vout = vout;
        }

        public BasicTxInput(String txid, Integer vout, String scriptPubKey) {
            this(txid, vout);
            this.scriptPubKey = scriptPubKey;
        }

        public BasicTxInput(String txid, Integer vout, String scriptPubKey, BigDecimal amount) {
            this(txid, vout, scriptPubKey);
            this.amount = amount;
        }

        @Override
        public String txid() {
            return this.txid;
        }

        @Override
        public Integer vout() {
            return this.vout;
        }

        @Override
        public String scriptPubKey() {
            return this.scriptPubKey;
        }

        @Override
        public BigDecimal amount() {
            return this.amount;
        }
    }

    public static interface AddressValidationResult
    extends MapWrapperType,
    Serializable {
        public boolean isValid();

        public String address();

        public boolean isMine();

        public boolean isScript();

        public String pubKey();

        public boolean isCompressed();

        public String account();
    }

    public static interface AddressUtxo {
        public String getAddress();

        public String getTxid();

        public int getOutputIndex();

        public String getScript();

        public long getSatoshis();

        public long getHeight();
    }

    public static interface AddressBalance {
        public long getBalance();

        public long getReceived();
    }

    public static interface Address
    extends MapWrapperType,
    Serializable {
        public String address();

        public String connected();
    }
}

