/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.jetty.servlet;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.lightbody.bmp.proxy.jetty.http.HttpConnection;
import net.lightbody.bmp.proxy.jetty.http.HttpFields;
import net.lightbody.bmp.proxy.jetty.http.HttpInputStream;
import net.lightbody.bmp.proxy.jetty.http.HttpRequest;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.ServletHandler;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.ServletHolder;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.ServletHttpResponse;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.ServletIn;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.SessionManager;
import net.lightbody.bmp.proxy.jetty.util.LazyList;
import net.lightbody.bmp.proxy.jetty.util.Resource;
import net.lightbody.bmp.proxy.jetty.util.StringUtil;
import net.lightbody.bmp.proxy.jetty.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletHttpRequest
implements HttpServletRequest {
    public static final String __SESSIONID_NOT_CHECKED = "not checked";
    public static final String __SESSIONID_URL = "url";
    public static final String __SESSIONID_COOKIE = "cookie";
    public static final String __SESSIONID_NONE = "none";
    private static final Enumeration __emptyEnum = Collections.enumeration(Collections.EMPTY_LIST);
    private static final Collection __defaultLocale = Collections.singleton(Locale.getDefault());
    private final Logger log = LoggerFactory.getLogger(ServletHttpRequest.class);
    private final HttpRequest _httpRequest;
    private ServletHandler _servletHandler;
    private ServletHttpResponse _servletHttpResponse;
    private String _contextPath = null;
    private String _servletPath = null;
    private String _pathInfo = null;
    private String _query = null;
    private String _pathTranslated = null;
    private String _requestedSessionId = null;
    private HttpSession _session = null;
    private String _sessionIdState = "not checked";
    private ServletIn _in = null;
    private BufferedReader _reader = null;
    private int _inputState = 0;
    private ServletHolder _servletHolder;
    private String _pathInContext;

    public ServletHttpRequest(ServletHandler servletHandler, String pathInContext, HttpRequest request) {
        this._servletHandler = servletHandler;
        this._pathInContext = pathInContext;
        this._contextPath = this._servletHandler.getHttpContext().getContextPath();
        if (this._contextPath.length() <= 1) {
            this._contextPath = "";
        }
        this._httpRequest = request;
    }

    public static ServletHttpRequest unwrap(ServletRequest request) {
        while (!(request instanceof ServletHttpRequest)) {
            if (request instanceof ServletRequestWrapper) {
                ServletRequestWrapper wrapper = (ServletRequestWrapper)request;
                request = wrapper.getRequest();
                continue;
            }
            throw new IllegalArgumentException("Does not wrap ServletHttpRequest");
        }
        return (ServletHttpRequest)request;
    }

    void recycle(ServletHandler servletHandler, String pathInContext) {
        this._servletHandler = servletHandler;
        this._pathInContext = pathInContext;
        this._servletPath = null;
        this._pathInfo = null;
        this._query = null;
        this._pathTranslated = null;
        this._requestedSessionId = null;
        this._session = null;
        this._sessionIdState = __SESSIONID_NOT_CHECKED;
        this._in = null;
        this._reader = null;
        this._inputState = 0;
        this._servletHolder = null;
        if (servletHandler != null) {
            this._contextPath = this._servletHandler.getHttpContext().getContextPath();
        }
        if (this._contextPath != null && this._contextPath.length() <= 1) {
            this._contextPath = "";
        }
    }

    ServletHandler getServletHandler() {
        return this._servletHandler;
    }

    void setServletHandler(ServletHandler servletHandler) {
        this._servletHandler = servletHandler;
    }

    void setServletPaths(String servletPath, String pathInfo, ServletHolder holder) {
        this._servletPath = servletPath;
        this._pathInfo = pathInfo;
        this._servletHolder = holder;
    }

    ServletHolder getServletHolder() {
        return this._servletHolder;
    }

    String getPathInContext() {
        return this._pathInContext;
    }

    HttpRequest getHttpRequest() {
        return this._httpRequest;
    }

    public ServletHttpResponse getServletHttpResponse() {
        return this._servletHttpResponse;
    }

    void setServletHttpResponse(ServletHttpResponse response) {
        this._servletHttpResponse = response;
    }

    public Locale getLocale() {
        Enumeration enm = this._httpRequest.getFieldValues("Accept-Language", ", \t");
        if (enm == null || !enm.hasMoreElements()) {
            return Locale.getDefault();
        }
        List acceptLanguage = HttpFields.qualityList(enm);
        if (acceptLanguage.size() == 0) {
            return Locale.getDefault();
        }
        int i = 0;
        int size = acceptLanguage.size();
        if (i < size) {
            String language = (String)acceptLanguage.get(i);
            language = HttpFields.valueParameters(language, null);
            String country = "";
            int dash = language.indexOf(45);
            if (dash > -1) {
                country = language.substring(dash + 1).trim();
                language = language.substring(0, dash).trim();
            }
            return new Locale(language, country);
        }
        return Locale.getDefault();
    }

    public Enumeration getLocales() {
        Enumeration enm = this._httpRequest.getFieldValues("Accept-Language", ", \t");
        if (enm == null || !enm.hasMoreElements()) {
            return Collections.enumeration(__defaultLocale);
        }
        List acceptLanguage = HttpFields.qualityList(enm);
        if (acceptLanguage.size() == 0) {
            return Collections.enumeration(__defaultLocale);
        }
        Object langs = null;
        int size = acceptLanguage.size();
        for (int i = 0; i < size; ++i) {
            String language = (String)acceptLanguage.get(i);
            language = HttpFields.valueParameters(language, null);
            String country = "";
            int dash = language.indexOf(45);
            if (dash > -1) {
                country = language.substring(dash + 1).trim();
                language = language.substring(0, dash).trim();
            }
            langs = LazyList.ensureSize(langs, size);
            langs = LazyList.add(langs, new Locale(language, country));
        }
        if (LazyList.size(langs) == 0) {
            return Collections.enumeration(__defaultLocale);
        }
        return Collections.enumeration(LazyList.getList(langs));
    }

    public boolean isSecure() {
        return this._httpRequest.isConfidential();
    }

    public Cookie[] getCookies() {
        Cookie[] cookies = this._httpRequest.getCookies();
        if (cookies.length == 0) {
            return null;
        }
        return cookies;
    }

    public long getDateHeader(String name) {
        return this._httpRequest.getDateField(name);
    }

    public Enumeration getHeaderNames() {
        return this._httpRequest.getFieldNames();
    }

    public String getHeader(String name) {
        return this._httpRequest.getField(name);
    }

    public Enumeration getHeaders(String s) {
        Enumeration enm = this._httpRequest.getFieldValues(s);
        if (enm == null) {
            return __emptyEnum;
        }
        return enm;
    }

    public int getIntHeader(String name) throws NumberFormatException {
        return this._httpRequest.getIntField(name);
    }

    public String getMethod() {
        return this._httpRequest.getMethod();
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public String getPathInfo() {
        if (this._servletPath == null) {
            return null;
        }
        return this._pathInfo;
    }

    public String getPathTranslated() {
        if (this._pathInfo == null || this._pathInfo.length() == 0) {
            return null;
        }
        if (this._pathTranslated == null) {
            Resource resource = this._servletHandler.getHttpContext().getBaseResource();
            if (resource == null) {
                return null;
            }
            try {
                resource = resource.addPath(this._pathInfo);
                File file = resource.getFile();
                if (file == null) {
                    return null;
                }
                this._pathTranslated = file.getAbsolutePath();
            }
            catch (Exception e) {
                this.log.debug("EXCEPTION ", (Throwable)e);
            }
        }
        return this._pathTranslated;
    }

    public String getQueryString() {
        if (this._query == null) {
            this._query = this._httpRequest.getQuery();
        }
        return this._query;
    }

    public String getAuthType() {
        String at = this._httpRequest.getAuthType();
        if (at.equals("BASIC")) {
            return "BASIC";
        }
        if (at.equals("FORM")) {
            return "FORM";
        }
        if (at.equals("DIGEST")) {
            return "DIGEST";
        }
        if (at.equals("CLIENT_CERT")) {
            return "CLIENT_CERT";
        }
        if (at.equals("CLIENT-CERT")) {
            return "CLIENT_CERT";
        }
        return at;
    }

    public String getRemoteUser() {
        return this._httpRequest.getAuthUser();
    }

    public boolean isUserInRole(String role) {
        if (this._servletHolder != null) {
            role = this._servletHolder.getUserRoleLink(role);
        }
        return this._httpRequest.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this._httpRequest.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this._requestedSessionId;
    }

    void setRequestedSessionId(String pathParams) {
        Cookie[] cookies;
        this._requestedSessionId = null;
        if (this._servletHandler.isUsingCookies() && (cookies = this._httpRequest.getCookies()) != null && cookies.length > 0) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!SessionManager.__SessionCookie.equalsIgnoreCase(cookies[i].getName())) continue;
                if (this._requestedSessionId != null) {
                    SessionManager manager = this._servletHandler.getSessionManager();
                    if (manager != null && manager.getHttpSession(this._requestedSessionId) != null) break;
                    this.log.debug("multiple session cookies");
                }
                this._requestedSessionId = cookies[i].getValue();
                this._sessionIdState = __SESSIONID_COOKIE;
                this.log.debug("Got Session {} from cookie", (Object)this._requestedSessionId);
            }
        }
        if (pathParams != null && pathParams.startsWith(SessionManager.__SessionURL)) {
            String id = pathParams.substring(SessionManager.__SessionURL.length() + 1);
            this.log.debug("Got Session {} from URL", (Object)id);
            if (this._requestedSessionId == null) {
                this._requestedSessionId = id;
                this._sessionIdState = __SESSIONID_URL;
            } else if (!id.equals(this._requestedSessionId)) {
                this.log.debug("Mismatched session IDs");
            }
        }
        if (this._requestedSessionId == null) {
            this._sessionIdState = __SESSIONID_NONE;
        }
    }

    public String getRequestURI() {
        return this._httpRequest.getEncodedPath();
    }

    public StringBuffer getRequestURL() {
        StringBuffer buf = this._httpRequest.getRootURL();
        buf.append(this.getRequestURI());
        return buf;
    }

    public String getServletPath() {
        if (this._servletPath == null) {
            return this._pathInContext;
        }
        return this._servletPath;
    }

    public HttpSession getSession(boolean create) {
        if (this._session != null && ((SessionManager.Session)this._session).isValid()) {
            return this._session;
        }
        this._session = null;
        String id = this.getRequestedSessionId();
        if (id != null) {
            this._session = this._servletHandler.getHttpSession(id);
            if (this._session == null && !create) {
                return null;
            }
        }
        if (this._session == null && create) {
            this._session = this.newSession();
        }
        return this._session;
    }

    HttpSession newSession() {
        HttpSession session = this._servletHandler.newHttpSession(this);
        Cookie cookie = this._servletHandler.getSessionManager().getSessionCookie(session, this.isSecure());
        if (cookie != null) {
            this._servletHttpResponse.getHttpResponse().addSetCookie(cookie);
        }
        return session;
    }

    public HttpSession getSession() {
        HttpSession session = this.getSession(true);
        return session;
    }

    public boolean isRequestedSessionIdValid() {
        return this._requestedSessionId != null && this.getSession(false) != null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this._sessionIdState.equals(__SESSIONID_COOKIE);
    }

    public boolean isRequestedSessionIdFromURL() {
        return this._sessionIdState.equals(__SESSIONID_URL);
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public Enumeration getAttributeNames() {
        return this._httpRequest.getAttributeNames();
    }

    public Object getAttribute(String name) {
        return this._httpRequest.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this._httpRequest.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this._httpRequest.removeAttribute(name);
    }

    public String getCharacterEncoding() {
        return this._httpRequest.getCharacterEncoding();
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this._inputState != 0) {
            throw new IllegalStateException("getReader() or getInputStream() called");
        }
        "".getBytes(encoding);
        this._httpRequest.setCharacterEncoding(encoding, false);
    }

    public int getContentLength() {
        return this._httpRequest.getContentLength();
    }

    public String getContentType() {
        return this._httpRequest.getContentType();
    }

    public ServletInputStream getInputStream() {
        if (this._inputState != 0 && this._inputState != 1) {
            throw new IllegalStateException();
        }
        if (this._in == null) {
            this._in = new ServletIn((HttpInputStream)this._httpRequest.getInputStream());
        }
        this._inputState = 1;
        this._reader = null;
        return this._in;
    }

    public Map getParameterMap() {
        return Collections.unmodifiableMap(this._httpRequest.getParameterStringArrayMap());
    }

    public String getParameter(String name) {
        return this._httpRequest.getParameter(name);
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this._httpRequest.getParameterNames());
    }

    public String[] getParameterValues(String name) {
        List v = this._httpRequest.getParameterValues(name);
        if (v == null) {
            return null;
        }
        String[] a = new String[v.size()];
        return v.toArray(a);
    }

    public String getProtocol() {
        return this._httpRequest.getVersion();
    }

    public String getScheme() {
        return this._httpRequest.getScheme();
    }

    public String getServerName() {
        return this._httpRequest.getHost();
    }

    public int getServerPort() {
        int port = this._httpRequest.getPort();
        if (port == 0) {
            if (this.getScheme().equalsIgnoreCase("https")) {
                return 443;
            }
            return 80;
        }
        return port;
    }

    public int getRemotePort() {
        HttpConnection connection = this._httpRequest.getHttpConnection();
        if (connection != null) {
            return connection.getRemotePort();
        }
        return 0;
    }

    public String getLocalName() {
        HttpConnection connection = this._httpRequest.getHttpConnection();
        if (connection != null) {
            return connection.getServerName();
        }
        return null;
    }

    public String getLocalAddr() {
        HttpConnection connection = this._httpRequest.getHttpConnection();
        if (connection != null) {
            return connection.getServerAddr();
        }
        return null;
    }

    public int getLocalPort() {
        HttpConnection connection = this._httpRequest.getHttpConnection();
        if (connection != null) {
            return connection.getServerPort();
        }
        return 0;
    }

    public BufferedReader getReader() throws UnsupportedEncodingException {
        if (this._inputState != 0 && this._inputState != 2) {
            throw new IllegalStateException();
        }
        if (this._reader == null) {
            String encoding = this.getCharacterEncoding();
            if (encoding == null) {
                encoding = StringUtil.__ISO_8859_1;
            }
            this._reader = new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), encoding));
        }
        this._inputState = 2;
        return this._reader;
    }

    public String getRemoteAddr() {
        return this._httpRequest.getRemoteAddr();
    }

    public String getRemoteHost() {
        if (this._httpRequest.getHttpConnection() == null) {
            return null;
        }
        return this._httpRequest.getRemoteHost();
    }

    public String getRealPath(String path) {
        return this._servletHandler.getServletContext().getRealPath(path);
    }

    public RequestDispatcher getRequestDispatcher(String url) {
        if (url == null) {
            return null;
        }
        if (!url.startsWith("/")) {
            String relTo = URI.addPaths(this._servletPath, this._pathInfo);
            int slash = relTo.lastIndexOf("/");
            relTo = slash > 1 ? relTo.substring(0, slash + 1) : "/";
            url = URI.addPaths(relTo, url);
        }
        return this._servletHandler.getServletContext().getRequestDispatcher(url);
    }

    public String toString() {
        return this.getContextPath() + "+" + this.getServletPath() + "+" + this.getPathInfo() + "\n" + this._httpRequest.toString();
    }
}

