/*
 * Decompiled with CFR 0.152.
 */
package website.magyar.mitm.proxy.http;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import net.lightbody.bmp.proxy.http.BrowserMobHttpClient;
import net.lightbody.bmp.proxy.http.RequestCallback;
import net.lightbody.bmp.proxy.jetty.http.HttpRequest;
import net.lightbody.bmp.proxy.util.Base64;
import net.lightbody.bmp.proxy.util.ClonedInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import website.magyar.mitm.idgenerator.TimeStampBasedIdGenerator;
import website.magyar.mitm.proxy.http.MitmJavaProxyHttpResponse;

public class MitmJavaProxyHttpRequest {
    public static final TimeStampBasedIdGenerator TIME_STAMP_BASED_ID_GENERATOR = new TimeStampBasedIdGenerator();
    protected static final Logger logger = LoggerFactory.getLogger(MitmJavaProxyHttpRequest.class);
    private final HttpRequestBase method;
    private final BrowserMobHttpClient client;
    private final List<NameValuePair> nvps = new ArrayList<NameValuePair>();
    private final boolean collectAdditionalInfo;
    private final HttpRequest proxyRequest;
    private final String messageId = TIME_STAMP_BASED_ID_GENERATOR.nextIdentifier();
    private int expectedStatusCode;
    private StringEntity stringEntity;
    private ByteArrayEntity byteArrayEntity;
    private InputStreamEntity inputStreamEntity;
    private MultipartEntityBuilder multipartEntityBuilder;
    private OutputStream outputStream;
    private RequestCallback requestCallback;
    private ByteArrayOutputStream copy;
    private String expectedLocation;
    private boolean multiPart;
    private InputStream playGround;
    private boolean responseVolatile = false;

    public MitmJavaProxyHttpRequest(HttpRequestBase method, BrowserMobHttpClient client, int expectedStatusCode, boolean collectAdditionalInfo, HttpRequest proxyRequest) {
        this.method = method;
        this.client = client;
        this.expectedStatusCode = expectedStatusCode;
        this.collectAdditionalInfo = collectAdditionalInfo;
        this.proxyRequest = proxyRequest;
    }

    public String getExpectedLocation() {
        return this.expectedLocation;
    }

    public void setExpectedLocation(String location) {
        this.expectedLocation = location;
    }

    public void addRequestHeader(String key, String value) {
        this.method.addHeader(key, value);
    }

    public void addRequestParameter(String key, String value) {
        this.nvps.add((NameValuePair)new BasicNameValuePair(key, value));
    }

    public void setRequestBody(String body, String contentType, String charSet) {
        try {
            this.stringEntity = new StringEntity(body, ContentType.create((String)contentType, (String)charSet));
        }
        catch (UnsupportedCharsetException e) {
            this.stringEntity = new StringEntity(body, ContentType.create((String)contentType, (String)null));
        }
    }

    public void setRequestBody(String body) {
        this.setRequestBody(body, null, "UTF-8");
    }

    public void setRequestBodyAsBase64EncodedBytes(String bodyBase64Encoded) {
        this.byteArrayEntity = new ByteArrayEntity(Base64.base64ToByteArray(bodyBase64Encoded));
    }

    public void setRequestInputStream(InputStream is, long length) {
        if (this.collectAdditionalInfo) {
            ClonedInputStream cis = new ClonedInputStream(is);
            is = cis;
            this.copy = cis.getOutput();
        }
        this.inputStreamEntity = new InputStreamEntity(is, length);
    }

    public HttpRequestBase getMethod() {
        return this.method;
    }

    public HttpRequest getProxyRequest() {
        return this.proxyRequest;
    }

    public void makeMultiPart() {
        if (!this.multiPart) {
            this.multiPart = true;
            this.multipartEntityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        }
    }

    public MitmJavaProxyHttpResponse execute() {
        block14: {
            if (this.method instanceof HttpEntityEnclosingRequestBase) {
                HttpEntityEnclosingRequestBase enclosingRequest = (HttpEntityEnclosingRequestBase)this.method;
                if (!this.nvps.isEmpty()) {
                    try {
                        if (!this.multiPart) {
                            enclosingRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(this.nvps, "UTF-8"));
                            break block14;
                        }
                        for (NameValuePair nvp : this.nvps) {
                            this.multipartEntityBuilder.addPart(nvp.getName(), (ContentBody)new StringBody(nvp.getValue()));
                        }
                        enclosingRequest.setEntity(this.multipartEntityBuilder.build());
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.error("Could not find UTF-8 encoding, something is really wrong", (Throwable)e);
                    }
                } else if (this.multipartEntityBuilder != null) {
                    enclosingRequest.setEntity(this.multipartEntityBuilder.build());
                } else if (this.byteArrayEntity != null) {
                    enclosingRequest.setEntity((HttpEntity)this.byteArrayEntity);
                } else if (this.stringEntity != null) {
                    enclosingRequest.setEntity((HttpEntity)this.stringEntity);
                } else if (this.inputStreamEntity != null) {
                    enclosingRequest.setEntity((HttpEntity)this.inputStreamEntity);
                }
            }
        }
        return this.client.execute(this);
    }

    public int getExpectedStatusCode() {
        return this.expectedStatusCode;
    }

    public void setExpectedStatusCode(int expectedStatusCode) {
        this.expectedStatusCode = expectedStatusCode;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public RequestCallback getRequestCallback() {
        return this.requestCallback;
    }

    public void setRequestCallback(RequestCallback requestCallback) {
        this.requestCallback = requestCallback;
    }

    public ByteArrayOutputStream getCopy() {
        return this.copy;
    }

    public InputStream getPlayGround() {
        return this.playGround;
    }

    public void setPlayGround(InputStream playGround) {
        this.playGround = playGround;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public boolean getResponseVolatile() {
        return this.responseVolatile;
    }

    public void setResponseVolatile(boolean responseVolatile) {
        this.responseVolatile = responseVolatile;
    }

    public void setBody(byte[] body) {
        if (body != null && this.getMethod() instanceof HttpEntityEnclosingRequestBase) {
            HttpEntityEnclosingRequestBase enclosingRequest = (HttpEntityEnclosingRequestBase)this.getMethod();
            enclosingRequest.setEntity((HttpEntity)new ByteArrayEntity(body));
        }
    }
}

