/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.lightbody.bmp.proxy.jetty.util.LazyList;
import net.lightbody.bmp.proxy.jetty.util.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Container
implements LifeCycle,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(Container.class);
    private Object _components;
    private transient boolean _started;
    private transient boolean _starting;
    private transient boolean _stopping;

    @Override
    public final synchronized void start() throws Exception {
        if (this._started || this._starting) {
            return;
        }
        this._starting = true;
        log.debug("Starting {}", (Object)this);
        try {
            this.doStart();
            this._started = true;
            log.info("Started {}", (Object)this);
        }
        catch (Throwable e) {
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw (Error)e;
        }
        finally {
            this._starting = false;
        }
    }

    protected abstract void doStart() throws Exception;

    @Override
    public synchronized boolean isStarted() {
        return this._started;
    }

    @Override
    public final synchronized void stop() throws InterruptedException {
        if (!this._started || this._stopping) {
            return;
        }
        this._stopping = true;
        log.debug("Stopping {}", (Object)this);
        try {
            this.doStop();
            this._started = false;
            log.info("Stopped {}", (Object)this);
        }
        catch (Throwable e) {
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            log.warn("EXCEPTION ", e);
        }
        finally {
            this._stopping = false;
        }
    }

    protected abstract void doStop() throws Exception;

    protected void addComponent(Object o) {
        if (!LazyList.contains(this._components, o)) {
            this._components = LazyList.add(this._components, o);
            log.debug("add component: {}", o);
        }
    }

    protected void removeComponent(Object o) {
        if (LazyList.contains(this._components, o)) {
            this._components = LazyList.remove(this._components, o);
            log.debug("remove component: {}", o);
        }
    }

    public void destroy() {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this._components = null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

