/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import net.lightbody.bmp.proxy.jetty.util.BadResource;
import net.lightbody.bmp.proxy.jetty.util.CachedResource;
import net.lightbody.bmp.proxy.jetty.util.FileResource;
import net.lightbody.bmp.proxy.jetty.util.IO;
import net.lightbody.bmp.proxy.jetty.util.JarFileResource;
import net.lightbody.bmp.proxy.jetty.util.JarResource;
import net.lightbody.bmp.proxy.jetty.util.StringUtil;
import net.lightbody.bmp.proxy.jetty.util.URI;
import net.lightbody.bmp.proxy.jetty.util.URLResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Resource
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Resource.class);
    Object _associate;

    public static Resource newResource(URL url) {
        if (url == null) {
            return null;
        }
        String urls = url.toExternalForm();
        if (urls.startsWith("file:")) {
            try {
                FileResource fileResource = new FileResource(url);
                return fileResource;
            }
            catch (Exception e) {
                log.debug("EXCEPTION ", (Throwable)e);
                return new BadResource(url, e.toString());
            }
        }
        if (urls.startsWith("jar:file:")) {
            return new JarFileResource(url);
        }
        if (urls.startsWith("jar:")) {
            return new JarResource(url);
        }
        return new URLResource(url, null);
    }

    public static Resource newResource(String resource) throws IOException {
        URL url = null;
        try {
            url = new URL(resource);
        }
        catch (MalformedURLException e) {
            if (!(resource.startsWith("ftp:") || resource.startsWith("file:") || resource.startsWith("jar:"))) {
                try {
                    if (resource.startsWith("./")) {
                        resource = resource.substring(2);
                    }
                    File file = new File(resource).getCanonicalFile();
                    url = file.toURI().toURL();
                    URLConnection connection = url.openConnection();
                    FileResource fileResource = new FileResource(url, connection, file);
                    return fileResource;
                }
                catch (Exception e2) {
                    log.debug("EXCEPTION ", (Throwable)e2);
                    throw e;
                }
            }
            log.warn("Bad Resource: " + resource);
            throw e;
        }
        String nurl = url.toString();
        if (!(nurl.length() <= 0 || nurl.charAt(nurl.length() - 1) == resource.charAt(resource.length() - 1) || nurl.charAt(nurl.length() - 1) == '/' && nurl.charAt(nurl.length() - 2) == resource.charAt(resource.length() - 1) || resource.charAt(resource.length() - 1) == '/' && resource.charAt(resource.length() - 2) == nurl.charAt(nurl.length() - 1))) {
            return new BadResource(url, "Trailing special characters stripped by URL in " + resource);
        }
        return Resource.newResource(url);
    }

    protected void finalize() {
        this.release();
    }

    public abstract void release();

    public abstract boolean exists();

    public abstract boolean isDirectory();

    public abstract long lastModified();

    public abstract long length();

    public abstract URL getURL();

    public abstract File getFile() throws IOException;

    public abstract String getName();

    public abstract InputStream getInputStream() throws IOException;

    public abstract OutputStream getOutputStream() throws IOException, SecurityException;

    public abstract boolean delete() throws SecurityException;

    public abstract boolean renameTo(Resource var1) throws SecurityException;

    public abstract String[] list();

    public abstract Resource addPath(String var1) throws IOException;

    public String encode(String uri) {
        return URI.encodePath(uri);
    }

    public Object getAssociate() {
        return this._associate;
    }

    public void setAssociate(Object o) {
        this._associate = o;
    }

    public URL getAlias() {
        return null;
    }

    public CachedResource cache() throws IOException {
        return new CachedResource(this);
    }

    public String getListHTML(String base, boolean parent) throws IOException {
        if (!this.isDirectory()) {
            return null;
        }
        Object[] ls = this.list();
        if (ls == null) {
            return null;
        }
        Arrays.sort(ls);
        Object title = "Directory: " + URI.decodePath(base);
        title = StringUtil.replace(StringUtil.replace((String)title, "<", "&lt;"), ">", "&gt;");
        StringBuffer buf = new StringBuffer(4096);
        buf.append("<HTML><HEAD><TITLE>");
        buf.append((String)title);
        buf.append("</TITLE></HEAD><BODY>\n<H1>");
        buf.append((String)title);
        buf.append("</H1><TABLE BORDER=0>");
        if (parent) {
            buf.append("<TR><TD><A HREF=");
            buf.append(URI.encodePath(URI.addPaths(base, "../")));
            buf.append(">Parent Directory</A></TD><TD></TD><TD></TD></TR>\n");
        }
        DateFormat dfmt = DateFormat.getDateTimeInstance(2, 2);
        for (int i = 0; i < ls.length; ++i) {
            String encoded = URI.encodePath((String)ls[i]);
            Resource item = this.addPath(encoded);
            buf.append("<TR><TD><A HREF=\"");
            String path = URI.addPaths(base, encoded);
            if (item.isDirectory() && !path.endsWith("/")) {
                path = URI.addPaths(path, "/");
            }
            buf.append(path);
            buf.append("\">");
            buf.append(StringUtil.replace(StringUtil.replace((String)ls[i], "<", "&lt;"), ">", "&gt;"));
            buf.append("&nbsp;");
            buf.append("</TD><TD ALIGN=right>");
            buf.append(item.length());
            buf.append(" bytes&nbsp;</TD><TD>");
            buf.append(dfmt.format(new Date(item.lastModified())));
            buf.append("</TD></TR>\n");
        }
        buf.append("</TABLE>\n");
        buf.append("</BODY></HTML>\n");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out, long start, long count) throws IOException {
        try (InputStream in = this.getInputStream();){
            in.skip(start);
            if (count < 0L) {
                IO.copy(in, out);
            } else {
                IO.copy(in, out, (long)((int)count));
            }
        }
    }
}

