/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.jetty.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.lightbody.bmp.proxy.jetty.http.EOFException;
import net.lightbody.bmp.proxy.jetty.http.HttpContext;
import net.lightbody.bmp.proxy.jetty.http.HttpException;
import net.lightbody.bmp.proxy.jetty.http.HttpHandler;
import net.lightbody.bmp.proxy.jetty.http.HttpRequest;
import net.lightbody.bmp.proxy.jetty.http.HttpResponse;
import net.lightbody.bmp.proxy.jetty.http.PathMap;
import net.lightbody.bmp.proxy.jetty.http.Version;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.HashSessionManager;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.ServletHolder;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.ServletHttpRequest;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.ServletHttpResponse;
import net.lightbody.bmp.proxy.jetty.jetty.servlet.SessionManager;
import net.lightbody.bmp.proxy.jetty.util.ByteArrayISO8859Writer;
import net.lightbody.bmp.proxy.jetty.util.Container;
import net.lightbody.bmp.proxy.jetty.util.MultiException;
import net.lightbody.bmp.proxy.jetty.util.Resource;
import net.lightbody.bmp.proxy.jetty.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletHandler
extends Container
implements HttpHandler {
    public static final String __DEFAULT_SERVLET = "default";
    public static final String __J_S_CONTEXT_TEMPDIR = "javax.servlet.context.tempdir";
    public static final String __J_S_ERROR_EXCEPTION = "javax.servlet.error.exception";
    public static final String __J_S_ERROR_EXCEPTION_TYPE = "javax.servlet.error.exception_type";
    public static final String __J_S_ERROR_MESSAGE = "javax.servlet.error.message";
    public static final String __J_S_ERROR_REQUEST_URI = "javax.servlet.error.request_uri";
    public static final String __J_S_ERROR_SERVLET_NAME = "javax.servlet.error.servlet_name";
    public static final String __J_S_ERROR_STATUS_CODE = "javax.servlet.error.status_code";
    private static final boolean __Slosh2Slash = File.separatorChar == '\\';
    private static final String __AllowString = "GET, HEAD, POST, OPTIONS, TRACE";
    private final Logger log = LoggerFactory.getLogger(ServletHandler.class);
    protected PathMap _servletMap = new PathMap();
    protected Map _nameMap = new HashMap();
    protected Map _attributes = new HashMap(3);
    protected String _formLoginPage;
    protected String _formErrorPage;
    protected SessionManager _sessionManager;
    protected transient Context _context = new Context();
    protected transient ClassLoader _loader;
    protected transient HttpContext _httpContext;
    private boolean _usingCookies = true;
    private boolean _autoInitializeServlets = true;
    private String _name;

    @Override
    public String getName() {
        if (this._name == null) {
            this._name = this.getClass().getName();
            if (!this.log.isDebugEnabled()) {
                this._name = this._name.substring(this._name.lastIndexOf(46) + 1);
            }
        }
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    public HttpContext getHttpContext() {
        return this._httpContext;
    }

    @Override
    public void initialize(HttpContext context) {
        SessionManager sessionManager = this.getSessionManager();
        if (this._httpContext != null && this._httpContext != context) {
            throw new IllegalStateException("Can't initialize handler for different context");
        }
        this._httpContext = context;
        sessionManager.initialize(this);
    }

    public void formAuthInit(String formLoginPage, String formErrorPage) {
        this._formLoginPage = formLoginPage;
        this._formErrorPage = formErrorPage;
    }

    public SessionManager getSessionManager() {
        if (this._sessionManager == null) {
            this._sessionManager = new HashSessionManager();
            this.addComponent(this._sessionManager);
        }
        return this._sessionManager;
    }

    public void setSessionManager(SessionManager sm) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        int mii = 0;
        boolean setMii = false;
        if (this._sessionManager != null) {
            mii = this._sessionManager.getMaxInactiveInterval();
            setMii = true;
            if (this.getHttpContext() != null) {
                this._sessionManager.initialize(null);
            }
            this.removeComponent(this._sessionManager);
        }
        this._sessionManager = sm;
        if (this._sessionManager != null) {
            if (this.getHttpContext() != null) {
                this._sessionManager.initialize(this);
            }
            if (setMii) {
                this._sessionManager.setMaxInactiveInterval(mii);
            }
            this.addComponent(this._sessionManager);
        }
        this._sessionManager = sm;
    }

    public ServletContext getServletContext() {
        return this._context;
    }

    public PathMap getServletMap() {
        return this._servletMap;
    }

    public boolean isUsingCookies() {
        return this._usingCookies;
    }

    public void setUsingCookies(boolean uc) {
        this._usingCookies = uc;
    }

    public ClassLoader getClassLoader() {
        return this._loader;
    }

    public ServletHolder newServletHolder(String name, String servletClass, String forcedPath) {
        if (this._nameMap.containsKey(name)) {
            throw new IllegalArgumentException("Named servlet already exists: " + name);
        }
        ServletHolder holder = new ServletHolder(this, name, servletClass, forcedPath);
        this.addServletHolder(holder);
        return holder;
    }

    public ServletHolder newServletHolder(String name, String servletClass) {
        return this.newServletHolder(name, servletClass, null);
    }

    public ServletHolder getServletHolder(String name) {
        return (ServletHolder)this._nameMap.get(name);
    }

    public ServletHolder mapPathToServlet(String pathSpec, String servletName) {
        ServletHolder holder = (ServletHolder)this._nameMap.get(servletName);
        if (!pathSpec.startsWith("/") && !pathSpec.startsWith("*")) {
            this.log.warn("pathSpec should start with '/' or '*' : {}", (Object)pathSpec);
            pathSpec = "/" + pathSpec;
        }
        if (holder == null) {
            throw new IllegalArgumentException("Unknown servlet: " + servletName);
        }
        this._servletMap.put(pathSpec, holder);
        return holder;
    }

    public ServletHolder addServlet(String name, String pathSpec, String servletClass, String forcedPath) {
        ServletHolder holder = this.getServletHolder(name);
        if (holder == null) {
            holder = this.newServletHolder(name, servletClass, forcedPath);
        }
        this.mapPathToServlet(pathSpec, name);
        if (this.isStarted() && !holder.isStarted()) {
            try {
                holder.start();
            }
            catch (Exception e) {
                this.log.warn("EXCEPTION ", (Throwable)e);
            }
        }
        return holder;
    }

    public ServletHolder addServlet(String name, String pathSpec, String servletClass) {
        return this.addServlet(name, pathSpec, servletClass, null);
    }

    public ServletHolder addServlet(String pathSpec, String servletClass) {
        return this.addServlet(servletClass, pathSpec, servletClass, null);
    }

    public void addServletHolder(ServletHolder holder) {
        ServletHolder existing = (ServletHolder)this._nameMap.get(holder.getName());
        if (existing == null) {
            this._nameMap.put(holder.getName(), holder);
        } else if (existing != holder) {
            throw new IllegalArgumentException("Holder already exists for name: " + holder.getName());
        }
        this.addComponent(holder);
    }

    public boolean isAutoInitializeServlets() {
        return this._autoInitializeServlets;
    }

    public void setAutoInitializeServlets(boolean b) {
        this._autoInitializeServlets = b;
    }

    @Override
    protected synchronized void doStart() throws Exception {
        if (this.isStarted()) {
            return;
        }
        if (this._sessionManager != null) {
            this._sessionManager.start();
        }
        this._loader = this.getHttpContext().getClassLoader();
        if (this._autoInitializeServlets) {
            this.initializeServlets();
        }
    }

    public ServletHolder[] getServlets() {
        HashSet holder_set = new HashSet(this._nameMap.size());
        holder_set.addAll(this._nameMap.values());
        Object[] holders = holder_set.toArray(new ServletHolder[holder_set.size()]);
        Arrays.sort(holders);
        return holders;
    }

    public void initializeServlets() throws Exception {
        MultiException mx = new MultiException();
        ServletHolder[] holders = this.getServlets();
        for (int i = 0; i < holders.length; ++i) {
            try {
                holders[i].start();
                continue;
            }
            catch (Exception e) {
                this.log.debug("EXCEPTION ", (Throwable)e);
                mx.add(e);
            }
        }
        mx.ifExceptionThrow();
    }

    @Override
    protected synchronized void doStop() throws Exception {
        ServletHolder[] holders = this.getServlets();
        int i = holders.length;
        while (i-- > 0) {
            try {
                if (!holders[i].isStarted()) continue;
                holders[i].stop();
            }
            catch (Exception e) {
                this.log.warn("EXCEPTION ", (Throwable)e);
            }
        }
        this._sessionManager.stop();
        this._attributes.clear();
        this._loader = null;
    }

    public HttpSession getHttpSession(String id) {
        return this._sessionManager.getHttpSession(id);
    }

    public HttpSession newHttpSession(HttpServletRequest request) {
        return this._sessionManager.newHttpSession(request);
    }

    public void setSessionInactiveInterval(int seconds) {
        this._sessionManager.setMaxInactiveInterval(seconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String pathInContext, String pathParams, HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        if (!this.isStarted()) {
            return;
        }
        if ("TRACE".equals(httpRequest.getMethod())) {
            this.handleTrace(httpRequest, httpResponse);
            return;
        }
        ServletHttpRequest request = (ServletHttpRequest)httpRequest.getWrapper();
        ServletHttpResponse response = (ServletHttpResponse)httpResponse.getWrapper();
        if (request == null) {
            request = new ServletHttpRequest(this, pathInContext, httpRequest);
            response = new ServletHttpResponse(request, httpResponse);
            httpRequest.setWrapper(request);
            httpResponse.setWrapper(response);
        } else {
            request.recycle(this, pathInContext);
            response.recycle();
        }
        Map.Entry servlet = this.getHolderEntry(pathInContext);
        ServletHolder servletHolder = servlet == null ? null : (ServletHolder)servlet.getValue();
        this.log.debug("servlet={}", (Object)servlet);
        try {
            if (servlet != null) {
                String servletPathSpec = (String)servlet.getKey();
                request.setServletPaths(PathMap.pathMatch(servletPathSpec, pathInContext), PathMap.pathInfo(servletPathSpec, pathInContext), servletHolder);
            }
            request.setRequestedSessionId(pathParams);
            HttpSession session = request.getSession(false);
            if (session != null) {
                ((SessionManager.Session)session).access();
            }
            this.log.debug("session={}", (Object)session);
            if (servletHolder != null) {
                this.dispatch(pathInContext, request, response, servletHolder, 1);
            }
        }
        catch (Exception e) {
            this.log.debug("EXCEPTION ", (Throwable)e);
            Throwable th = e;
            while (th instanceof ServletException) {
                this.log.warn("EXCEPTION ", th);
                Throwable cause = ((ServletException)th).getRootCause();
                if (cause == th || cause == null) break;
                th = cause;
            }
            if (th instanceof HttpException) {
                throw (HttpException)th;
            }
            if (th instanceof EOFException) {
                throw (IOException)th;
            }
            if (!(th instanceof IOException)) {
                if (th instanceof RuntimeException) {
                    this.log.error("{}: ", (Object)httpRequest.getURI(), (Object)th);
                } else {
                    this.log.warn("{}: ", (Object)httpRequest.getURI(), (Object)th);
                }
            }
            httpResponse.getHttpConnection().forceClose();
            if (!httpResponse.isCommitted()) {
                request.setAttribute(__J_S_ERROR_EXCEPTION_TYPE, th.getClass());
                request.setAttribute(__J_S_ERROR_EXCEPTION, th);
                if (th instanceof UnavailableException) {
                    UnavailableException ue = (UnavailableException)th;
                    if (ue.isPermanent()) {
                        response.sendError(404, e.getMessage());
                    } else {
                        response.sendError(503, e.getMessage());
                    }
                } else {
                    response.sendError(500, e.getMessage());
                }
            } else {
                this.log.debug("Response already committed for handling {}", th);
            }
        }
        catch (Error e) {
            this.log.warn("Error for {}", (Object)httpRequest.getURI(), (Object)e);
            httpResponse.getHttpConnection().forceClose();
            if (!httpResponse.isCommitted()) {
                request.setAttribute(__J_S_ERROR_EXCEPTION_TYPE, e.getClass());
                request.setAttribute(__J_S_ERROR_EXCEPTION, e);
                response.sendError(500, e.getMessage());
            } else {
                this.log.debug("Response already committed for handling ", (Throwable)e);
            }
        }
        finally {
            if (servletHolder != null) {
                response.complete();
            }
        }
    }

    protected void dispatch(String pathInContext, HttpServletRequest request, HttpServletResponse response, ServletHolder servletHolder, int type) throws ServletException, UnavailableException, IOException {
        servletHolder.handle((ServletRequest)request, (ServletResponse)response);
    }

    public Map.Entry getHolderEntry(String pathInContext) {
        return this._servletMap.getMatch(pathInContext);
    }

    public Set getResourcePaths(String uriInContext) {
        try {
            uriInContext = URI.canonicalPath(uriInContext);
            if (uriInContext == null) {
                return Collections.EMPTY_SET;
            }
            Resource resource = this.getHttpContext().getResource(uriInContext);
            if (resource == null || !resource.isDirectory()) {
                return Collections.EMPTY_SET;
            }
            String[] contents = resource.list();
            if (contents == null || contents.length == 0) {
                return Collections.EMPTY_SET;
            }
            HashSet<String> set = new HashSet<String>(contents.length * 2);
            for (int i = 0; i < contents.length; ++i) {
                set.add(URI.addPaths(uriInContext, contents[i]));
            }
            return set;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.EMPTY_SET;
        }
    }

    public URL getResource(String uriInContext) throws MalformedURLException {
        if (uriInContext == null || !uriInContext.startsWith("/")) {
            throw new MalformedURLException(uriInContext);
        }
        try {
            Resource resource = this.getHttpContext().getResource(uriInContext);
            if (resource != null && resource.exists()) {
                return resource.getURL();
            }
        }
        catch (IllegalArgumentException resource) {
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (IOException e) {
            this.log.warn("EXCEPTION ", (Throwable)e);
        }
        return null;
    }

    public InputStream getResourceAsStream(String uriInContext) {
        if (uriInContext == null || !uriInContext.startsWith("/")) {
            return null;
        }
        try {
            Resource resource = this.getHttpContext().getResource(uriInContext);
            if (resource != null) {
                return resource.getInputStream();
            }
            URL url = this.getResource(uriInContext = URI.canonicalPath(uriInContext));
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String getRealPath(String path) {
        this.log.debug("getRealPath of {} in {}", (Object)path, (Object)this);
        if (__Slosh2Slash) {
            path = path.replace('\\', '/');
        }
        if ((path = URI.canonicalPath(path)) == null) {
            return null;
        }
        Resource baseResource = this.getHttpContext().getBaseResource();
        if (baseResource == null) {
            return null;
        }
        try {
            Resource resource = baseResource.addPath(path);
            File file = resource.getFile();
            return file == null ? null : file.getAbsolutePath();
        }
        catch (IOException e) {
            this.log.warn("EXCEPTION ", (Throwable)e);
            return null;
        }
    }

    protected void handleTrace(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader("Content-Type", "message/http");
        ServletOutputStream out = response.getOutputStream();
        ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer();
        writer.write(request.toString());
        writer.flush();
        response.setIntHeader("Content-Length", writer.size());
        writer.writeTo((OutputStream)out);
        out.flush();
    }

    protected void handleOptions(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if ("*".equals(request.getRequestURI())) {
            response.setIntHeader("Content-Length", 0);
            response.setHeader("Allow", __AllowString);
            response.flushBuffer();
        } else {
            response.sendError(404);
        }
    }

    public String getErrorPage(int status, ServletHttpRequest request) {
        return null;
    }

    protected Object getContextAttribute(String name) {
        if (__J_S_CONTEXT_TEMPDIR.equals(name)) {
            Object t = this.getHttpContext().getAttribute(__J_S_CONTEXT_TEMPDIR);
            if (t instanceof File) {
                return t;
            }
            return this.getHttpContext().getTempDirectory();
        }
        if (this._attributes.containsKey(name)) {
            return this._attributes.get(name);
        }
        return this.getHttpContext().getAttribute(name);
    }

    protected Enumeration getContextAttributeNames() {
        if (this._attributes.size() == 0) {
            return this.getHttpContext().getAttributeNames();
        }
        HashSet set = new HashSet(this._attributes.keySet());
        Enumeration e = this.getHttpContext().getAttributeNames();
        while (e.hasMoreElements()) {
            set.add(e.nextElement());
        }
        return Collections.enumeration(set);
    }

    protected void setContextAttribute(String name, Object value) {
        this._attributes.put(name, value);
    }

    protected void removeContextAttribute(String name) {
        this._attributes.remove(name);
    }

    public void handleTrace(HttpRequest request, HttpResponse response) throws IOException {
        boolean trace = this.getHttpContext().getHttpServer().getTrace();
        response.setField("Content-Type", "message/http");
        if (trace) {
            OutputStream out = response.getOutputStream();
            ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer();
            writer.write(request.toString());
            writer.flush();
            response.setIntField("Content-Length", writer.size());
            writer.writeTo(out);
            out.flush();
        }
        request.setHandled(true);
    }

    @Override
    public void destroy() {
        Iterator iter = this._nameMap.values().iterator();
        while (iter.hasNext()) {
            Object sh = iter.next();
            iter.remove();
            this.removeComponent(sh);
        }
        if (this._sessionManager != null) {
            this.removeComponent(this._sessionManager);
        }
        this._sessionManager = null;
        this._context = null;
        super.destroy();
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    class Context
    implements ServletContext {
        Context() {
        }

        public String getContextPath() {
            return null;
        }

        ServletHandler getServletHandler() {
            return ServletHandler.this;
        }

        public ServletContext getContext(String uri) {
            ServletHandler handler = (ServletHandler)ServletHandler.this.getHttpContext().getHttpServer().findHandler(ServletHandler.class, uri, ServletHandler.this.getHttpContext().getVirtualHosts());
            if (handler != null) {
                return handler.getServletContext();
            }
            return null;
        }

        public int getMajorVersion() {
            return 2;
        }

        public int getMinorVersion() {
            return 4;
        }

        public String getMimeType(String file) {
            return ServletHandler.this.getHttpContext().getMimeByExtension(file);
        }

        public Set getResourcePaths(String uriInContext) {
            return ServletHandler.this.getResourcePaths(uriInContext);
        }

        public URL getResource(String uriInContext) throws MalformedURLException {
            return ServletHandler.this.getResource(uriInContext);
        }

        public InputStream getResourceAsStream(String uriInContext) {
            return ServletHandler.this.getResourceAsStream(uriInContext);
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            throw new UnsupportedOperationException("This should not have been reached");
        }

        public RequestDispatcher getNamedDispatcher(String name) {
            throw new UnsupportedOperationException("This should not have been reached");
        }

        public String getRealPath(String path) {
            return ServletHandler.this.getRealPath(path);
        }

        public Servlet getServlet(String name) {
            return null;
        }

        public Enumeration getServlets() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public Enumeration getServletNames() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public void log(String msg) {
            ServletHandler.this.log.info(msg);
        }

        public void log(Exception e, String msg) {
            ServletHandler.this.log.warn(msg, (Throwable)e);
        }

        public void log(String msg, Throwable th) {
            ServletHandler.this.log.warn(msg, th);
        }

        public String getServerInfo() {
            return Version.getImplVersion();
        }

        public String getInitParameter(String param) {
            return ServletHandler.this.getHttpContext().getInitParameter(param);
        }

        public Enumeration getInitParameterNames() {
            return ServletHandler.this.getHttpContext().getInitParameterNames();
        }

        public Object getAttribute(String name) {
            return ServletHandler.this.getContextAttribute(name);
        }

        public Enumeration getAttributeNames() {
            return ServletHandler.this.getContextAttributeNames();
        }

        public void setAttribute(String name, Object value) {
            ServletHandler.this.setContextAttribute(name, value);
        }

        public void removeAttribute(String name) {
            ServletHandler.this.removeContextAttribute(name);
        }

        public String getServletContextName() {
            return null;
        }

        public String toString() {
            return "ServletContext[" + ServletHandler.this.getHttpContext() + "]";
        }
    }
}

