/*
 * Decompiled with CFR 0.152.
 */
package com.whl.quickjs.wrapper;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;
import java.util.Set;

abstract class NativeCleaner<T> {
    private Set<NativeReference<T>> phantomReferences = new HashSet<NativeReference<T>>();
    private ReferenceQueue<T> referenceQueue = new ReferenceQueue();

    NativeCleaner() {
    }

    public int size() {
        return this.phantomReferences.size();
    }

    public void register(T referent, long pointer) {
        this.phantomReferences.add(new NativeReference(referent, pointer, this.referenceQueue));
    }

    public abstract void onRemove(long var1);

    public void clean() {
        NativeReference ref;
        while ((ref = (NativeReference)this.referenceQueue.poll()) != null) {
            if (!this.phantomReferences.contains(ref)) continue;
            this.onRemove(ref.pointer);
            this.phantomReferences.remove(ref);
        }
    }

    public void forceClean() {
        for (NativeReference<T> ref : this.phantomReferences) {
            this.onRemove(((NativeReference)ref).pointer);
        }
        this.phantomReferences.clear();
    }

    private static class NativeReference<T>
    extends PhantomReference<T> {
        private long pointer;

        private NativeReference(T referent, long pointer, ReferenceQueue<? super T> q) {
            super(referent, q);
            this.pointer = pointer;
        }
    }
}

