/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.lite.repository.handlefile;

import com.netacom.lite.repository.handlefile.ProgressCallback;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/netacom/lite/repository/handlefile/ProgressInputStream;", "Ljava/io/InputStream;", "stream", "listener", "Lcom/netacom/lite/repository/handlefile/ProgressCallback;", "total", "", "(Ljava/io/InputStream;Lcom/netacom/lite/repository/handlefile/ProgressCallback;J)V", "totalRead", "close", "", "read", "", "b", "", "off", "len", "netacom-sdk-lite_NetAloProdRelease"})
public final class ProgressInputStream
extends InputStream {
    @Nullable
    private final InputStream stream;
    @NotNull
    private final ProgressCallback listener;
    private final long total;
    private long totalRead;

    public ProgressInputStream(@Nullable InputStream stream, @NotNull ProgressCallback listener2, long total) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.stream = stream;
        this.listener = listener2;
        this.total = total;
    }

    @Override
    public int read() throws IOException {
        InputStream inputStream = this.stream;
        Intrinsics.checkNotNull((Object)inputStream);
        int read = inputStream.read();
        if (this.total < 0L) {
            this.listener.onProgressChanged(-1L, -1L, -1.0f);
            return read;
        }
        if (read >= 0) {
            long l = this.totalRead;
            this.totalRead = l + 1L;
            this.listener.onProgressChanged(this.totalRead, this.total, (float)this.totalRead * 1.0f / (float)this.total);
        }
        return read;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        InputStream inputStream = this.stream;
        Intrinsics.checkNotNull((Object)inputStream);
        int read = inputStream.read(b, off, len);
        if (this.total < 0L) {
            this.listener.onProgressChanged(-1L, -1L, -1.0f);
            return read;
        }
        if (read >= 0) {
            this.totalRead += (long)read;
            this.listener.onProgressChanged(this.totalRead, this.total, (float)this.totalRead * 1.0f / (float)this.total);
        }
        return read;
    }

    @Override
    public void close() throws IOException {
        InputStream inputStream = this.stream;
        if (inputStream != null) {
            inputStream.close();
        }
    }
}

