/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.lite.hilt.security;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKey;
import com.netacom.base.chat.json.JsonSerializer;
import com.netacom.lite.local.prefs.PreferencesHelperImpl;
import dagger.Module;
import dagger.Provides;
import dagger.hilt.InstallIn;
import dagger.hilt.android.qualifiers.ApplicationContext;
import dagger.hilt.components.SingletonComponent;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Module
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\r"}, d2={"Lcom/netacom/lite/hilt/security/EncryptedDataStoreModule;", "", "()V", "providePreferencesHelper", "Lcom/netacom/lite/local/prefs/PreferencesHelperImpl;", "context", "Landroid/content/Context;", "jsonSerializer", "Lcom/netacom/base/chat/json/JsonSerializer;", "providesEncryptedSharedPreference", "Landroid/content/SharedPreferences;", "providesMasterKeyAlias", "Landroidx/security/crypto/MasterKey;", "netacom-sdk-lite_NetAloProdRelease"})
@InstallIn(value={SingletonComponent.class})
public final class EncryptedDataStoreModule {
    private final SharedPreferences providesEncryptedSharedPreference(@ApplicationContext Context context) {
        SharedPreferences sharedPreferences = EncryptedSharedPreferences.create((Context)context, (String)"secured_pref_netalo_sdk", (MasterKey)this.providesMasterKeyAlias(context), (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"create(\n            cont\u2026heme.AES256_GCM\n        )");
        return sharedPreferences;
    }

    private final MasterKey providesMasterKeyAlias(@ApplicationContext Context context) {
        MasterKey masterKey = new MasterKey.Builder(context).setKeyScheme(MasterKey.KeyScheme.AES256_GCM).build();
        Intrinsics.checkNotNullExpressionValue((Object)masterKey, (String)"Builder(context)\n       \u2026256_GCM)\n        .build()");
        return masterKey;
    }

    @Provides
    @Singleton
    @NotNull
    public final PreferencesHelperImpl providePreferencesHelper(@ApplicationContext @NotNull Context context, @NotNull JsonSerializer jsonSerializer) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)jsonSerializer, (String)"jsonSerializer");
        return new PreferencesHelperImpl(this.providesEncryptedSharedPreference(context), jsonSerializer);
    }
}

