/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.lite.repository.handlefile;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.netacom.lite.repository.handlefile.ProgressListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\b&\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J(\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0016J(\u0010\u0010\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH&J\b\u0010\u0011\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/netacom/lite/repository/handlefile/ProgressUIListener;", "Lcom/netacom/lite/repository/handlefile/ProgressListener;", "()V", "mHandler", "Landroid/os/Handler;", "ensureHandler", "", "onProgressChanged", "numBytes", "", "totalBytes", "percent", "", "speed", "onProgressFinish", "onProgressStart", "onUIProgressChanged", "onUIProgressFinish", "onUIProgressStart", "Companion", "netacom-sdk-lite_NetAloDevRelease"})
public abstract class ProgressUIListener
extends ProgressListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Handler mHandler;
    private static final int WHAT_START = 1;
    private static final int WHAT_UPDATE = 2;
    private static final int WHAT_FINISH = 3;
    @NotNull
    private static final String CURRENT_BYTES = "numBytes";
    @NotNull
    private static final String TOTAL_BYTES = "totalBytes";
    @NotNull
    private static final String PERCENT = "percent";
    @NotNull
    private static final String SPEED = "speed";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ensureHandler() {
        if (this.mHandler != null) {
            return;
        }
        Class<ProgressUIListener> clazz = ProgressUIListener.class;
        synchronized (clazz) {
            boolean bl = false;
            if (this.mHandler == null) {
                Looper looper = Looper.getMainLooper();
                this.mHandler = new Handler(this, looper){
                    final /* synthetic */ ProgressUIListener this$0;
                    {
                        this.this$0 = $receiver;
                        super($super_call_param$1);
                    }

                    public void handleMessage(@NotNull Message msg) {
                        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                        switch (msg.what) {
                            case 1: {
                                Bundle bundle = msg.getData();
                                if (bundle == null) {
                                    return;
                                }
                                Bundle startData = bundle;
                                this.this$0.onUIProgressStart(startData.getLong("totalBytes"));
                                break;
                            }
                            case 2: {
                                Bundle bundle = msg.getData();
                                if (bundle == null) {
                                    return;
                                }
                                Bundle updateData = bundle;
                                long numBytes = updateData.getLong("numBytes");
                                long totalBytes = updateData.getLong("totalBytes");
                                float percent = updateData.getFloat("percent");
                                float speed = updateData.getFloat("speed");
                                this.this$0.onUIProgressChanged(numBytes, totalBytes, percent, speed);
                                break;
                            }
                            case 3: {
                                this.this$0.onUIProgressFinish();
                            }
                        }
                    }
                };
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void onProgressChanged(long numBytes, long totalBytes, float percent, float speed) {
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            this.onUIProgressChanged(numBytes, totalBytes, percent, speed);
            return;
        }
        this.ensureHandler();
        Handler handler = this.mHandler;
        Intrinsics.checkNotNull((Object)handler);
        Message message = handler.obtainMessage();
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"mHandler!!.obtainMessage()");
        Message message2 = message;
        message2.what = 2;
        Bundle data = new Bundle();
        data.putLong(CURRENT_BYTES, numBytes);
        data.putLong(TOTAL_BYTES, totalBytes);
        data.putFloat(PERCENT, percent);
        data.putFloat(SPEED, speed);
        message2.setData(data);
        Handler handler2 = this.mHandler;
        Intrinsics.checkNotNull((Object)handler2);
        handler2.sendMessage(message2);
    }

    @Override
    public void onProgressStart(long totalBytes) {
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            this.onUIProgressStart(totalBytes);
            return;
        }
        this.ensureHandler();
        Handler handler = this.mHandler;
        Intrinsics.checkNotNull((Object)handler);
        Message message = handler.obtainMessage();
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"mHandler!!.obtainMessage()");
        Message message2 = message;
        message2.what = 1;
        Bundle data = new Bundle();
        data.putLong(TOTAL_BYTES, totalBytes);
        message2.setData(data);
        Handler handler2 = this.mHandler;
        Intrinsics.checkNotNull((Object)handler2);
        handler2.sendMessage(message2);
    }

    @Override
    public void onProgressFinish() {
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            this.onUIProgressFinish();
            return;
        }
        this.ensureHandler();
        Handler handler = this.mHandler;
        Intrinsics.checkNotNull((Object)handler);
        Message message = handler.obtainMessage();
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"mHandler!!.obtainMessage()");
        Message message2 = message;
        message2.what = 3;
        Handler handler2 = this.mHandler;
        Intrinsics.checkNotNull((Object)handler2);
        handler2.sendMessage(message2);
    }

    public abstract void onUIProgressChanged(long var1, long var3, float var5, float var6);

    public void onUIProgressStart(long totalBytes) {
    }

    public void onUIProgressFinish() {
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/netacom/lite/repository/handlefile/ProgressUIListener$Companion;", "", "()V", "CURRENT_BYTES", "", "PERCENT", "SPEED", "TOTAL_BYTES", "WHAT_FINISH", "", "WHAT_START", "WHAT_UPDATE", "netacom-sdk-lite_NetAloDevRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

