/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.lite.repository.secretChat;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.util.Base64;
import android.util.Log;
import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.netacom.base.chat.android_utils.EncodeUtils;
import com.netacom.base.chat.android_utils.StringUtils;
import com.netacom.base.chat.android_utils.Utils;
import com.netacom.base.chat.logger.Logger;
import com.netacom.lite.entity.socket.Secret;
import com.netacom.lite.entity.ui.group.NeGroup;
import com.netacom.lite.entity.ui.secret.NePrivateKey;
import com.netacom.lite.entity.ui.secret.NePublicKey;
import com.netacom.lite.local.prefs.PreferencesHelperImpl;
import com.netacom.lite.repository.secretChat.PartnerSecretConfig;
import com.netacom.lite.repository.secretChat.impl.RealmStatic;
import com.netacom.lite.repository.secretChat.impl.SignalProtocolStoreImpl;
import java.nio.charset.Charset;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.whispersystems.libsignal.IdentityKeyPair;
import org.whispersystems.libsignal.SessionCipher;
import org.whispersystems.libsignal.SignalProtocolAddress;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECKeyPair;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.protocol.CiphertextMessage;
import org.whispersystems.libsignal.protocol.SignalMessage;
import org.whispersystems.libsignal.ratchet.AliceSignalProtocolParameters;
import org.whispersystems.libsignal.ratchet.BobSignalProtocolParameters;
import org.whispersystems.libsignal.ratchet.RatchetingSession;
import org.whispersystems.libsignal.state.SessionRecord;
import org.whispersystems.libsignal.state.SessionState;
import org.whispersystems.libsignal.state.SignalProtocolStore;
import org.whispersystems.libsignal.util.KeyHelper;
import org.whispersystems.libsignal.util.guava.Optional;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\"\u0010 \u001a\u0004\u0018\u00010\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\nH\u0002J\u001e\u0010&\u001a\u0004\u0018\u00010'2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010(\u001a\u0004\u0018\u00010'H\u0002J\u001e\u0010&\u001a\u0004\u0018\u00010\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010)\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010'2\b\u0010+\u001a\u0004\u0018\u00010'J\u0012\u0010,\u001a\u0004\u0018\u00010\u00042\b\u0010)\u001a\u0004\u0018\u00010\u0004J\u0014\u0010-\u001a\u0004\u0018\u00010\u00042\b\u0010.\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010'J\u0006\u00100\u001a\u00020\u0004J\u0010\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u000203H\u0007J\u0006\u00104\u001a\u00020\"J&\u00105\u001a\u0004\u0018\u00010\u00042\b\u0010.\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u00106\u001a\u00020\n2\b\b\u0002\u00107\u001a\u00020\nJ\u0016\u00108\u001a\u00020\u001c2\u0006\u00109\u001a\u00020:2\u0006\u0010%\u001a\u00020\nJ\"\u00108\u001a\u00020\u001c2\b\u0010;\u001a\u0004\u0018\u00010\u00042\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010%\u001a\u00020\nJ\u000e\u0010<\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010=\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020\u0004J\u0010\u0010>\u001a\u00020\u001c2\u0006\u0010?\u001a\u00020@H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR6\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110\u0010j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0011`\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/netacom/lite/repository/secretChat/ChatSecretUtils;", "", "()V", "activeSecretGroupId", "", "ecKeyPair", "Lorg/whispersystems/libsignal/ecc/ECKeyPair;", "identityKeyPair", "Lorg/whispersystems/libsignal/IdentityKeyPair;", "isShowLog", "", "onetimeKeyPair", "registrationId", "", "Ljava/lang/Integer;", "secretAcceptHashMap", "Ljava/util/HashMap;", "Lcom/netacom/lite/entity/socket/Secret;", "Lkotlin/collections/HashMap;", "getSecretAcceptHashMap", "()Ljava/util/HashMap;", "setSecretAcceptHashMap", "(Ljava/util/HashMap;)V", "sessionCipher", "Lorg/whispersystems/libsignal/SessionCipher;", "store", "Lcom/netacom/lite/repository/secretChat/impl/SignalProtocolStoreImpl;", "clearActiveSecretGroupId", "", "createKeyAndSave", "preferencesHelperImpl", "Lcom/netacom/lite/local/prefs/PreferencesHelperImpl;", "createSessionCipher", "nePublicKey", "Lcom/netacom/lite/entity/ui/secret/NePublicKey;", "partnerAddress", "Lorg/whispersystems/libsignal/SignalProtocolAddress;", "isAlice", "decrypt", "", "byteArray", "cipherText", "decryptFileInput", "cipherByteArray", "decryptTextInput", "encrypt", "plainText", "encryptFile", "getActiveSecretGroupId", "getDeviceId", "context", "Landroid/content/Context;", "getPublicKey", "handleTextInput", "isTextType", "isEncrypt", "init", "neGroup", "Lcom/netacom/lite/entity/ui/group/NeGroup;", "groupId", "loadKeyAndInit", "setActiveSecretGroupId", "showInfoKey", "nePrivateKey", "Lcom/netacom/lite/entity/ui/secret/NePrivateKey;", "netacom-sdk-lite_NetAloDevRelease"})
public final class ChatSecretUtils {
    @NotNull
    public static final ChatSecretUtils INSTANCE = new ChatSecretUtils();
    @Nullable
    private static ECKeyPair ecKeyPair;
    @Nullable
    private static IdentityKeyPair identityKeyPair;
    @Nullable
    private static ECKeyPair onetimeKeyPair;
    @Nullable
    private static Integer registrationId;
    @Nullable
    private static SignalProtocolStoreImpl store;
    @Nullable
    private static volatile SessionCipher sessionCipher;
    @NotNull
    private static volatile String activeSecretGroupId;
    private static final boolean isShowLog = true;
    @NotNull
    private static volatile HashMap<String, Secret> secretAcceptHashMap;

    private ChatSecretUtils() {
    }

    @NotNull
    public final HashMap<String, Secret> getSecretAcceptHashMap() {
        return secretAcceptHashMap;
    }

    public final void setSecretAcceptHashMap(@NotNull HashMap<String, Secret> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        secretAcceptHashMap = hashMap;
    }

    private final void createKeyAndSave(PreferencesHelperImpl preferencesHelperImpl) {
        ECPublicKey eCPublicKey;
        ecKeyPair = Curve.generateKeyPair();
        identityKeyPair = KeyHelper.generateIdentityKeyPair();
        onetimeKeyPair = Curve.generateKeyPair();
        registrationId = KeyHelper.generateRegistrationId((boolean)false);
        Object object = identityKeyPair;
        if (object == null) {
            return;
        }
        IdentityKeyPair identityKeyPair = object;
        object = registrationId;
        if (object == null) {
            return;
        }
        store = new SignalProtocolStoreImpl(identityKeyPair, (Integer)object);
        object = new NePrivateKey(null, null, null, null, null, 0, 63, null);
        boolean bl = false;
        boolean bl2 = false;
        Object $this$createKeyAndSave_u24lambda_u2d0 = object;
        boolean bl3 = false;
        ECKeyPair eCKeyPair = ecKeyPair;
        Object object2 = Base64.encodeToString(eCKeyPair == null ? null : ((eCPublicKey = eCKeyPair.getPublicKey()) == null ? null : eCPublicKey.serialize()), (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"encodeToString(ecKeyPair?.publicKey?.serialize(), Base64.DEFAULT)");
        ((NePrivateKey)$this$createKeyAndSave_u24lambda_u2d0).setPPublic((String)object2);
        eCKeyPair = ecKeyPair;
        object2 = Base64.encodeToString(eCKeyPair == null ? null : ((eCPublicKey = eCKeyPair.getPrivateKey()) == null ? null : eCPublicKey.serialize()), (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"encodeToString(ecKeyPair?.privateKey?.serialize(), Base64.DEFAULT)");
        ((NePrivateKey)$this$createKeyAndSave_u24lambda_u2d0).setPPrivate((String)object2);
        eCKeyPair = ChatSecretUtils.identityKeyPair;
        object2 = Base64.encodeToString((byte[])(eCKeyPair == null ? null : eCKeyPair.serialize()), (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"encodeToString(identityKeyPair?.serialize(), Base64.DEFAULT)");
        ((NePrivateKey)$this$createKeyAndSave_u24lambda_u2d0).setPIdentity((String)object2);
        eCKeyPair = onetimeKeyPair;
        object2 = Base64.encodeToString(eCKeyPair == null ? null : ((eCPublicKey = eCKeyPair.getPublicKey()) == null ? null : eCPublicKey.serialize()), (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"encodeToString(onetimeKeyPair?.publicKey?.serialize(), Base64.DEFAULT)");
        ((NePrivateKey)$this$createKeyAndSave_u24lambda_u2d0).setPOneTimePublic((String)object2);
        eCKeyPair = onetimeKeyPair;
        object2 = Base64.encodeToString(eCKeyPair == null ? null : ((eCPublicKey = eCKeyPair.getPrivateKey()) == null ? null : eCPublicKey.serialize()), (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"encodeToString(onetimeKeyPair?.privateKey?.serialize(), Base64.DEFAULT)");
        ((NePrivateKey)$this$createKeyAndSave_u24lambda_u2d0).setPOneTimePrivate((String)object2);
        object2 = registrationId;
        ((NePrivateKey)$this$createKeyAndSave_u24lambda_u2d0).setPRegisterId(object2 == null ? 0 : (Integer)object2);
        preferencesHelperImpl.setSecretKey((NePrivateKey)$this$createKeyAndSave_u24lambda_u2d0);
        INSTANCE.showInfoKey((NePrivateKey)$this$createKeyAndSave_u24lambda_u2d0);
    }

    public final void loadKeyAndInit(@NotNull PreferencesHelperImpl preferencesHelperImpl) {
        Intrinsics.checkNotNullParameter((Object)preferencesHelperImpl, (String)"preferencesHelperImpl");
        if (store == null) {
            try {
                NePrivateKey nePrivateKey;
                if (preferencesHelperImpl.getSecretKey() == null) {
                    this.createKeyAndSave(preferencesHelperImpl);
                }
                if ((nePrivateKey = preferencesHelperImpl.getSecretKey()) != null) {
                    NePrivateKey nePrivateKey2 = nePrivateKey;
                    boolean bl = false;
                    boolean bl2 = false;
                    NePrivateKey $this$loadKeyAndInit_u24lambda_u2d1 = nePrivateKey2;
                    boolean bl3 = false;
                    byte[] byArray = Base64.decode((String)$this$loadKeyAndInit_u24lambda_u2d1.getPPublic(), (int)0);
                    if (byArray != null) {
                        byte[] ekpPublic = byArray;
                        byte[] byArray2 = Base64.decode((String)$this$loadKeyAndInit_u24lambda_u2d1.getPPrivate(), (int)0);
                        if (byArray2 != null) {
                            byte[] ekpPrivate = byArray2;
                            byte[] byArray3 = Base64.decode((String)$this$loadKeyAndInit_u24lambda_u2d1.getPIdentity(), (int)0);
                            if (byArray3 != null) {
                                byte[] ikp = byArray3;
                                byte[] byArray4 = Base64.decode((String)$this$loadKeyAndInit_u24lambda_u2d1.getPOneTimePublic(), (int)0);
                                if (byArray4 != null) {
                                    byte[] opkPublic = byArray4;
                                    Object object = Base64.decode((String)$this$loadKeyAndInit_u24lambda_u2d1.getPOneTimePrivate(), (int)0);
                                    if (object != null) {
                                        byte[] opkPrivate = object;
                                        registrationId = $this$loadKeyAndInit_u24lambda_u2d1.getPRegisterId();
                                        ecKeyPair = new ECKeyPair(Curve.decodePoint((byte[])ekpPublic, (int)0), Curve.decodePrivatePoint((byte[])ekpPrivate));
                                        identityKeyPair = new IdentityKeyPair(ikp);
                                        onetimeKeyPair = new ECKeyPair(Curve.decodePoint((byte[])opkPublic, (int)0), Curve.decodePrivatePoint((byte[])opkPrivate));
                                        object = identityKeyPair;
                                        if (object != null) {
                                            Object object2 = object;
                                            object = registrationId;
                                            if (object != null) {
                                                int n = object.intValue();
                                                Object object3 = object2;
                                                store = new SignalProtocolStoreImpl((IdentityKeyPair)object3, n);
                                                INSTANCE.showInfoKey($this$loadKeyAndInit_u24lambda_u2d1);
                                                Logger.INSTANCE.d("Secret Load key success", new Object[0]);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                FirebaseCrashlytics.getInstance().recordException((Throwable)e);
                e.printStackTrace();
            }
        }
    }

    private final void showInfoKey(NePrivateKey nePrivateKey) {
        Logger.INSTANCE.d(Intrinsics.stringPlus((String)"nePrivateKey==", (Object)nePrivateKey), new Object[0]);
    }

    @NotNull
    public final NePublicKey getPublicKey() {
        boolean bl;
        String string2;
        boolean bl2;
        boolean bl3;
        ECPublicKey eCPublicKey;
        ECPublicKey eCPublicKey2;
        NePublicKey nePublicKey = new NePublicKey(null, null, null, null, null, 31, null);
        boolean bl4 = false;
        boolean bl5 = false;
        NePublicKey $this$getPublicKey_u24lambda_u2d5 = nePublicKey;
        boolean bl6 = false;
        ECKeyPair eCKeyPair = ecKeyPair;
        if (eCKeyPair != null && (eCPublicKey2 = eCKeyPair.getPublicKey()) != null) {
            eCPublicKey = eCPublicKey2;
            bl3 = false;
            bl2 = false;
            ECPublicKey $this$getPublicKey_u24lambda_u2d5_u24lambda_u2d2 = eCPublicKey;
            boolean bl7 = false;
            string2 = Base64.encodeToString((byte[])$this$getPublicKey_u24lambda_u2d5_u24lambda_u2d2.serialize(), (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(serialize(), Base64.DEFAULT)");
            bl = false;
            $this$getPublicKey_u24lambda_u2d5.setPBaseKey(((Object)StringsKt.trim((CharSequence)string2)).toString());
        }
        if ((eCKeyPair = identityKeyPair) != null && (eCPublicKey2 = eCKeyPair.getPublicKey()) != null) {
            eCPublicKey = eCPublicKey2;
            bl3 = false;
            bl2 = false;
            ECPublicKey $this$getPublicKey_u24lambda_u2d5_u24lambda_u2d3 = eCPublicKey;
            boolean bl8 = false;
            string2 = Base64.encodeToString((byte[])$this$getPublicKey_u24lambda_u2d5_u24lambda_u2d3.serialize(), (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(serialize(), Base64.DEFAULT)");
            bl = false;
            $this$getPublicKey_u24lambda_u2d5.setPIdentityKey(((Object)StringsKt.trim((CharSequence)string2)).toString());
        }
        if ((eCKeyPair = onetimeKeyPair) != null && (eCPublicKey2 = eCKeyPair.getPublicKey()) != null) {
            eCPublicKey = eCPublicKey2;
            bl3 = false;
            bl2 = false;
            ECPublicKey $this$getPublicKey_u24lambda_u2d5_u24lambda_u2d4 = eCPublicKey;
            boolean bl9 = false;
            string2 = Base64.encodeToString((byte[])$this$getPublicKey_u24lambda_u2d5_u24lambda_u2d4.serialize(), (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(serialize(), Base64.DEFAULT)");
            bl = false;
            $this$getPublicKey_u24lambda_u2d5.setPOneTimePreKey(((Object)StringsKt.trim((CharSequence)string2)).toString());
        }
        eCKeyPair = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)eCKeyPair, (String)"getApp()");
        $this$getPublicKey_u24lambda_u2d5.setPDeviceId(INSTANCE.getDeviceId((Context)eCKeyPair));
        Logger.INSTANCE.d(Intrinsics.stringPlus((String)"getPublicKey=", (Object)$this$getPublicKey_u24lambda_u2d5), new Object[0]);
        return nePublicKey;
    }

    @SuppressLint(value={"HardwareIds"})
    @NotNull
    public final String getDeviceId(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string2 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(context.contentResolver, Settings.Secure.ANDROID_ID)");
        return string2;
    }

    public final void init(@NotNull NeGroup neGroup, boolean isAlice) {
        Intrinsics.checkNotNullParameter((Object)neGroup, (String)"neGroup");
        RealmStatic.INSTANCE.clear();
        Object object = neGroup.getId();
        activeSecretGroupId = object == null ? "" : object;
        object = neGroup.getPartnerPublicKey();
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            sessionCipher = INSTANCE.createSessionCipher((NePublicKey)it, new SignalProtocolAddress(Intrinsics.stringPlus((String)neGroup.getId(), (Object)((NePublicKey)it).getPUin()), 1), isAlice);
            Logger.INSTANCE.d("Secret init success: sessionCipher = " + sessionCipher + ", partnerAddress = " + neGroup.getId() + ((NePublicKey)it).getPUin(), new Object[0]);
        }
    }

    public final void init(@Nullable String groupId, @Nullable NePublicKey nePublicKey, boolean isAlice) {
        SessionCipher sessionCipher;
        Object it;
        boolean bl;
        boolean bl2;
        Object object;
        RealmStatic.INSTANCE.clear();
        NePublicKey publicKey = null;
        publicKey = nePublicKey;
        if (publicKey == null) {
            object = secretAcceptHashMap;
            boolean bl3 = false;
            Object object2 = object;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
            }
            if (object2.containsKey(groupId)) {
                Object object3 = secretAcceptHashMap;
                bl2 = false;
                object = (Secret)object3.get(groupId);
                if (object != null) {
                    object3 = object;
                    bl2 = false;
                    bl = false;
                    it = object3;
                    boolean bl4 = false;
                    NePublicKey nePublicKey2 = new NePublicKey(null, null, null, null, null, 31, null);
                    boolean bl5 = false;
                    boolean bl6 = false;
                    NePublicKey $this$init_u24lambda_u2d8_u24lambda_u2d7 = nePublicKey2;
                    boolean bl7 = false;
                    $this$init_u24lambda_u2d8_u24lambda_u2d7.setPUin(((Secret)it).getUin());
                    $this$init_u24lambda_u2d8_u24lambda_u2d7.setPBaseKey(((Secret)it).getBase_key());
                    $this$init_u24lambda_u2d8_u24lambda_u2d7.setPIdentityKey(((Secret)it).getIdentity_key());
                    $this$init_u24lambda_u2d8_u24lambda_u2d7.setPDeviceId(((Secret)it).getDevice_id());
                    $this$init_u24lambda_u2d8_u24lambda_u2d7.setPOneTimePreKey(((Secret)it).getOne_time_pre_key());
                    Unit unit = Unit.INSTANCE;
                    publicKey = nePublicKey2;
                }
            }
        }
        if ((object = publicKey) == null) {
            sessionCipher = null;
        } else {
            Object object4 = object;
            bl2 = false;
            bl = false;
            it = object4;
            boolean bl8 = false;
            Logger.INSTANCE.d("fast secret init success: sessionCipher = " + ChatSecretUtils.sessionCipher + ", partnerAddress = " + groupId + ((NePublicKey)it).getPUin(), new Object[0]);
            sessionCipher = INSTANCE.createSessionCipher((NePublicKey)it, new SignalProtocolAddress(Intrinsics.stringPlus((String)groupId, (Object)((NePublicKey)it).getPUin()), 1), isAlice);
        }
        ChatSecretUtils.sessionCipher = sessionCipher;
    }

    @NotNull
    public final String getActiveSecretGroupId() {
        return activeSecretGroupId;
    }

    public final void setActiveSecretGroupId(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        activeSecretGroupId = groupId;
    }

    public final void clearActiveSecretGroupId() {
        activeSecretGroupId = "";
    }

    private final SessionCipher createSessionCipher(NePublicKey nePublicKey, SignalProtocolAddress partnerAddress, boolean isAlice) {
        SessionCipher sessionCipher;
        String string2 = nePublicKey.getPBaseKey();
        if (string2 == null) {
            return null;
        }
        String pEcKeyPairString = string2;
        String string3 = nePublicKey.getPIdentityKey();
        if (string3 == null) {
            return null;
        }
        String pIdentityKeyString = string3;
        Object object = nePublicKey.getPOneTimePreKey();
        if (object == null) {
            return null;
        }
        Object pOneTimeKeyString = object;
        if ((object = PartnerSecretConfig.Companion.init(pEcKeyPairString, pIdentityKeyString, (String)pOneTimeKeyString)) == null) {
            sessionCipher = null;
        } else {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object $this$createSessionCipher_u24lambda_u2d10 = object2;
            boolean bl3 = false;
            SignalProtocolStoreImpl signalProtocolStoreImpl = store;
            if (Intrinsics.areEqual((Object)(signalProtocolStoreImpl == null ? null : Boolean.valueOf(signalProtocolStoreImpl.containsSession(partnerAddress))), (Object)false)) {
                AliceSignalProtocolParameters.Builder builder;
                SessionRecord sessionRecord = new SessionRecord();
                if (isAlice) {
                    builder = AliceSignalProtocolParameters.newBuilder();
                    builder.setOurIdentityKey(identityKeyPair);
                    builder.setOurBaseKey(ecKeyPair);
                    builder.setTheirRatchetKey(((PartnerSecretConfig)$this$createSessionCipher_u24lambda_u2d10).getPEcKeyPair());
                    builder.setTheirIdentityKey(((PartnerSecretConfig)$this$createSessionCipher_u24lambda_u2d10).getPIdentityKey());
                    builder.setTheirSignedPreKey(((PartnerSecretConfig)$this$createSessionCipher_u24lambda_u2d10).getPEcKeyPair());
                    builder.setTheirOneTimePreKey(Optional.of((Object)((PartnerSecretConfig)$this$createSessionCipher_u24lambda_u2d10).getPOneTimeKey()));
                    RatchetingSession.initializeSession((SessionState)sessionRecord.getSessionState(), (AliceSignalProtocolParameters)builder.create());
                } else {
                    builder = BobSignalProtocolParameters.newBuilder();
                    builder.setOurIdentityKey(identityKeyPair);
                    builder.setOurSignedPreKey(ecKeyPair);
                    builder.setOurOneTimePreKey(Optional.of((Object)onetimeKeyPair));
                    builder.setOurRatchetKey(ecKeyPair);
                    builder.setTheirIdentityKey(((PartnerSecretConfig)$this$createSessionCipher_u24lambda_u2d10).getPIdentityKey());
                    builder.setTheirBaseKey(((PartnerSecretConfig)$this$createSessionCipher_u24lambda_u2d10).getPEcKeyPair());
                    RatchetingSession.initializeSession((SessionState)sessionRecord.getSessionState(), (BobSignalProtocolParameters)builder.create());
                }
                SignalProtocolStoreImpl signalProtocolStoreImpl2 = store;
                if (signalProtocolStoreImpl2 != null) {
                    signalProtocolStoreImpl2.saveIdentity(partnerAddress, ((PartnerSecretConfig)$this$createSessionCipher_u24lambda_u2d10).getPIdentityKey());
                }
                signalProtocolStoreImpl2 = store;
                if (signalProtocolStoreImpl2 != null) {
                    signalProtocolStoreImpl2.storeSession(partnerAddress, sessionRecord);
                }
            }
            Log.e((String)"Secret", (String)"init success");
            sessionCipher = new SessionCipher((SignalProtocolStore)store, partnerAddress);
        }
        return sessionCipher;
    }

    private final synchronized String encrypt(String plainText) {
        String string2;
        try {
            String string3;
            Logger.INSTANCE.d(Intrinsics.stringPlus((String)"encrypt==", (Object)plainText), new Object[0]);
            if (sessionCipher == null) {
                Logger.INSTANCE.e("sessionCipher==null", new Object[0]);
                return plainText;
            }
            Object object = sessionCipher;
            CiphertextMessage message = object == null ? null : object.encrypt((string3 = plainText) == null ? null : StringsKt.encodeToByteArray((String)string3));
            object = message;
            object = EncodeUtils.base64Encode2String((byte[])(object == null ? null : object.serialize()));
            boolean bl = false;
            boolean bl2 = false;
            Object $this$encrypt_u24lambda_u2d11 = object;
            boolean bl3 = false;
            Logger.INSTANCE.d("Secret encrypt: " + plainText + " -> " + $this$encrypt_u24lambda_u2d11, new Object[0]);
            string2 = object;
        }
        catch (Exception ex) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)ex);
            ex.printStackTrace();
            string2 = null;
        }
        return string2;
    }

    private final synchronized String decrypt(SessionCipher sessionCipher, String cipherText) {
        String string2;
        Logger.INSTANCE.d("Secret decrypt: " + cipherText + "; sessionCipher= " + sessionCipher, new Object[0]);
        try {
            Object object = sessionCipher;
            String string3 = string2 = object == null ? null : (String)object.decrypt(new SignalMessage(EncodeUtils.base64Decode((String)cipherText)));
            if (string2 == null) {
                return "";
            }
            object = Charsets.UTF_8;
            boolean bl = false;
            string2 = new String((byte[])string2, (Charset)object);
            boolean bl2 = false;
            bl = false;
            String $this$decrypt_u24lambda_u2d12 = string2;
            boolean bl3 = false;
            Logger.INSTANCE.d("Secret decrypt: " + $this$decrypt_u24lambda_u2d12 + " -> " + cipherText, new Object[0]);
        }
        catch (Exception ex) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)ex);
            ex.printStackTrace();
            string2 = "";
        }
        return string2;
    }

    @Nullable
    public final synchronized byte[] encryptFile(@Nullable byte[] byteArray) {
        Object object;
        try {
            CiphertextMessage ciphertextMessage;
            Logger.INSTANCE.d(Intrinsics.stringPlus((String)"encrypt==", (Object)byteArray), new Object[0]);
            if (sessionCipher == null) {
                return byteArray;
            }
            if (byteArray == null) {
                return null;
            }
            object = sessionCipher;
            object = object == null ? null : ((ciphertextMessage = object.encrypt(byteArray)) == null ? null : ciphertextMessage.serialize());
        }
        catch (Exception ex) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)ex);
            ex.printStackTrace();
            object = null;
        }
        return object;
    }

    private final synchronized byte[] decrypt(SessionCipher sessionCipher, byte[] byteArray) {
        Object object;
        Logger.INSTANCE.d("Secret decrypt: " + byteArray + " with remoteRegistrationId =" + ((object = sessionCipher) == null ? null : Integer.valueOf(object.getRemoteRegistrationId())), new Object[0]);
        try {
            object = sessionCipher;
            object = object == null ? null : object.decrypt(new SignalMessage(byteArray));
        }
        catch (Exception ex) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)ex);
            ex.printStackTrace();
            object = null;
        }
        return object;
    }

    @Nullable
    public final String handleTextInput(@Nullable String plainText, boolean isTextType, boolean isEncrypt) {
        String string2 = plainText;
        if (string2 == null) {
            return null;
        }
        try {
            String text = StringUtils.INSTANCE.handleSpecialChar(plainText, isTextType);
            string2 = isEncrypt ? this.encrypt(text) : text;
        }
        catch (Exception ex) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)ex);
            ex.printStackTrace();
            string2 = null;
        }
        return string2;
    }

    public static /* synthetic */ String handleTextInput$default(ChatSecretUtils chatSecretUtils, String string2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return chatSecretUtils.handleTextInput(string2, bl, bl2);
    }

    @Nullable
    public final String decryptTextInput(@Nullable String cipherText) {
        return this.decrypt(sessionCipher, cipherText);
    }

    @Nullable
    public final byte[] decryptFileInput(@Nullable byte[] cipherByteArray) {
        return this.decrypt(sessionCipher, cipherByteArray);
    }

    static {
        activeSecretGroupId = "";
        secretAcceptHashMap = new HashMap();
    }
}

