/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.full.worker.call;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.Settings;
import android.util.Log;
import androidx.core.content.ContextCompat;
import androidx.hilt.work.HiltWorker;
import androidx.work.CoroutineWorker;
import androidx.work.ListenableWorker;
import androidx.work.WorkerParameters;
import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.netacom.base.chat.json.JsonSerializer;
import com.netacom.base.chat.logger.Logger;
import com.netacom.full.R;
import com.netacom.full.ui.main.calling.CallNotificationService;
import com.netacom.full.ui.main.theme.ThemeHelperImpl;
import com.netacom.full.ui.sdk.NetAloSDK;
import com.netacom.lite.entity.database.group.DbGroupEntity;
import com.netacom.lite.entity.socket.Call;
import com.netacom.lite.entity.ui.user.NeUser;
import com.netacom.lite.local.prefs.PreferencesHelperImpl;
import com.netacom.lite.repository.GroupRepository;
import com.netacom.lite.repository.SocketRepository;
import com.netacom.lite.socket.request.CheckCallRequest;
import com.netacom.lite.socket.request.GroupCallStatusRequest;
import com.netacom.lite.util.AppUtils;
import com.netacom.lite.util.CallbackResult;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedInject;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.ObsoleteCoroutinesApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001BC\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0003J\u0011\u0010\u001b\u001a\u00020\u001cH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"Lcom/netacom/full/worker/call/CallWorker;", "Landroidx/work/CoroutineWorker;", "context", "Landroid/content/Context;", "workerParameters", "Landroidx/work/WorkerParameters;", "socketRepository", "Lcom/netacom/lite/repository/SocketRepository;", "groupRepository", "Lcom/netacom/lite/repository/GroupRepository;", "jsonSerializer", "Lcom/netacom/base/chat/json/JsonSerializer;", "preferencesHelperImpl", "Lcom/netacom/lite/local/prefs/PreferencesHelperImpl;", "themeHelperImpl", "Lcom/netacom/full/ui/main/theme/ThemeHelperImpl;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;Lcom/netacom/lite/repository/SocketRepository;Lcom/netacom/lite/repository/GroupRepository;Lcom/netacom/base/chat/json/JsonSerializer;Lcom/netacom/lite/local/prefs/PreferencesHelperImpl;Lcom/netacom/full/ui/main/theme/ThemeHelperImpl;)V", "getSocketRepository", "()Lcom/netacom/lite/repository/SocketRepository;", "checkCallNotExist", "", "newCall", "Lcom/netacom/lite/entity/socket/Call;", "previousCall", "checkConditionShowNotification", "", "call", "doWork", "Landroidx/work/ListenableWorker$Result;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processShowNotification", "netacom-sdk-full_NetAloProdRelease"})
@HiltWorker
public final class CallWorker
extends CoroutineWorker {
    @NotNull
    private final SocketRepository socketRepository;
    @NotNull
    private final GroupRepository groupRepository;
    @NotNull
    private final JsonSerializer jsonSerializer;
    @NotNull
    private final PreferencesHelperImpl preferencesHelperImpl;
    @NotNull
    private final ThemeHelperImpl themeHelperImpl;

    @AssistedInject
    public CallWorker(@Assisted @NotNull Context context, @Assisted @NotNull WorkerParameters workerParameters, @NotNull SocketRepository socketRepository, @NotNull GroupRepository groupRepository, @NotNull JsonSerializer jsonSerializer, @NotNull PreferencesHelperImpl preferencesHelperImpl, @NotNull ThemeHelperImpl themeHelperImpl) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)workerParameters, (String)"workerParameters");
        Intrinsics.checkNotNullParameter((Object)socketRepository, (String)"socketRepository");
        Intrinsics.checkNotNullParameter((Object)groupRepository, (String)"groupRepository");
        Intrinsics.checkNotNullParameter((Object)jsonSerializer, (String)"jsonSerializer");
        Intrinsics.checkNotNullParameter((Object)preferencesHelperImpl, (String)"preferencesHelperImpl");
        Intrinsics.checkNotNullParameter((Object)themeHelperImpl, (String)"themeHelperImpl");
        super(context, workerParameters);
        this.socketRepository = socketRepository;
        this.groupRepository = groupRepository;
        this.jsonSerializer = jsonSerializer;
        this.preferencesHelperImpl = preferencesHelperImpl;
        this.themeHelperImpl = themeHelperImpl;
    }

    @NotNull
    public final SocketRepository getSocketRepository() {
        return this.socketRepository;
    }

    @Nullable
    public Object doWork(@NotNull Continuation<? super ListenableWorker.Result> $completion) {
        ListenableWorker.Result result2;
        try {
            block9: {
                Call $this$doWork_u24lambda_u2d0;
                block10: {
                    long l;
                    Call call;
                    Call call2 = (Call)this.jsonSerializer.asObject(this.getInputData().getString("KEY_DATA"), Call.class);
                    if (call2 == null) break block9;
                    $this$doWork_u24lambda_u2d0 = call = call2;
                    boolean bl = false;
                    Logger.INSTANCE.e(Intrinsics.stringPlus((String)"CallWorker=", (Object)$this$doWork_u24lambda_u2d0), new Object[0]);
                    Logger.INSTANCE.e(Intrinsics.stringPlus((String)"CallWorker=", (Object)Boxing.boxBoolean((boolean)this.getSocketRepository().isConnect())), new Object[0]);
                    boolean isCallNotExist = this.checkCallNotExist($this$doWork_u24lambda_u2d0, this.preferencesHelperImpl.getLatestCallWorker());
                    if (!isCallNotExist) break block9;
                    CharSequence charSequence = $this$doWork_u24lambda_u2d0.getGroupCallId();
                    if (!(charSequence == null || charSequence.length() == 0)) break block10;
                    long l2 = Calendar.getInstance().getTimeInMillis() / (long)1000;
                    String string2 = $this$doWork_u24lambda_u2d0.getMStartedAt();
                    if (string2 == null) {
                        l = 0L;
                    } else {
                        Long l3 = StringsKt.toLongOrNull((String)string2);
                        l = l3 == null ? 0L : l3;
                    }
                    if (l2 - l > 30L) break block9;
                }
                if (!this.getSocketRepository().isConnect()) {
                    this.getSocketRepository().connectSocket((Function1)new Function1<Boolean, Unit>(this, $this$doWork_u24lambda_u2d0){
                        final /* synthetic */ CallWorker this$0;
                        final /* synthetic */ Call $this_apply;
                        {
                            this.this$0 = $receiver;
                            this.$this_apply = $receiver2;
                            super(1);
                        }

                        public final void invoke(boolean isConnected) {
                            if (isConnected) {
                                CallWorker.access$checkConditionShowNotification(this.this$0, this.$this_apply);
                            }
                        }
                    });
                } else {
                    this.checkConditionShowNotification($this$doWork_u24lambda_u2d0);
                }
            }
            result2 = ListenableWorker.Result.success();
            Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"{\n            jsonSerial\u2026esult.success()\n        }");
        }
        catch (Exception e) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
            Log.d((String)"qqq", (String)Intrinsics.stringPlus((String)"!! exception.message:", (Object)e.getMessage()));
            ListenableWorker.Result result3 = ListenableWorker.Result.failure();
            Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"{\n            FirebaseCr\u2026esult.failure()\n        }");
            result2 = result3;
        }
        return result2;
    }

    @ObsoleteCoroutinesApi
    private final void checkConditionShowNotification(Call call) {
        this.preferencesHelperImpl.setLatestCallWorker(call);
        CharSequence charSequence = call.getGroupCallId();
        if (!(charSequence == null || charSequence.length() == 0)) {
            GroupCallStatusRequest groupCallStatus = new GroupCallStatusRequest(call.getGroupId(), call.getMessageId());
            this.socketRepository.getGetIOSocket().checkGroupCallStatus(groupCallStatus, (CallbackResult)new CallbackResult<Boolean>(this, call){
                final /* synthetic */ CallWorker this$0;
                final /* synthetic */ Call $call;
                {
                    this.this$0 = $receiver;
                    this.$call = $call;
                }

                public void callBackSuccess(boolean result2) {
                    CallWorker.access$processShowNotification(this.this$0, this.$call);
                }

                public void callBackError(@Nullable String error) {
                }
            });
        } else {
            Long l = StringsKt.toLongOrNull((String)call.getCallId());
            if ((l == null ? 0L : l) > 0L) {
                CheckCallRequest checkCallRequest = new CheckCallRequest(StringsKt.toLongOrNull((String)call.getGroupId()), StringsKt.toLongOrNull((String)call.getCallId()));
                this.socketRepository.getGetIOSocket().checkCall(checkCallRequest, (CallbackResult)new CallbackResult<Integer>(this, call){
                    final /* synthetic */ CallWorker this$0;
                    final /* synthetic */ Call $call;
                    {
                        this.this$0 = $receiver;
                        this.$call = $call;
                    }

                    public void callBackSuccess(int result2) {
                        if (result2 == 1) {
                            CallWorker.access$processShowNotification(this.this$0, this.$call);
                        }
                    }

                    public void callBackError(@Nullable String error) {
                    }
                });
            }
        }
    }

    private final void processShowNotification(Call call) {
        CharSequence charSequence;
        if (Settings.canDrawOverlays((Context)this.getApplicationContext()) && ((charSequence = (CharSequence)call.getInvitedUin()) == null || charSequence.length() == 0)) {
            charSequence = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"applicationContext");
            NetAloSDK.openNetAloSDK$default(NetAloSDK.INSTANCE, (Context)charSequence, null, null, null, call, true, 14, null);
        } else {
            CharSequence charSequence2;
            charSequence = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"applicationContext");
            if (!AppUtils.INSTANCE.isAppBackground((Context)charSequence) && ((charSequence = (CharSequence)call.getInvitedUin()) == null || charSequence.length() == 0)) {
                return;
            }
            Intent serviceIntent = new Intent(this.getApplicationContext(), CallNotificationService.class);
            CharSequence charSequence3 = call.getGroupCallId();
            if (!(charSequence3 == null || charSequence3.length() == 0)) {
                DbGroupEntity dbGroupEntity = this.groupRepository.getGroupDbById(call.getGroupId());
                CharSequence charSequence4 = charSequence3 = dbGroupEntity == null ? null : dbGroupEntity.getGetDisplayName();
                if (charSequence3 == null) {
                    String string2 = this.getApplicationContext().getString(R.string.group_call);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"applicationContext.getString(R.string.group_call)");
                    charSequence2 = string2;
                } else {
                    charSequence2 = charSequence3;
                }
            } else {
                Object object;
                Object object2;
                charSequence3 = this.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence3, (String)"applicationContext");
                if (!AppUtils.INSTANCE.isAppBackground((Context)charSequence3)) {
                    return;
                }
                Intent serviceIntent2 = new Intent(this.getApplicationContext(), CallNotificationService.class);
                CharSequence charSequence5 = call.getGroupCallId();
                if (!(charSequence5 == null || charSequence5.length() == 0)) {
                    DbGroupEntity dbGroupEntity = this.groupRepository.getGroupDbById(call.getGroupId());
                    CharSequence charSequence6 = charSequence5 = dbGroupEntity == null ? null : dbGroupEntity.getGetDisplayName();
                    if (charSequence5 == null) {
                        object2 = this.getApplicationContext().getString(R.string.group_call);
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"applicationContext.getString(R.string.group_call)");
                        object = object2;
                    } else {
                        object = charSequence5;
                    }
                } else {
                    String string3;
                    object2 = StringsKt.toLongOrNull((String)call.getMCallerUin());
                    if (object2 == null) {
                        string3 = null;
                    } else {
                        long it = ((Number)object2).longValue();
                        boolean bl = false;
                        NeUser neUser = this.groupRepository.getUserById(it);
                        string3 = neUser == null ? null : neUser.getGetDisplayName();
                    }
                    charSequence5 = string3;
                    if (charSequence5 == null) {
                        object2 = this.getApplicationContext().getString(R.string.unknown_user);
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"applicationContext.getSt\u2026ng(R.string.unknown_user)");
                        object = object2;
                    } else {
                        object = charSequence5;
                    }
                }
                CharSequence title = object;
                Object $this$processShowNotification_u24lambda_u2d2 = object2 = new Bundle();
                boolean bl = false;
                $this$processShowNotification_u24lambda_u2d2.putString("NOTIFICATION_TITLE", (String)title);
                $this$processShowNotification_u24lambda_u2d2.putParcelable("call", (Parcelable)call);
                Object mBundle = object2;
                serviceIntent2.putExtras((Bundle)mBundle);
                ContextCompat.startForegroundService((Context)this.getApplicationContext(), (Intent)serviceIntent2);
                charSequence2 = Unit.INSTANCE;
            }
            CharSequence charSequence7 = charSequence2;
        }
    }

    private final boolean checkCallNotExist(Call newCall, Call previousCall) {
        boolean bl;
        Boolean bl2;
        block8: {
            block10: {
                block9: {
                    long l;
                    Call call;
                    block7: {
                        call = previousCall;
                        if (call != null) break block7;
                        bl2 = null;
                        break block8;
                    }
                    Call _previousCall = call;
                    boolean bl3 = false;
                    String string2 = _previousCall.getGroupCallId();
                    if (string2 == null) {
                        l = 0L;
                    } else {
                        Long l2 = StringsKt.toLongOrNull((String)string2);
                        l = l2 == null ? 0L : l2;
                    }
                    if (l > 0L && Intrinsics.areEqual((Object)_previousCall.getGroupCallId(), (Object)newCall.getGroupCallId())) break block9;
                    Long l3 = StringsKt.toLongOrNull((String)_previousCall.getCallId());
                    if ((l3 == null ? 0L : l3) <= 0L || !Intrinsics.areEqual((Object)_previousCall.getCallId(), (Object)newCall.getCallId())) break block10;
                }
                return false;
            }
            bl2 = true;
        }
        Boolean bl4 = bl2;
        if (bl4 == null) {
            CallWorker it = this;
            boolean bl5 = false;
            bl = true;
        } else {
            bl = bl4;
        }
        return bl;
    }

    public static final /* synthetic */ void access$processShowNotification(CallWorker $this, Call call) {
        $this.processShowNotification(call);
    }

    public static final /* synthetic */ void access$checkConditionShowNotification(CallWorker $this, Call call) {
        $this.checkConditionShowNotification(call);
    }
}

