/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.full.widget;

import android.view.MotionEvent;
import android.view.View;
import com.netacom.base.chat.android_utils.ScreenUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/netacom/full/widget/DragOnTouchListener;", "Landroid/view/View$OnTouchListener;", "onClick", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "dX", "", "getDX", "()F", "setDX", "(F)V", "dY", "getDY", "setDY", "firstX", "", "firstY", "lastX", "lastY", "touchConsumedByMove", "", "onTouch", "view", "Landroid/view/View;", "event", "Landroid/view/MotionEvent;", "netacom-sdk-full_NetAloProdRelease"})
public final class DragOnTouchListener
implements View.OnTouchListener {
    @NotNull
    private final Function0<Unit> onClick;
    private int firstX;
    private int firstY;
    private int lastX;
    private int lastY;
    private boolean touchConsumedByMove;
    private float dX;
    private float dY;

    public DragOnTouchListener(@NotNull Function0<Unit> onClick2) {
        Intrinsics.checkNotNullParameter(onClick2, (String)"onClick");
        this.onClick = onClick2;
    }

    public final float getDX() {
        return this.dX;
    }

    public final void setDX(float f) {
        this.dX = f;
    }

    public final float getDY() {
        return this.dY;
    }

    public final void setDY(float f) {
        this.dY = f;
    }

    public boolean onTouch(@NotNull View view, @NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        int totalDeltaX = this.lastX - this.firstX;
        int totalDeltaY = this.lastY - this.firstY;
        int n = event.getAction();
        switch (n) {
            case 0: {
                this.lastX = (int)event.getRawX();
                this.lastY = (int)event.getRawY();
                this.firstX = this.lastX;
                this.firstY = this.lastY;
                this.dX = view.getX() - event.getRawX();
                this.dY = view.getY() - event.getRawY();
                this.touchConsumedByMove = false;
                return true;
            }
            case 1: {
                if (this.touchConsumedByMove) {
                    boolean bl = false;
                    if (Math.abs(totalDeltaX) > 20) break;
                    bl = false;
                    if (Math.abs(totalDeltaY) > 20) break;
                }
                this.onClick.invoke();
                break;
            }
            case 2: {
                this.lastX = (int)event.getRawX();
                this.lastY = (int)event.getRawY();
                float newX = event.getRawX() + this.dX;
                float newY = event.getRawY() + this.dY;
                boolean bl = false;
                if (Math.abs(totalDeltaX) < 20) {
                    bl = false;
                    if (Math.abs(totalDeltaY) < 20) break;
                }
                if (event.getPointerCount() != 1) break;
                if (newX <= 0.0f || newX >= (float)(ScreenUtils.getAppScreenWidth() - view.getWidth()) || newY <= 0.0f || newY >= (float)(ScreenUtils.getAppScreenHeight() - view.getHeight())) {
                    return true;
                }
                this.touchConsumedByMove = true;
                view.animate().x(newX).y(newY).setDuration(0L).start();
            }
        }
        return this.touchConsumedByMove;
    }
}

