/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.full.widget.swipe_layout;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import androidx.recyclerview.widget.RecyclerView;
import com.netacom.full.widget.swipe_layout.SwipeLayout;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010 \u001a\u00020\u001f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0018\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\nH\u0002R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/netacom/full/widget/swipe_layout/SwipeRecyclerView;", "Landroidx/recyclerview/widget/RecyclerView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "attrs", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "downX", "", "getDownX", "()F", "setDownX", "(F)V", "downY", "getDownY", "setDownY", "mTouchSlop", "getMTouchSlop", "()I", "setMTouchSlop", "(I)V", "touchFrame", "Landroid/graphics/Rect;", "closeMenu", "", "hasChildOpen", "", "onInterceptTouchEvent", "e", "Landroid/view/MotionEvent;", "pointToPosition", "x", "y", "netacom-sdk-full_NetAloDevRelease"})
public final class SwipeRecyclerView
extends RecyclerView {
    private int mTouchSlop;
    private float downX;
    private float downY;
    @Nullable
    private Rect touchFrame;

    public final int getMTouchSlop() {
        return this.mTouchSlop;
    }

    public final void setMTouchSlop(int n) {
        this.mTouchSlop = n;
    }

    public final float getDownX() {
        return this.downX;
    }

    public final void setDownX(float f) {
        this.downX = f;
    }

    public final float getDownY() {
        return this.downY;
    }

    public final void setDownY(float f) {
        this.downY = f;
    }

    public SwipeRecyclerView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    public SwipeRecyclerView(@NotNull Context context, @NotNull AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributeSet, (String)"attributeSet");
        super(context, attributeSet);
    }

    public SwipeRecyclerView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
    }

    public boolean onInterceptTouchEvent(@Nullable MotionEvent e) {
        Intrinsics.checkNotNull((Object)e);
        int n = e.getAction();
        switch (n) {
            case 0: {
                View positionView;
                this.downX = e.getX();
                this.downY = e.getY();
                int position = this.pointToPosition((int)e.getX(), (int)e.getY());
                int count = this.getChildCount();
                if (count > position && (positionView = this.getChildAt(position)) instanceof SwipeLayout && ((SwipeLayout)positionView).isOpen()) {
                    return super.onInterceptTouchEvent(e);
                }
                if (!this.hasChildOpen()) break;
                this.closeMenu();
                break;
            }
            case 2: {
                float dy = e.getY() - this.downY;
                float dx = e.getX() - this.downX;
                boolean bl = false;
                bl = false;
                if (!(Math.abs(dx) > Math.abs(dy))) break;
                bl = false;
                if (!(Math.abs(dx) > (float)this.mTouchSlop)) break;
                return false;
            }
        }
        return super.onInterceptTouchEvent(e);
    }

    private final int pointToPosition(int x, int y) {
        int count;
        int n;
        Rect frame = this.touchFrame;
        if (frame == null) {
            frame = this.touchFrame = new Rect();
        }
        if ((n = 0) < (count = this.getChildCount())) {
            do {
                int i;
                View child;
                if ((child = this.getChildAt(i = n++)).getVisibility() != 0) continue;
                child.getHitRect(frame);
                Intrinsics.checkNotNull((Object)frame);
                if (!frame.contains(x, y)) continue;
                return i;
            } while (n < count);
        }
        return -1;
    }

    private final boolean hasChildOpen() {
        int n = 0;
        int count = this.getChildCount();
        if (n < count) {
            do {
                int i;
                View view;
                if (!((view = this.getChildAt(i = n++)) instanceof SwipeLayout) || !((SwipeLayout)view).isOpen()) continue;
                return true;
            } while (n < count);
        }
        return false;
    }

    private final void closeMenu() {
        int n = 0;
        int count = this.getChildCount();
        if (n < count) {
            do {
                int i;
                View view;
                if (!((view = this.getChildAt(i = n++)) instanceof SwipeLayout) || !((SwipeLayout)view).isOpen()) continue;
                ((SwipeLayout)view).closeMenu();
            } while (n < count);
        }
    }
}

