/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.util;

import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.netacom.base.chat.android_utils.LanguageUtils;
import com.netacom.base.chat.type.Language;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u0004H\u0007J\b\u0010\u000f\u001a\u00020\nH\u0007J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0012H\u0007J\u001a\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\u0004H\u0007J\u001a\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/netacom/base/chat/util/TimeUtils;", "", "()V", "DATE_FORMAT", "", "PATTERN_ISO_INSTANT", "distanceTime", "Ljava/util/ArrayList;", "", "time", "", "getDateByUTC", "Ljava/util/Date;", "dateInString", "pattern", "getTimeStamp", "parseTimeAgo", "timeZoneDefault", "Ljava/util/TimeZone;", "timeZoneGMT", "toDate", "timestamp", "toUTCDate", "netacom-base-chat_NetAloDevRelease"})
public final class TimeUtils {
    @NotNull
    public static final TimeUtils INSTANCE = new TimeUtils();
    @NotNull
    public static final String DATE_FORMAT = "dd/MM/yyyy";
    @NotNull
    public static final String PATTERN_ISO_INSTANT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    private TimeUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String toDate(long timestamp, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, Locale.getDefault());
        return dateFormat.format(new Date(timestamp)).toString();
    }

    public static /* synthetic */ String toDate$default(long l, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = DATE_FORMAT;
        }
        return TimeUtils.toDate(l, string2);
    }

    @JvmStatic
    @NotNull
    public static final String toUTCDate(long timestamp, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, Locale.getDefault());
        dateFormat.setTimeZone(INSTANCE.timeZoneGMT());
        return dateFormat.format(new Date(timestamp)).toString();
    }

    public static /* synthetic */ String toUTCDate$default(long l, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = PATTERN_ISO_INSTANT;
        }
        return TimeUtils.toUTCDate(l, string2);
    }

    @JvmStatic
    @NotNull
    public static final TimeZone timeZoneGMT() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"getTimeZone(\"GMT\")");
        return timeZone;
    }

    @JvmStatic
    @NotNull
    public static final TimeZone timeZoneDefault() {
        TimeZone timeZone = TimeZone.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"getDefault()");
        return timeZone;
    }

    @JvmStatic
    @Nullable
    public static final Date getDateByUTC(@NotNull String dateInString, @NotNull String pattern) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)dateInString, (String)"dateInString");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, Locale.getDefault());
        dateFormat.setTimeZone(INSTANCE.timeZoneGMT());
        try {
            date = dateFormat.parse(dateInString);
        }
        catch (Exception e) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
            date = null;
        }
        return date;
    }

    public static /* synthetic */ Date getDateByUTC$default(String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = PATTERN_ISO_INSTANT;
        }
        return TimeUtils.getDateByUTC(string2, string3);
    }

    @JvmStatic
    public static final long getTimeStamp() {
        return Calendar.getInstance().getTimeInMillis();
    }

    @NotNull
    public final ArrayList<Integer> distanceTime(long time) {
        Object[] objectArray = new Integer[]{0, 0, 0, 0};
        ArrayList results = CollectionsKt.arrayListOf((Object[])objectArray);
        long currentMillis = System.currentTimeMillis() / (long)1000;
        long distanceTime = currentMillis - time;
        if (distanceTime < 0L) {
            return results;
        }
        int distanceTimeInt = (int)distanceTime;
        results.set(0, distanceTimeInt / 86400);
        results.set(1, distanceTimeInt % 86400 / 3600);
        results.set(2, distanceTimeInt % 3600 / 60);
        results.set(3, distanceTimeInt % 60);
        return results;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final String parseTimeAgo(long time) {
        List list;
        Object[] objectArray;
        long l;
        if (time == 0L) {
            return "";
        }
        boolean bl = false;
        if (String.valueOf(time).length() > 10) {
            String string2 = String.valueOf(time).substring(0, 10);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            l = Long.parseLong(string2);
        } else {
            l = time;
        }
        long timeMillis = l;
        String resultTime = "";
        if (timeMillis <= 0L) return resultTime;
        String string3 = null;
        if (Intrinsics.areEqual((Object)LanguageUtils.Companion.getLanguage(), (Object)Language.ENGLISH.getValue())) {
            string3 = "now";
            objectArray = new String[]{"day", "hour", "min", "second"};
            list = CollectionsKt.mutableListOf((Object[])objectArray);
        } else {
            string3 = "m\u1edbi \u0111\u00e2y";
            objectArray = new String[]{"ng\u00e0y", "gi\u1edd", "ph\u00fat", "gi\u00e2y"};
            list = CollectionsKt.mutableListOf((Object[])objectArray);
        }
        List labels = list;
        ArrayList<Integer> times = this.distanceTime(timeMillis);
        int n = 0;
        int n2 = ((Collection)times).size();
        while (n < n2) {
            int index = n++;
            Integer n3 = times.get(index);
            Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"times[index]");
            if (((Number)n3).intValue() > 0) {
                String string4;
                if (index == 0) {
                    n3 = times.get(index);
                    Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"times[index]");
                    if (((Number)n3).intValue() > 7) {
                        string4 = TimeUtils.toDate$default(time * (long)1000, null, 2, null);
                        return string4;
                    }
                }
                if (index == 3) {
                    string4 = string3;
                    return string4;
                }
                n3 = times.get(index);
                Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"times[index]");
                if (((Number)n3).intValue() < 2) {
                    string4 = "" + ((Number)times.get(index)).intValue() + ' ' + (String)labels.get(index);
                    return string4;
                }
                if (Intrinsics.areEqual((Object)LanguageUtils.Companion.getLanguage(), (Object)Language.ENGLISH.getValue())) {
                    string4 = "" + ((Number)times.get(index)).intValue() + ' ' + (String)labels.get(index) + "s ago";
                    return string4;
                }
                string4 = "" + ((Number)times.get(index)).intValue() + ' ' + (String)labels.get(index) + " tr\u01b0\u1edbc";
                return string4;
            }
            if (index != ((Collection)times).size() - 1) continue;
            resultTime = string3;
        }
        return resultTime;
    }
}

