/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.util;

import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.netacom.base.chat.android_utils.LanguageUtils;
import com.netacom.base.chat.type.Language;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001c\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u0004H\u0007J\b\u0010\u0010\u001a\u00020\u000bH\u0007J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0007J\b\u0010\u0014\u001a\u00020\u0013H\u0007J\u001a\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u0004H\u0007J\u001a\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/netacom/base/chat/util/TimeUtils;", "", "()V", "DATE_FORMAT", "", "PATTERN_ISO_INSTANT", "distanceTime", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "time", "", "getDateByUTC", "Ljava/util/Date;", "dateInString", "pattern", "getTimeStamp", "parseTimeAgo", "timeZoneDefault", "Ljava/util/TimeZone;", "timeZoneGMT", "toDate", "timestamp", "toUTCDate", "netacom-base-chat_NetAloDevRelease"})
public final class TimeUtils {
    @NotNull
    public static final TimeUtils INSTANCE = new TimeUtils();
    @NotNull
    public static final String DATE_FORMAT = "dd/MM/yyyy";
    @NotNull
    public static final String PATTERN_ISO_INSTANT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    private TimeUtils() {
    }

    @JvmStatic
    @NotNull
    public static final String toDate(long timestamp, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, Locale.getDefault());
        return dateFormat.format(new Date(timestamp)).toString();
    }

    public static /* synthetic */ String toDate$default(long l, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = DATE_FORMAT;
        }
        return TimeUtils.toDate(l, string2);
    }

    @JvmStatic
    @NotNull
    public static final String toUTCDate(long timestamp, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, Locale.getDefault());
        dateFormat.setTimeZone(INSTANCE.timeZoneGMT());
        return dateFormat.format(new Date(timestamp)).toString();
    }

    public static /* synthetic */ String toUTCDate$default(long l, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = PATTERN_ISO_INSTANT;
        }
        return TimeUtils.toUTCDate(l, string2);
    }

    @JvmStatic
    @NotNull
    public static final TimeZone timeZoneGMT() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"getTimeZone(\"GMT\")");
        return timeZone;
    }

    @JvmStatic
    @NotNull
    public static final TimeZone timeZoneDefault() {
        TimeZone timeZone = TimeZone.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"getDefault()");
        return timeZone;
    }

    @JvmStatic
    @Nullable
    public static final Date getDateByUTC(@NotNull String dateInString, @NotNull String pattern) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)dateInString, (String)"dateInString");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, Locale.getDefault());
        dateFormat.setTimeZone(INSTANCE.timeZoneGMT());
        try {
            date = dateFormat.parse(dateInString);
        }
        catch (Exception e) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
            date = null;
        }
        return date;
    }

    public static /* synthetic */ Date getDateByUTC$default(String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = PATTERN_ISO_INSTANT;
        }
        return TimeUtils.getDateByUTC(string2, string3);
    }

    @JvmStatic
    public static final long getTimeStamp() {
        return Calendar.getInstance().getTimeInMillis();
    }

    @NotNull
    public final ArrayList<Integer> distanceTime(long time) {
        Object[] objectArray = new Integer[]{0, 0, 0, 0};
        ArrayList results = CollectionsKt.arrayListOf((Object[])objectArray);
        long currentMillis = System.currentTimeMillis() / (long)1000;
        long distanceTime = currentMillis - time;
        if (distanceTime < 0L) {
            return results;
        }
        int distanceTimeInt = (int)distanceTime;
        results.set(0, distanceTimeInt / 86400);
        results.set(1, distanceTimeInt % 86400 / 3600);
        results.set(2, distanceTimeInt % 3600 / 60);
        results.set(3, distanceTimeInt % 60);
        return results;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final String parseTimeAgo(long time) {
        block11: {
            if (time == 0L) {
                return "";
            }
            var5_2 = false;
            var6_4 = false;
            $i$a$-run-TimeUtils$parseTimeAgo$timeMillis$1 = false;
            if (String.valueOf(time).length() > 10) {
                var8_8 = String.valueOf(time);
                var9_9 = 0;
                var10_10 = 10;
                var11_11 = false;
                if (var8_8 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                v0 = var8_8.substring(var9_9, var10_10);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                var8_8 = v0;
                var9_9 = 0;
                v1 = Long.parseLong((String)var8_8);
            } else {
                v1 = time;
            }
            timeMillis = v1;
            resultTime = "";
            if (timeMillis <= 0L) break block11;
            new = null;
            if (Intrinsics.areEqual((Object)LanguageUtils.Companion.getLanguage(), (Object)Language.ENGLISH.getValue())) {
                new = "now";
                var8_8 = new String[]{"day", "hour", "min", "second"};
                v2 = CollectionsKt.mutableListOf((Object[])var8_8);
            } else {
                new = "m\u1edbi \u0111\u00e2y";
                var8_8 = new String[]{"ng\u00e0y", "gi\u1edd", "ph\u00fat", "gi\u00e2y"};
                v2 = CollectionsKt.mutableListOf((Object[])var8_8);
            }
            labels = v2;
            times = this.distanceTime(timeMillis);
            var9_9 = 0;
            var11_12 = times;
            var12_15 = false;
            var10_10 = var11_12.size();
            if (var9_9 >= var10_10) break block11;
            do {
                block12: {
                    index = var9_9++;
                    var12_16 = times.get(index);
                    Intrinsics.checkNotNullExpressionValue((Object)var12_16, (String)"times[index]");
                    if (((Number)var12_16).intValue() <= 0) break block12;
                    if (index != 0) ** GOTO lbl-1000
                    var12_16 = times.get(index);
                    Intrinsics.checkNotNullExpressionValue((Object)var12_16, (String)"times[index]");
                    if (((Number)var12_16).intValue() > 7) {
                        v3 = TimeUtils.toDate$default(time * (long)1000, null, 2, null);
                    } else if (index == 3) {
                        v3 = new;
                    } else {
                        var12_16 = times.get(index);
                        Intrinsics.checkNotNullExpressionValue((Object)var12_16, (String)"times[index]");
                        v3 = ((Number)var12_16).intValue() < 2 ? "" + ((Number)times.get(index)).intValue() + ' ' + (String)labels.get(index) : (Intrinsics.areEqual((Object)LanguageUtils.Companion.getLanguage(), (Object)Language.ENGLISH.getValue()) != false ? "" + ((Number)times.get(index)).intValue() + ' ' + (String)labels.get(index) + "s ago" : "" + ((Number)times.get(index)).intValue() + ' ' + (String)labels.get(index) + " tr\u01b0\u1edbc");
                    }
                    resultTime = v3;
                    break;
                }
                var12_16 = times;
                var13_17 = false;
                if (index != var12_16.size() - 1) continue;
                resultTime = new;
            } while (var9_9 < var10_10);
        }
        return resultTime;
    }
}

