/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.persistence;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.configuration.ConditionOnExternalStorage;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.repository.extrnal.ExternalStoragePersistServiceImpl;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.plugin.auth.impl.persistence.AuthRowMapperManager;
import com.alibaba.nacos.plugin.auth.impl.persistence.PermissionInfo;
import com.alibaba.nacos.plugin.auth.impl.persistence.PermissionPersistService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Conditional(value={ConditionOnExternalStorage.class})
@Component
public class ExternalPermissionPersistServiceImpl
implements PermissionPersistService {
    @Autowired
    private ExternalStoragePersistServiceImpl persistService;
    private JdbcTemplate jt;
    private static final String PATTERN_STR = "*";

    @PostConstruct
    protected void init() {
        this.jt = this.persistService.getJdbcTemplate();
    }

    @Override
    public Page<PermissionInfo> getPermissions(String role, int pageNo, int pageSize) {
        PaginationHelper helper = this.persistService.createPaginationHelper();
        String sqlCountRows = "SELECT count(*) FROM permissions WHERE ";
        String sqlFetchRows = "SELECT role,resource,action FROM permissions WHERE ";
        String where = " role= ? ";
        List<Object> params = new ArrayList();
        if (StringUtils.isNotBlank((String)role)) {
            params = Collections.singletonList(role);
        } else {
            where = " 1=1 ";
        }
        try {
            Page pageInfo = helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, (RowMapper)AuthRowMapperManager.PERMISSION_ROW_MAPPER);
            if (pageInfo == null) {
                pageInfo = new Page();
                pageInfo.setTotalCount(0);
                pageInfo.setPageItems(new ArrayList());
            }
            return pageInfo;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void addPermission(String role, String resource, String action) {
        String sql = "INSERT INTO permissions (role, resource, action) VALUES (?, ?, ?)";
        try {
            this.jt.update(sql, new Object[]{role, resource, action});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void deletePermission(String role, String resource, String action) {
        String sql = "DELETE FROM permissions WHERE role=? AND resource=? AND action=?";
        try {
            this.jt.update(sql, new Object[]{role, resource, action});
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<PermissionInfo> findPermissionsLike4Page(String role, int pageNo, int pageSize) {
        PaginationHelper helper = this.persistService.createPaginationHelper();
        String sqlCountRows = "SELECT count(*) FROM permissions ";
        String sqlFetchRows = "SELECT role,resource,action FROM permissions ";
        StringBuilder where = new StringBuilder(" WHERE 1=1");
        ArrayList<String> params = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)role)) {
            where.append(" AND role LIKE ?");
            params.add(this.generateLikeArgument(role));
        }
        try {
            Page pageInfo = helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, (RowMapper)AuthRowMapperManager.PERMISSION_ROW_MAPPER);
            if (pageInfo == null) {
                pageInfo = new Page();
                pageInfo.setTotalCount(0);
                pageInfo.setPageItems(new ArrayList());
            }
            return pageInfo;
        }
        catch (CannotGetJdbcConnectionException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + e.toString(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public String generateLikeArgument(String s) {
        String underscore = "_";
        if (s.contains(underscore)) {
            s = s.replaceAll(underscore, "\\\\_");
        }
        String fuzzySearchSign = "\\*";
        String sqlLikePercentSign = "%";
        if (s.contains(PATTERN_STR)) {
            return s.replaceAll(fuzzySearchSign, sqlLikePercentSign);
        }
        return s;
    }
}

