/*
 * Decompiled with CFR 0.152.
 */
package video.api.uploader.api.notifications;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import androidx.annotation.StringRes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\b\b\u0001\u0010\r\u001a\u00020\u00042\b\b\u0001\u0010\u000e\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lvideo/api/uploader/api/notifications/NotificationUtils;", "", "()V", "DEFAULT_NOTIFICATION_ID", "", "DEFAULT_NOTIFICATION_SERVICE_CHANNEL_ID", "", "DEFAULT_NOTIFICATION_WORK_CHANNEL_ID", "createNotificationChannel", "", "context", "Landroid/content/Context;", "channelId", "nameResourceId", "descriptionResourceId", "android-video-uploader_release"})
public final class NotificationUtils {
    @NotNull
    public static final NotificationUtils INSTANCE = new NotificationUtils();
    @NotNull
    public static final String DEFAULT_NOTIFICATION_SERVICE_CHANNEL_ID = "video.api.uploader.service";
    @NotNull
    public static final String DEFAULT_NOTIFICATION_WORK_CHANNEL_ID = "video.api.uploader.work";
    public static final int DEFAULT_NOTIFICATION_ID = 3333;

    private NotificationUtils() {
    }

    public final void createNotificationChannel(@NotNull Context context, @NotNull String channelId, @StringRes int nameResourceId, @StringRes int descriptionResourceId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        if (Build.VERSION.SDK_INT >= 26) {
            String string = context.getString(nameResourceId);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.getString(nameResourceId)");
            String name = string;
            NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)name, 2);
            if (descriptionResourceId != 0) {
                channel.setDescription(context.getString(descriptionResourceId));
            }
            Object object = context.getSystemService("notification");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
            NotificationManager notificationManager2 = (NotificationManager)object;
            notificationManager2.createNotificationChannel(channel);
        }
    }
}

