/*
 * Decompiled with CFR 0.152.
 */
package video.api.uploader;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import video.api.uploader.api.ApiCallback;
import video.api.uploader.api.ApiClient;
import video.api.uploader.api.ApiException;
import video.api.uploader.api.ApiResponse;
import video.api.uploader.api.Pair;
import video.api.uploader.api.models.Environment;
import video.api.uploader.api.models.Video;
import video.api.uploader.api.upload.IProgressiveUploadSession;
import video.api.uploader.api.upload.UploadChunkRequestBody;
import video.api.uploader.api.upload.UploadPartProgressListener;
import video.api.uploader.api.upload.UploadProgressListener;

public class VideosApi {
    private ApiClient localVarApiClient;

    public VideosApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public VideosApi() {
        this.localVarApiClient = new ApiClient(Environment.PRODUCTION.basePath);
    }

    public VideosApi(String basePath) {
        this.localVarApiClient = new ApiClient(basePath);
    }

    public VideosApi(String apiKey, String basePath) {
        this.localVarApiClient = new ApiClient(apiKey, basePath);
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private Call uploadWithUploadTokenCall(String token, File file, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/upload";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadWithUploadTokenChunkCall(String token, File file, String videoId, long chunkStart, long chunkEnd, long totalBytes, Integer chunksCount, Integer chunkNum, UploadProgressListener progressListener, UploadPartProgressListener partProgressListener, ApiCallback _callback, boolean isProgressiveUpload) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/upload";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            if (isProgressiveUpload) {
                localVarFormParams.put("file", (Object)new UploadChunkRequestBody(file, totalBytes, partProgressListener));
            } else {
                localVarFormParams.put("file", (Object)new UploadChunkRequestBody(file, chunksCount, chunkNum, totalBytes, chunkStart, chunkEnd + 1L, progressListener));
            }
        }
        if (token != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("token", token));
        }
        localVarHeaderParams.put("Content-Range", "part " + chunkNum + "/" + (chunksCount != null ? chunksCount : "*"));
        if (videoId != null) {
            localVarFormParams.put("videoId", videoId);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadWithUploadTokenValidateBeforeCall(String token, File file, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling uploadWithUploadToken");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling uploadWithUploadToken");
        }
        Call localVarCall = this.uploadWithUploadTokenCall(token, file, _callback);
        return localVarCall;
    }

    private Call uploadWithUploadTokenChunkValidateBeforeCall(String token, File file, String videoId, long chunkStart, long chunkEnd, long totalBytes, Integer chunksCount, Integer chunkNum, UploadProgressListener progressListener, UploadPartProgressListener partProgressListener, ApiCallback _callback, boolean isProgressiveUpload) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling uploadWithUploadToken(Async)");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling uploadWithUploadToken(Async)");
        }
        Call localVarCall = this.uploadWithUploadTokenChunkCall(token, file, videoId, chunkStart, chunkEnd, totalBytes, chunksCount, chunkNum, progressListener, partProgressListener, _callback, isProgressiveUpload);
        return localVarCall;
    }

    public Video uploadWithUploadToken(String token, File file) throws ApiException {
        ApiResponse<Video> localVarResp = this.uploadWithUploadTokenWithHttpInfo(token, file);
        return localVarResp.getData();
    }

    public Video uploadWithUploadToken(String token, File file, UploadProgressListener uploadProgressListener) throws ApiException {
        ApiResponse<Video> localVarResp = this.uploadWithUploadTokenWithHttpInfo(token, file, uploadProgressListener);
        return localVarResp.getData();
    }

    public ApiResponse<Video> uploadWithUploadTokenWithHttpInfo(String token, File file) throws ApiException {
        return this.uploadWithUploadTokenWithHttpInfo(token, file, null);
    }

    public ApiResponse<Video> uploadWithUploadTokenPartWithHttpInfo(String token, File file, String videoId, Integer part, boolean isLast, UploadPartProgressListener uploadProgressListener) throws ApiException {
        long fileSize = file.length();
        Call localVarCall = this.uploadWithUploadTokenChunkValidateBeforeCall(token, file, videoId, 0L, fileSize, fileSize, isLast ? part : null, part, null, uploadProgressListener, null, true);
        Type localVarReturnType = new TypeToken<Video>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public UploadWithUploadTokenProgressiveSession createUploadWithUploadTokenProgressiveSession(String token) {
        return new UploadWithUploadTokenProgressiveSession(token);
    }

    public ApiResponse<Video> uploadWithUploadTokenWithHttpInfo(String token, File file, final UploadProgressListener uploadProgressListener) throws ApiException {
        long chunkSize;
        String videoId = null;
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling upload");
        }
        final long totalBytes = file.length();
        if (totalBytes > (chunkSize = this.getApiClient().getUploadChunkSize())) {
            int chunkNum = 0;
            ApiResponse lastRes = null;
            for (long i = 0L; i < totalBytes; i += chunkSize) {
                Call localVarCall = this.uploadWithUploadTokenChunkValidateBeforeCall(token, file, videoId, i, Math.min(i + chunkSize, totalBytes) - 1L, totalBytes, (int)Math.ceil((float)totalBytes / (float)chunkSize), chunkNum + 1, uploadProgressListener, null, null, false);
                Type localVarReturnType = new TypeToken<Video>(){}.getType();
                lastRes = this.localVarApiClient.execute(localVarCall, localVarReturnType);
                if (videoId == null) {
                    videoId = ((Video)lastRes.getData()).getVideoId();
                }
                ++chunkNum;
            }
            return lastRes;
        }
        ApiCallback apiCallback = new ApiCallback(){

            public void onFailure(ApiException e, int statusCode, Map responseHeaders) {
            }

            public void onSuccess(Object result, int statusCode, Map responseHeaders) {
            }

            @Override
            public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                if (uploadProgressListener != null) {
                    uploadProgressListener.onProgress(bytesWritten - (contentLength - totalBytes), totalBytes, 1, 1);
                }
            }

            @Override
            public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
            }
        };
        Call localVarCall = this.uploadWithUploadTokenValidateBeforeCall(token, file, apiCallback);
        Type localVarReturnType = new TypeToken<Video>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call uploadCall(String videoId, File file, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/videos/{videoId}/source".replaceAll("\\{videoId\\}", this.localVarApiClient.escapeString(videoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadChunkCall(String videoId, File file, long chunkStart, long chunkEnd, long totalBytes, Integer chunksCount, Integer chunkNum, UploadProgressListener progressListener, UploadPartProgressListener partProgressListener, ApiCallback _callback, boolean isProgressiveUpload) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/videos/{videoId}/source".replaceAll("\\{videoId\\}", this.localVarApiClient.escapeString(videoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            if (isProgressiveUpload) {
                localVarFormParams.put("file", (Object)new UploadChunkRequestBody(file, totalBytes, partProgressListener));
            } else {
                localVarFormParams.put("file", (Object)new UploadChunkRequestBody(file, chunksCount, chunkNum, totalBytes, chunkStart, chunkEnd + 1L, progressListener));
            }
        }
        localVarHeaderParams.put("Content-Range", "part " + chunkNum + "/" + (chunksCount != null ? chunksCount : "*"));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadValidateBeforeCall(String videoId, File file, ApiCallback _callback) throws ApiException {
        if (videoId == null) {
            throw new ApiException("Missing the required parameter 'videoId' when calling upload");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling upload");
        }
        Call localVarCall = this.uploadCall(videoId, file, _callback);
        return localVarCall;
    }

    private Call uploadChunkValidateBeforeCall(String videoId, File file, long chunkStart, long chunkEnd, long totalBytes, Integer chunksCount, Integer chunkNum, UploadProgressListener progressListener, UploadPartProgressListener partProgressListener, ApiCallback _callback, boolean isProgressiveUpload) throws ApiException {
        if (videoId == null) {
            throw new ApiException("Missing the required parameter 'videoId' when calling upload(Async)");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling upload(Async)");
        }
        Call localVarCall = this.uploadChunkCall(videoId, file, chunkStart, chunkEnd, totalBytes, chunksCount, chunkNum, progressListener, partProgressListener, _callback, isProgressiveUpload);
        return localVarCall;
    }

    public Video upload(String videoId, File file) throws ApiException {
        ApiResponse<Video> localVarResp = this.uploadWithHttpInfo(videoId, file);
        return localVarResp.getData();
    }

    public Video upload(String videoId, File file, UploadProgressListener uploadProgressListener) throws ApiException {
        ApiResponse<Video> localVarResp = this.uploadWithHttpInfo(videoId, file, uploadProgressListener);
        return localVarResp.getData();
    }

    public ApiResponse<Video> uploadWithHttpInfo(String videoId, File file) throws ApiException {
        return this.uploadWithHttpInfo(videoId, file, null);
    }

    public ApiResponse<Video> uploadPartWithHttpInfo(String videoId, File file, Integer part, boolean isLast, UploadPartProgressListener uploadProgressListener) throws ApiException {
        long fileSize = file.length();
        Call localVarCall = this.uploadChunkValidateBeforeCall(videoId, file, 0L, fileSize, fileSize, isLast ? part : null, part, null, uploadProgressListener, null, true);
        Type localVarReturnType = new TypeToken<Video>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public UploadProgressiveSession createUploadProgressiveSession(String videoId) {
        return new UploadProgressiveSession(videoId);
    }

    public ApiResponse<Video> uploadWithHttpInfo(String videoId, File file, final UploadProgressListener uploadProgressListener) throws ApiException {
        long chunkSize;
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling upload");
        }
        final long totalBytes = file.length();
        if (totalBytes > (chunkSize = this.getApiClient().getUploadChunkSize())) {
            int chunkNum = 0;
            ApiResponse lastRes = null;
            for (long i = 0L; i < totalBytes; i += chunkSize) {
                Call localVarCall = this.uploadChunkValidateBeforeCall(videoId, file, i, Math.min(i + chunkSize, totalBytes) - 1L, totalBytes, (int)Math.ceil((float)totalBytes / (float)chunkSize), chunkNum + 1, uploadProgressListener, null, null, false);
                Type localVarReturnType = new TypeToken<Video>(){}.getType();
                lastRes = this.localVarApiClient.execute(localVarCall, localVarReturnType);
                ++chunkNum;
            }
            return lastRes;
        }
        ApiCallback apiCallback = new ApiCallback(){

            public void onFailure(ApiException e, int statusCode, Map responseHeaders) {
            }

            public void onSuccess(Object result, int statusCode, Map responseHeaders) {
            }

            @Override
            public void onUploadProgress(long bytesWritten, long contentLength, boolean done) {
                if (uploadProgressListener != null) {
                    uploadProgressListener.onProgress(bytesWritten - (contentLength - totalBytes), totalBytes, 1, 1);
                }
            }

            @Override
            public void onDownloadProgress(long bytesRead, long contentLength, boolean done) {
            }
        };
        Call localVarCall = this.uploadValidateBeforeCall(videoId, file, apiCallback);
        Type localVarReturnType = new TypeToken<Video>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public class UploadProgressiveSession
    implements IProgressiveUploadSession {
        private Integer part = 1;
        private String videoId;

        public UploadProgressiveSession(String videoId) {
            this.videoId = videoId;
        }

        @Override
        public Video uploadPart(File part) throws ApiException {
            return this.uploadPart(part, false, null);
        }

        @Override
        public Video uploadLastPart(File part) throws ApiException {
            return this.uploadPart(part, true, null);
        }

        @Override
        public Video uploadPart(File part, UploadPartProgressListener uploadProgressListener) throws ApiException {
            return this.uploadPart(part, false, uploadProgressListener);
        }

        @Override
        public Video uploadLastPart(File part, UploadPartProgressListener uploadProgressListener) throws ApiException {
            return this.uploadPart(part, true, uploadProgressListener);
        }

        @Override
        public Video uploadPart(File part, boolean isLastPart, UploadPartProgressListener uploadProgressListener) throws ApiException {
            Integer lastPart = this.part;
            Integer n = this.part;
            Integer n2 = this.part = Integer.valueOf(this.part + 1);
            ApiResponse<Video> localVarResp = VideosApi.this.uploadPartWithHttpInfo(this.videoId, part, lastPart, isLastPart, uploadProgressListener);
            return localVarResp.getData();
        }
    }

    public class UploadWithUploadTokenProgressiveSession
    implements IProgressiveUploadSession {
        private Integer part = 1;
        private String videoId;
        private String token;

        public UploadWithUploadTokenProgressiveSession(String token) {
            this.token = token;
        }

        @Override
        public Video uploadPart(File part) throws ApiException {
            return this.uploadPart(part, false, null);
        }

        @Override
        public Video uploadLastPart(File part) throws ApiException {
            return this.uploadPart(part, true, null);
        }

        @Override
        public Video uploadPart(File part, UploadPartProgressListener uploadProgressListener) throws ApiException {
            return this.uploadPart(part, false, uploadProgressListener);
        }

        @Override
        public Video uploadLastPart(File part, UploadPartProgressListener uploadProgressListener) throws ApiException {
            return this.uploadPart(part, true, uploadProgressListener);
        }

        @Override
        public Video uploadPart(File part, boolean isLastPart, UploadPartProgressListener uploadProgressListener) throws ApiException {
            Integer lastPart = this.part;
            Integer n = this.part;
            Integer n2 = this.part = Integer.valueOf(this.part + 1);
            ApiResponse<Video> localVarResp = VideosApi.this.uploadWithUploadTokenPartWithHttpInfo(this.token, part, this.videoId, lastPart, isLastPart, uploadProgressListener);
            if (this.videoId == null) {
                this.videoId = localVarResp.getData().getVideoId();
            }
            return localVarResp.getData();
        }
    }
}

