/*
 * Decompiled with CFR 0.152.
 */
package video.api.player.analytics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import video.api.player.analytics.ApiVideoPlayerAnalytics;
import video.api.player.analytics.Event;
import video.api.player.analytics.Options;
import video.api.player.analytics.PingEvent;
import video.api.player.analytics.PlaybackPingMessage;
import video.api.player.analytics.RequestManager;
import video.api.player.analytics.Session;
import video.api.player.analytics.Utils;
import video.api.player.analytics.VideoType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 22\u00020\u0001:\u00012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J:\u0010\u001f\u001a\u00020\u00192\b\b\u0002\u0010\u001c\u001a\u00020\u00062\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190!2\u0018\b\u0002\u0010\"\u001a\u0012\u0012\b\u0012\u00060$j\u0002`%\u0012\u0004\u0012\u00020\u00190#J:\u0010&\u001a\u00020\u00192\b\b\u0002\u0010\u001c\u001a\u00020\u00062\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190!2\u0018\b\u0002\u0010\"\u001a\u0012\u0012\b\u0012\u00060$j\u0002`%\u0012\u0004\u0012\u00020\u00190#J:\u0010'\u001a\u00020\u00192\b\b\u0002\u0010\u001c\u001a\u00020\u00062\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190!2\u0018\b\u0002\u0010\"\u001a\u0012\u0012\b\u0012\u00060$j\u0002`%\u0012\u0004\u0012\u00020\u00190#J:\u0010(\u001a\u00020\u00192\b\b\u0002\u0010\u001c\u001a\u00020\u00062\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190!2\u0018\b\u0002\u0010\"\u001a\u0012\u0012\b\u0012\u00060$j\u0002`%\u0012\u0004\u0012\u00020\u00190#J:\u0010)\u001a\u00020\u00192\b\b\u0002\u0010\u001c\u001a\u00020\u00062\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190!2\u0018\b\u0002\u0010\"\u001a\u0012\u0012\b\u0012\u00060$j\u0002`%\u0012\u0004\u0012\u00020\u00190#J:\u0010*\u001a\u00020\u00192\b\b\u0002\u0010\u001c\u001a\u00020\u00062\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190!2\u0018\b\u0002\u0010\"\u001a\u0012\u0012\b\u0012\u00060$j\u0002`%\u0012\u0004\u0012\u00020\u00190#J\b\u0010+\u001a\u00020\u0019H\u0002J@\u0010,\u001a\u00020\u00192\u0006\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u00062\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190!2\u0018\b\u0002\u0010\"\u001a\u0012\u0012\b\u0012\u00060$j\u0002`%\u0012\u0004\u0012\u00020\u00190#J:\u0010/\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u001e2\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190!2\u0018\b\u0002\u0010\"\u001a\u0012\u0012\b\u0012\u00060$j\u0002`%\u0012\u0004\u0012\u00020\u00190#H\u0002J\b\u00101\u001a\u00020\u0019H\u0002R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u0010@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lvideo/api/player/analytics/ApiVideoPlayerAnalytics;", "", "options", "Lvideo/api/player/analytics/Options;", "(Lvideo/api/player/analytics/Options;)V", "value", "", "currentTime", "getCurrentTime", "()F", "setCurrentTime", "(F)V", "eventsStack", "", "Lvideo/api/player/analytics/PingEvent;", "loadedAt", "", "sessionId", "getSessionId$analytics_release", "()Ljava/lang/String;", "setSessionId$analytics_release", "(Ljava/lang/String;)V", "timer", "Ljava/util/Timer;", "addEventAt", "", "eventName", "Lvideo/api/player/analytics/Event;", "eventTime", "buildPingPayload", "Lvideo/api/player/analytics/PlaybackPingMessage;", "destroy", "onSuccess", "Lkotlin/Function0;", "onError", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "end", "pause", "play", "ready", "resume", "schedule", "seek", "from", "to", "sendPing", "payload", "unschedule", "Companion", "analytics_release"})
@SourceDebugExtension(value={"SMAP\nApiVideoPlayerAnalytics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiVideoPlayerAnalytics.kt\nvideo/api/player/analytics/ApiVideoPlayerAnalytics\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,270:1\n1#2:271\n*E\n"})
public final class ApiVideoPlayerAnalytics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Options options;
    @NotNull
    private final List<PingEvent> eventsStack;
    @Nullable
    private Timer timer;
    @NotNull
    private final String loadedAt;
    @Nullable
    private String sessionId;
    private float currentTime;
    @NotNull
    private static final String TAG = "ApiVideoPlayerAnalytics";
    private static final long PLAYBACK_PING_DELAY = 10000L;

    public ApiVideoPlayerAnalytics(@NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
        this.eventsStack = new ArrayList();
        this.loadedAt = Utils.INSTANCE.nowUtcToIso();
    }

    @Nullable
    public final String getSessionId$analytics_release() {
        return this.sessionId;
    }

    public final void setSessionId$analytics_release(@Nullable String value) {
        block1: {
            String string = value;
            if (string == null) break block1;
            String session = string;
            boolean bl = false;
            Function1<String, Unit> function1 = this.options.getOnSessionIdReceived();
            if (function1 != null) {
                Function1<String, Unit> it = function1;
                boolean bl2 = false;
                it.invoke((Object)session);
            }
            this.sessionId = session;
        }
    }

    public final float getCurrentTime() {
        return this.currentTime;
    }

    public final void setCurrentTime(float value) {
        if (!(value >= 0.0f)) {
            throw new IOException("currentTime must be positive value but currentTime=" + value);
        }
        this.currentTime = value;
    }

    public final void play(float eventTime, @NotNull Function0<Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onError) {
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        this.schedule();
        this.addEventAt(Event.PLAY, eventTime);
        onSuccess.invoke();
    }

    public static /* synthetic */ void play$default(ApiVideoPlayerAnalytics apiVideoPlayerAnalytics, float f, Function0 function0, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            f = apiVideoPlayerAnalytics.currentTime;
        }
        if ((n & 2) != 0) {
            function0 = play.1.INSTANCE;
        }
        if ((n & 4) != 0) {
            function1 = play.2.INSTANCE;
        }
        apiVideoPlayerAnalytics.play(f, (Function0<Unit>)function0, (Function1<? super Exception, Unit>)function1);
    }

    public final void resume(float eventTime, @NotNull Function0<Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onError) {
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        this.schedule();
        this.addEventAt(Event.RESUME, eventTime);
        onSuccess.invoke();
    }

    public static /* synthetic */ void resume$default(ApiVideoPlayerAnalytics apiVideoPlayerAnalytics, float f, Function0 function0, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            f = apiVideoPlayerAnalytics.currentTime;
        }
        if ((n & 2) != 0) {
            function0 = resume.1.INSTANCE;
        }
        if ((n & 4) != 0) {
            function1 = resume.2.INSTANCE;
        }
        apiVideoPlayerAnalytics.resume(f, (Function0<Unit>)function0, (Function1<? super Exception, Unit>)function1);
    }

    public final void ready(float eventTime, @NotNull Function0<Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onError) {
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        this.addEventAt(Event.READY, eventTime);
        this.sendPing(this.buildPingPayload(), onSuccess, onError);
    }

    public static /* synthetic */ void ready$default(ApiVideoPlayerAnalytics apiVideoPlayerAnalytics, float f, Function0 function0, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            f = apiVideoPlayerAnalytics.currentTime;
        }
        if ((n & 2) != 0) {
            function0 = ready.1.INSTANCE;
        }
        if ((n & 4) != 0) {
            function1 = ready.2.INSTANCE;
        }
        apiVideoPlayerAnalytics.ready(f, (Function0<Unit>)function0, (Function1<? super Exception, Unit>)function1);
    }

    public final void end(float eventTime, @NotNull Function0<Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onError) {
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        this.unschedule();
        this.addEventAt(Event.END, eventTime);
        this.sendPing(this.buildPingPayload(), onSuccess, onError);
    }

    public static /* synthetic */ void end$default(ApiVideoPlayerAnalytics apiVideoPlayerAnalytics, float f, Function0 function0, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            f = apiVideoPlayerAnalytics.currentTime;
        }
        if ((n & 2) != 0) {
            function0 = end.1.INSTANCE;
        }
        if ((n & 4) != 0) {
            function1 = end.2.INSTANCE;
        }
        apiVideoPlayerAnalytics.end(f, (Function0<Unit>)function0, (Function1<? super Exception, Unit>)function1);
    }

    public final void seek(float from, float to, @NotNull Function0<Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onError) {
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        if (!(from >= 0.0f) || !(to >= 0.0f)) {
            throw new IOException("from and to must be positive value but from=" + from + " to=" + to);
        }
        this.eventsStack.add(new PingEvent(null, from < to ? Event.SEEK_FORWARD : Event.SEEK_BACKWARD, null, Float.valueOf(from), Float.valueOf(to), 5, null));
        onSuccess.invoke();
    }

    public static /* synthetic */ void seek$default(ApiVideoPlayerAnalytics apiVideoPlayerAnalytics, float f, float f2, Function0 function0, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = seek.1.INSTANCE;
        }
        if ((n & 8) != 0) {
            function1 = seek.2.INSTANCE;
        }
        apiVideoPlayerAnalytics.seek(f, f2, (Function0<Unit>)function0, (Function1<? super Exception, Unit>)function1);
    }

    public final void pause(float eventTime, @NotNull Function0<Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onError) {
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        this.unschedule();
        this.addEventAt(Event.PAUSE, eventTime);
        this.sendPing(this.buildPingPayload(), onSuccess, onError);
    }

    public static /* synthetic */ void pause$default(ApiVideoPlayerAnalytics apiVideoPlayerAnalytics, float f, Function0 function0, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            f = apiVideoPlayerAnalytics.currentTime;
        }
        if ((n & 2) != 0) {
            function0 = pause.1.INSTANCE;
        }
        if ((n & 4) != 0) {
            function1 = pause.2.INSTANCE;
        }
        apiVideoPlayerAnalytics.pause(f, (Function0<Unit>)function0, (Function1<? super Exception, Unit>)function1);
    }

    public final void destroy(float eventTime, @NotNull Function0<Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onError) {
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        this.unschedule();
        this.pause(eventTime, onSuccess, onError);
    }

    public static /* synthetic */ void destroy$default(ApiVideoPlayerAnalytics apiVideoPlayerAnalytics, float f, Function0 function0, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            f = apiVideoPlayerAnalytics.currentTime;
        }
        if ((n & 2) != 0) {
            function0 = destroy.1.INSTANCE;
        }
        if ((n & 4) != 0) {
            function1 = destroy.2.INSTANCE;
        }
        apiVideoPlayerAnalytics.destroy(f, (Function0<Unit>)function0, (Function1<? super Exception, Unit>)function1);
    }

    private final void addEventAt(Event eventName, float eventTime) {
        this.eventsStack.add(new PingEvent(null, eventName, Float.valueOf(eventTime), null, null, 25, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void schedule() {
        ApiVideoPlayerAnalytics apiVideoPlayerAnalytics = this;
        synchronized (apiVideoPlayerAnalytics) {
            boolean bl = false;
            if (this.timer == null) {
                void $this$schedule_u24lambda_u244_u24lambda_u243;
                Timer timer;
                Timer timer2 = timer = new Timer();
                ApiVideoPlayerAnalytics apiVideoPlayerAnalytics2 = this;
                boolean bl2 = false;
                $this$schedule_u24lambda_u244_u24lambda_u243.scheduleAtFixedRate(new TimerTask(this){
                    final /* synthetic */ ApiVideoPlayerAnalytics this$0;
                    {
                        this.this$0 = apiVideoPlayerAnalytics;
                    }

                    public void run() {
                        TimerTask $this$schedule_u24lambda_u244_u24lambda_u243_u24lambda_u242 = this;
                        boolean bl = false;
                        ApiVideoPlayerAnalytics.sendPing$default(this.this$0, ApiVideoPlayerAnalytics.access$buildPingPayload(this.this$0), null, null, 6, null);
                    }
                }, 10000L, 10000L);
                apiVideoPlayerAnalytics2.timer = timer;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unschedule() {
        ApiVideoPlayerAnalytics apiVideoPlayerAnalytics = this;
        synchronized (apiVideoPlayerAnalytics) {
            boolean bl = false;
            Timer timer = this.timer;
            if (timer != null) {
                timer.cancel();
            }
            this.timer = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final PlaybackPingMessage buildPingPayload() {
        Session session;
        switch (WhenMappings.$EnumSwitchMapping$0[this.options.getVideoInfo().getVideoType().ordinal()]) {
            case 1: {
                Session.Companion companion = Session.Companion;
                String string = this.sessionId;
                String string2 = this.loadedAt;
                String string3 = this.options.getVideoInfo().getVideoId();
                Map<String, String> map = this.options.getMetadata();
                session = companion.buildLiveStreamSession(string, string2, string3, "", map);
                break;
            }
            case 2: {
                Session.Companion companion = Session.Companion;
                String string = this.sessionId;
                String string2 = this.loadedAt;
                String string3 = this.options.getVideoInfo().getVideoId();
                Map<String, String> map = this.options.getMetadata();
                session = companion.buildVodSession(string, string2, string3, "", map);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Session session2 = session;
        return new PlaybackPingMessage(null, session2, this.eventsStack, 1, null);
    }

    private final void sendPing(PlaybackPingMessage payload, Function0<Unit> onSuccess, Function1<? super Exception, Unit> onError) {
        Function1<PlaybackPingMessage, Unit> function1 = this.options.getOnPing();
        if (function1 != null) {
            Function1<PlaybackPingMessage, Unit> it = function1;
            boolean bl = false;
            it.invoke((Object)payload);
        }
        RequestManager.INSTANCE.sendPing(this.options.getVideoInfo().getPingUrl(), payload, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this, onSuccess){
            final /* synthetic */ ApiVideoPlayerAnalytics this$0;
            final /* synthetic */ Function0<Unit> $onSuccess;
            {
                this.this$0 = $receiver;
                this.$onSuccess = $onSuccess;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.this$0.getSessionId$analytics_release() == null) {
                    this.this$0.setSessionId$analytics_release(it);
                }
                this.$onSuccess.invoke();
            }
        }), (Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>(onError){
            final /* synthetic */ Function1<Exception, Unit> $onError;
            {
                this.$onError = $onError;
                super(1);
            }

            public final void invoke(@NotNull Exception error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                this.$onError.invoke((Object)error);
            }
        }));
        this.eventsStack.clear();
    }

    static /* synthetic */ void sendPing$default(ApiVideoPlayerAnalytics apiVideoPlayerAnalytics, PlaybackPingMessage playbackPingMessage, Function0 function0, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = sendPing.1.INSTANCE;
        }
        if ((n & 4) != 0) {
            function1 = sendPing.2.INSTANCE;
        }
        apiVideoPlayerAnalytics.sendPing(playbackPingMessage, (Function0<Unit>)function0, (Function1<? super Exception, Unit>)function1);
    }

    public static final /* synthetic */ PlaybackPingMessage access$buildPingPayload(ApiVideoPlayerAnalytics $this) {
        return $this.buildPingPayload();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VideoType.values().length];
            try {
                nArray[VideoType.LIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoType.VOD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lvideo/api/player/analytics/ApiVideoPlayerAnalytics$Companion;", "", "()V", "PLAYBACK_PING_DELAY", "", "TAG", "", "analytics_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

