/*
 * Decompiled with CFR 0.152.
 */
package video.api.player.analytics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import video.api.player.analytics.Event;
import video.api.player.analytics.Options;
import video.api.player.analytics.PingEvent;
import video.api.player.analytics.PlaybackPingMessage;
import video.api.player.analytics.RequestManager;
import video.api.player.analytics.Session;
import video.api.player.analytics.Utils;
import video.api.player.analytics.VideoType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 -2\u00020\u0001:\u0001-B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\b\u0002\u0010\u001d\u001a\u00020\u0006J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\b\u0002\u0010\u001d\u001a\u00020\u0006J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\b\u0002\u0010\u001d\u001a\u00020\u0006J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\b\u0002\u0010\u001d\u001a\u00020\u0006J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\b\u0002\u0010\u001d\u001a\u00020\u0006J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\b\u0002\u0010\u001d\u001a\u00020\u0006J\b\u0010&\u001a\u00020\u001aH\u0002J\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0006J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010+\u001a\u00020\u001fH\u0002J\b\u0010,\u001a\u00020\u001aH\u0002R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u0010@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lvideo/api/player/analytics/ApiVideoPlayerAnalytics;", "", "options", "Lvideo/api/player/analytics/Options;", "(Lvideo/api/player/analytics/Options;)V", "value", "", "currentTime", "getCurrentTime", "()F", "setCurrentTime", "(F)V", "eventsStack", "", "Lvideo/api/player/analytics/PingEvent;", "loadedAt", "", "sessionId", "getSessionId$analytics_release", "()Ljava/lang/String;", "setSessionId$analytics_release", "(Ljava/lang/String;)V", "timer", "Ljava/util/Timer;", "addEventAt", "Ljava/util/concurrent/Future;", "", "eventName", "Lvideo/api/player/analytics/Event;", "eventTime", "buildPingPayload", "Lvideo/api/player/analytics/PlaybackPingMessage;", "destroy", "end", "pause", "play", "ready", "resume", "schedule", "seek", "from", "to", "sendPing", "payload", "unschedule", "Companion", "analytics_release"})
public final class ApiVideoPlayerAnalytics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Options options;
    @NotNull
    private final List<PingEvent> eventsStack;
    @Nullable
    private Timer timer;
    @NotNull
    private final String loadedAt;
    @Nullable
    private String sessionId;
    private float currentTime;
    private static final long PLAYBACK_PING_DELAY = 10000L;

    public ApiVideoPlayerAnalytics(@NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
        this.eventsStack = new ArrayList();
        this.loadedAt = Utils.INSTANCE.nowUtcToIso();
    }

    @Nullable
    public final String getSessionId$analytics_release() {
        return this.sessionId;
    }

    public final void setSessionId$analytics_release(@Nullable String value) {
        String string = value;
        if (string != null) {
            String session = string;
            boolean bl = false;
            Function1<String, Unit> function1 = this.options.getOnSessionIdReceived();
            if (function1 != null) {
                Function1<String, Unit> it = function1;
                boolean bl2 = false;
                it.invoke((Object)session);
            }
            this.sessionId = session;
        }
    }

    public final float getCurrentTime() {
        return this.currentTime;
    }

    public final void setCurrentTime(float value) {
        if (!(value >= 0.0f)) {
            throw new IOException(Intrinsics.stringPlus((String)"currentTime must be positive value but currentTime=", (Object)Float.valueOf(value)));
        }
        this.currentTime = value;
    }

    @NotNull
    public final Future<Unit> play(float eventTime) {
        this.schedule();
        return this.addEventAt(Event.PLAY, eventTime);
    }

    public static /* synthetic */ Future play$default(ApiVideoPlayerAnalytics apiVideoPlayerAnalytics, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = apiVideoPlayerAnalytics.currentTime;
        }
        return apiVideoPlayerAnalytics.play(f);
    }

    @NotNull
    public final Future<Unit> resume(float eventTime) {
        this.schedule();
        return this.addEventAt(Event.RESUME, eventTime);
    }

    public static /* synthetic */ Future resume$default(ApiVideoPlayerAnalytics apiVideoPlayerAnalytics, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = apiVideoPlayerAnalytics.currentTime;
        }
        return apiVideoPlayerAnalytics.resume(f);
    }

    @NotNull
    public final Future<Unit> ready(float eventTime) {
        this.addEventAt(Event.READY, eventTime);
        return this.sendPing(this.buildPingPayload());
    }

    public static /* synthetic */ Future ready$default(ApiVideoPlayerAnalytics apiVideoPlayerAnalytics, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = apiVideoPlayerAnalytics.currentTime;
        }
        return apiVideoPlayerAnalytics.ready(f);
    }

    @NotNull
    public final Future<Unit> end(float eventTime) {
        this.unschedule();
        this.addEventAt(Event.END, eventTime);
        return this.sendPing(this.buildPingPayload());
    }

    public static /* synthetic */ Future end$default(ApiVideoPlayerAnalytics apiVideoPlayerAnalytics, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = apiVideoPlayerAnalytics.currentTime;
        }
        return apiVideoPlayerAnalytics.end(f);
    }

    @NotNull
    public final Future<Unit> seek(float from, float to) {
        if (from >= 0.0f && to >= 0.0f) {
            this.eventsStack.add(new PingEvent(null, from < to ? Event.SEEK_FORWARD : Event.SEEK_BACKWARD, null, Float.valueOf(from), Float.valueOf(to), 5, null));
            CompletableFuture<Unit> completableFuture = CompletableFuture.completedFuture(Unit.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(Unit)");
            return completableFuture;
        }
        throw new IOException("from and to must be positive value but from=" + from + " to=" + to);
    }

    @NotNull
    public final Future<Unit> pause(float eventTime) {
        this.unschedule();
        this.addEventAt(Event.PAUSE, eventTime);
        return this.sendPing(this.buildPingPayload());
    }

    public static /* synthetic */ Future pause$default(ApiVideoPlayerAnalytics apiVideoPlayerAnalytics, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = apiVideoPlayerAnalytics.currentTime;
        }
        return apiVideoPlayerAnalytics.pause(f);
    }

    @NotNull
    public final Future<Unit> destroy(float eventTime) {
        this.unschedule();
        return this.pause(eventTime);
    }

    public static /* synthetic */ Future destroy$default(ApiVideoPlayerAnalytics apiVideoPlayerAnalytics, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = apiVideoPlayerAnalytics.currentTime;
        }
        return apiVideoPlayerAnalytics.destroy(f);
    }

    private final Future<Unit> addEventAt(Event eventName, float eventTime) {
        this.eventsStack.add(new PingEvent(null, eventName, Float.valueOf(eventTime), null, null, 25, null));
        CompletableFuture<Unit> completableFuture = CompletableFuture.completedFuture(Unit.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(Unit)");
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void schedule() {
        ApiVideoPlayerAnalytics apiVideoPlayerAnalytics = this;
        synchronized (apiVideoPlayerAnalytics) {
            boolean bl = false;
            if (this.timer == null) {
                void $this$schedule_u24lambda_u2d4_u24lambda_u2d3;
                Timer timer;
                Timer timer2 = timer = new Timer();
                ApiVideoPlayerAnalytics apiVideoPlayerAnalytics2 = this;
                boolean bl2 = false;
                $this$schedule_u24lambda_u2d4_u24lambda_u2d3.scheduleAtFixedRate(new TimerTask(this){
                    final /* synthetic */ ApiVideoPlayerAnalytics this$0;
                    {
                        this.this$0 = apiVideoPlayerAnalytics;
                    }

                    public void run() {
                        TimerTask $this$schedule_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2 = this;
                        boolean bl = false;
                        ApiVideoPlayerAnalytics.access$sendPing(this.this$0, ApiVideoPlayerAnalytics.access$buildPingPayload(this.this$0));
                    }
                }, 10000L, 10000L);
                apiVideoPlayerAnalytics2.timer = timer;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unschedule() {
        ApiVideoPlayerAnalytics apiVideoPlayerAnalytics = this;
        synchronized (apiVideoPlayerAnalytics) {
            boolean bl = false;
            Timer timer = this.timer;
            if (timer != null) {
                timer.cancel();
            }
            this.timer = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final PlaybackPingMessage buildPingPayload() {
        Session session;
        switch (WhenMappings.$EnumSwitchMapping$0[this.options.getVideoInfo().getVideoType().ordinal()]) {
            case 1: {
                Session.Companion companion = Session.Companion;
                String string = this.sessionId;
                String string2 = this.loadedAt;
                String string3 = this.options.getVideoInfo().getVideoId();
                Map<String, String> map = this.options.getMetadata();
                session = companion.buildLiveStreamSession(string, string2, string3, "", map);
                break;
            }
            case 2: {
                Session.Companion companion = Session.Companion;
                String string = this.sessionId;
                String string2 = this.loadedAt;
                String string3 = this.options.getVideoInfo().getVideoId();
                Map<String, String> map = this.options.getMetadata();
                session = companion.buildVodSession(string, string2, string3, "", map);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Session session2 = session;
        return new PlaybackPingMessage(null, session2, this.eventsStack, 1, null);
    }

    private final Future<Unit> sendPing(PlaybackPingMessage payload) {
        Function1<PlaybackPingMessage, Unit> function1 = this.options.getOnPing();
        if (function1 != null) {
            Function1<PlaybackPingMessage, Unit> it = function1;
            boolean bl = false;
            it.invoke((Object)payload);
        }
        CompletableFuture<Unit> future = new CompletableFuture<Unit>();
        RequestManager.INSTANCE.sendPing(this.options.getVideoInfo().getPingUrl(), payload, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this, future){
            final /* synthetic */ ApiVideoPlayerAnalytics this$0;
            final /* synthetic */ CompletableFuture<Unit> $future;
            {
                this.this$0 = $receiver;
                this.$future = $future;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.this$0.getSessionId$analytics_release() == null) {
                    this.this$0.setSessionId$analytics_release(it);
                }
                this.$future.complete(Unit.INSTANCE);
            }
        }), (Function1<? super Exception, Unit>)((Function1)new Function1<Exception, Unit>(future){
            final /* synthetic */ CompletableFuture<Unit> $future;
            {
                this.$future = $future;
                super(1);
            }

            public final void invoke(@NotNull Exception error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                this.$future.completeExceptionally(error);
            }
        }));
        this.eventsStack.clear();
        return future;
    }

    public static final /* synthetic */ Future access$sendPing(ApiVideoPlayerAnalytics $this, PlaybackPingMessage payload) {
        return $this.sendPing(payload);
    }

    public static final /* synthetic */ PlaybackPingMessage access$buildPingPayload(ApiVideoPlayerAnalytics $this) {
        return $this.buildPingPayload();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lvideo/api/player/analytics/ApiVideoPlayerAnalytics$Companion;", "", "()V", "PLAYBACK_PING_DELAY", "", "analytics_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VideoType.values().length];
            nArray[VideoType.LIVE.ordinal()] = 1;
            nArray[VideoType.VOD.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

