/*
 * Decompiled with CFR 0.152.
 */
package video.api.player.analytics;

import android.content.Context;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.Volley;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import video.api.player.analytics.ApiVideoPlayerAnalytics;
import video.api.player.analytics.Event;
import video.api.player.analytics.Options;
import video.api.player.analytics.PingEvent;
import video.api.player.analytics.PlaybackPingMessage;
import video.api.player.analytics.Session;
import video.api.player.analytics.StringRequest;
import video.api.player.analytics.Utils;
import video.api.player.analytics.VideoType;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 52\u00020\u0001:\u00015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\bH\u0002J\b\u0010&\u001a\u00020'H\u0002J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\"0!2\b\b\u0002\u0010%\u001a\u00020\bJ\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\"0!2\b\b\u0002\u0010%\u001a\u00020\bJ\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\"0!2\b\b\u0002\u0010%\u001a\u00020\bJ\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\"0!2\b\b\u0002\u0010%\u001a\u00020\bJ\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\"0!2\b\b\u0002\u0010%\u001a\u00020\bJ\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\"0!2\b\b\u0002\u0010%\u001a\u00020\bJ\b\u0010.\u001a\u00020\"H\u0002J\u001c\u0010/\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020\bJ\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u00103\u001a\u00020'H\u0002J\b\u00104\u001a\u00020\"H\u0002R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0019\u001a\u0004\u0018\u00010\u00162\b\u0010\u0007\u001a\u0004\u0018\u00010\u0016@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lvideo/api/player/analytics/ApiVideoPlayerAnalytics;", "", "context", "Landroid/content/Context;", "options", "Lvideo/api/player/analytics/Options;", "(Landroid/content/Context;Lvideo/api/player/analytics/Options;)V", "value", "", "currentTime", "getCurrentTime", "()F", "setCurrentTime", "(F)V", "eventsStack", "", "Lvideo/api/player/analytics/PingEvent;", "json", "Lkotlinx/serialization/json/Json;", "getJson$annotations", "()V", "loadedAt", "", "queue", "Lcom/android/volley/RequestQueue;", "sessionId", "getSessionId$analytics_release", "()Ljava/lang/String;", "setSessionId$analytics_release", "(Ljava/lang/String;)V", "timer", "Ljava/util/Timer;", "addEventAt", "Ljava/util/concurrent/Future;", "", "eventName", "Lvideo/api/player/analytics/Event;", "eventTime", "buildPingPayload", "Lvideo/api/player/analytics/PlaybackPingMessage;", "destroy", "end", "pause", "play", "ready", "resume", "schedule", "seek", "from", "to", "sendPing", "payload", "unschedule", "Companion", "analytics_release"})
public final class ApiVideoPlayerAnalytics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Options options;
    @NotNull
    private final Json json;
    @NotNull
    private final List<PingEvent> eventsStack;
    @Nullable
    private Timer timer;
    @NotNull
    private final String loadedAt;
    @Nullable
    private String sessionId;
    @NotNull
    private final RequestQueue queue;
    private float currentTime;
    private static final long PLAYBACK_PING_DELAY = 10000L;

    /*
     * WARNING - void declaration
     */
    public ApiVideoPlayerAnalytics(@NotNull Context context, @NotNull Options options) {
        void $this$queue_u24lambda_u2d2;
        RequestQueue requestQueue;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
        this.json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
        this.eventsStack = new ArrayList();
        this.loadedAt = Utils.INSTANCE.nowUtcToIso();
        RequestQueue requestQueue2 = requestQueue = Volley.newRequestQueue((Context)context);
        ApiVideoPlayerAnalytics apiVideoPlayerAnalytics = this;
        boolean bl = false;
        $this$queue_u24lambda_u2d2.start();
        RequestQueue requestQueue3 = requestQueue;
        Intrinsics.checkNotNullExpressionValue((Object)requestQueue3, (String)"newRequestQueue(context)\u2026y {\n        start()\n    }");
        apiVideoPlayerAnalytics.queue = requestQueue3;
    }

    private static /* synthetic */ void getJson$annotations() {
    }

    @Nullable
    public final String getSessionId$analytics_release() {
        return this.sessionId;
    }

    public final void setSessionId$analytics_release(@Nullable String value) {
        String string = value;
        if (string != null) {
            String session = string;
            boolean bl = false;
            Function1<String, Unit> function1 = this.options.getOnSessionIdReceived();
            if (function1 != null) {
                Function1<String, Unit> it = function1;
                boolean bl2 = false;
                it.invoke((Object)session);
            }
            this.sessionId = session;
        }
    }

    public final float getCurrentTime() {
        return this.currentTime;
    }

    public final void setCurrentTime(float value) {
        if (!(value >= 0.0f)) {
            throw new IOException(Intrinsics.stringPlus((String)"currentTime must be positive value but currentTime=", (Object)Float.valueOf(value)));
        }
        this.currentTime = value;
    }

    @NotNull
    public final Future<Unit> play(float eventTime) {
        this.schedule();
        return this.addEventAt(Event.PLAY, eventTime);
    }

    public static /* synthetic */ Future play$default(ApiVideoPlayerAnalytics apiVideoPlayerAnalytics, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = apiVideoPlayerAnalytics.currentTime;
        }
        return apiVideoPlayerAnalytics.play(f);
    }

    @NotNull
    public final Future<Unit> resume(float eventTime) {
        this.schedule();
        return this.addEventAt(Event.RESUME, eventTime);
    }

    public static /* synthetic */ Future resume$default(ApiVideoPlayerAnalytics apiVideoPlayerAnalytics, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = apiVideoPlayerAnalytics.currentTime;
        }
        return apiVideoPlayerAnalytics.resume(f);
    }

    @NotNull
    public final Future<Unit> ready(float eventTime) {
        this.addEventAt(Event.READY, eventTime);
        return this.sendPing(this.buildPingPayload());
    }

    public static /* synthetic */ Future ready$default(ApiVideoPlayerAnalytics apiVideoPlayerAnalytics, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = apiVideoPlayerAnalytics.currentTime;
        }
        return apiVideoPlayerAnalytics.ready(f);
    }

    @NotNull
    public final Future<Unit> end(float eventTime) {
        this.unschedule();
        this.addEventAt(Event.END, eventTime);
        return this.sendPing(this.buildPingPayload());
    }

    public static /* synthetic */ Future end$default(ApiVideoPlayerAnalytics apiVideoPlayerAnalytics, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = apiVideoPlayerAnalytics.currentTime;
        }
        return apiVideoPlayerAnalytics.end(f);
    }

    @NotNull
    public final Future<Unit> seek(float from, float to) {
        if (from >= 0.0f && to >= 0.0f) {
            this.eventsStack.add(new PingEvent(null, from < to ? Event.SEEK_FORWARD : Event.SEEK_BACKWARD, null, Float.valueOf(from), Float.valueOf(to), 5, null));
            CompletableFuture<Unit> completableFuture = CompletableFuture.completedFuture(Unit.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(Unit)");
            return completableFuture;
        }
        throw new IOException("from and to must be positive value but from=" + from + " to=" + to);
    }

    @NotNull
    public final Future<Unit> pause(float eventTime) {
        this.unschedule();
        this.addEventAt(Event.PAUSE, eventTime);
        return this.sendPing(this.buildPingPayload());
    }

    public static /* synthetic */ Future pause$default(ApiVideoPlayerAnalytics apiVideoPlayerAnalytics, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = apiVideoPlayerAnalytics.currentTime;
        }
        return apiVideoPlayerAnalytics.pause(f);
    }

    @NotNull
    public final Future<Unit> destroy(float eventTime) {
        this.unschedule();
        return this.pause(eventTime);
    }

    public static /* synthetic */ Future destroy$default(ApiVideoPlayerAnalytics apiVideoPlayerAnalytics, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = apiVideoPlayerAnalytics.currentTime;
        }
        return apiVideoPlayerAnalytics.destroy(f);
    }

    private final Future<Unit> addEventAt(Event eventName, float eventTime) {
        this.eventsStack.add(new PingEvent(null, eventName, Float.valueOf(eventTime), null, null, 25, null));
        CompletableFuture<Unit> completableFuture = CompletableFuture.completedFuture(Unit.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(Unit)");
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void schedule() {
        synchronized (this) {
            boolean bl = false;
            if (this.timer == null) {
                void $this$schedule_u24lambda_u2d5_u24lambda_u2d4;
                Timer timer;
                Timer timer2 = timer = new Timer();
                ApiVideoPlayerAnalytics apiVideoPlayerAnalytics = this;
                boolean bl2 = false;
                $this$schedule_u24lambda_u2d5_u24lambda_u2d4.scheduleAtFixedRate(new TimerTask(this){
                    final /* synthetic */ ApiVideoPlayerAnalytics this$0;
                    {
                        this.this$0 = apiVideoPlayerAnalytics;
                    }

                    public void run() {
                        TimerTask $this$schedule_u24lambda_u2d5_u24lambda_u2d4_u24lambda_u2d3 = this;
                        boolean bl = false;
                        ApiVideoPlayerAnalytics.access$sendPing(this.this$0, ApiVideoPlayerAnalytics.access$buildPingPayload(this.this$0));
                    }
                }, 10000L, 10000L);
                apiVideoPlayerAnalytics.timer = timer;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unschedule() {
        synchronized (this) {
            boolean bl = false;
            Timer timer = this.timer;
            if (timer != null) {
                timer.cancel();
            }
            this.timer = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    private final PlaybackPingMessage buildPingPayload() {
        Session session;
        switch (WhenMappings.$EnumSwitchMapping$0[this.options.getVideoInfo().getVideoType().ordinal()]) {
            case 1: {
                Session.Companion companion = Session.Companion;
                String string = this.sessionId;
                String string2 = this.loadedAt;
                String string3 = this.options.getVideoInfo().getVideoId();
                Map<String, String> map = this.options.getMetadata();
                session = companion.buildLiveStreamSession(string, string2, string3, "", map);
                break;
            }
            case 2: {
                Session.Companion companion = Session.Companion;
                String string = this.sessionId;
                String string2 = this.loadedAt;
                String string3 = this.options.getVideoInfo().getVideoId();
                Map<String, String> map = this.options.getMetadata();
                session = companion.buildVodSession(string, string2, string3, "", map);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Session session2 = session;
        return new PlaybackPingMessage(null, session2, this.eventsStack, 1, null);
    }

    private final Future<Unit> sendPing(PlaybackPingMessage payload) {
        Function1<PlaybackPingMessage, Unit> function1 = this.options.getOnPing();
        if (function1 != null) {
            Function1<PlaybackPingMessage, Unit> it = function1;
            boolean bl = false;
            it.invoke((Object)payload);
        }
        CompletableFuture future = new CompletableFuture();
        StringFormat $this$encodeToString$iv = (StringFormat)this.json;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(PlaybackPingMessage.class));
        boolean $i$f$cast = false;
        StringRequest stringRequest = new StringRequest(1, this.options.getVideoInfo().getPingUrl(), $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)payload), (Response.Listener<String>)((Response.Listener)arg_0 -> ApiVideoPlayerAnalytics.sendPing$lambda-9(future, this, arg_0)), arg_0 -> ApiVideoPlayerAnalytics.sendPing$lambda-10(future, arg_0));
        this.eventsStack.clear();
        this.queue.add((Request)stringRequest);
        return future;
    }

    private static final void sendPing$lambda-9(CompletableFuture $future, ApiVideoPlayerAnalytics this$0, String response) {
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
            JsonObject jsonResponse = JsonElementKt.getJsonObject((JsonElement)Json.Default.parseToJsonElement(response));
            JsonElement jsonElement = (JsonElement)jsonResponse.get((Object)"session");
            if (jsonElement != null) {
                JsonElement it = jsonElement;
                boolean bl = false;
                String sessionId = JsonElementKt.getJsonPrimitive((JsonElement)it).getContent();
                if (this$0.getSessionId$analytics_release() == null) {
                    this$0.setSessionId$analytics_release(sessionId);
                }
            }
            $future.complete(Unit.INSTANCE);
        }
        catch (Exception e) {
            $future.completeExceptionally(e);
        }
    }

    private static final void sendPing$lambda-10(CompletableFuture $future, VolleyError error) {
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        $future.completeExceptionally((Throwable)error);
    }

    public static final /* synthetic */ Future access$sendPing(ApiVideoPlayerAnalytics $this, PlaybackPingMessage payload) {
        return $this.sendPing(payload);
    }

    public static final /* synthetic */ PlaybackPingMessage access$buildPingPayload(ApiVideoPlayerAnalytics $this) {
        return $this.buildPingPayload();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lvideo/api/player/analytics/ApiVideoPlayerAnalytics$Companion;", "", "()V", "PLAYBACK_PING_DELAY", "", "analytics_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VideoType.values().length];
            nArray[VideoType.LIVE.ordinal()] = 1;
            nArray[VideoType.VOD.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

