/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import video.api.client.api.models.DeepObject;

public class WebhooksCreationPayload
implements Serializable,
DeepObject {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_EVENTS = "events";
    @SerializedName(value="events")
    private List<String> events = new ArrayList<String>();
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;

    public WebhooksCreationPayload events(List<String> events) {
        this.events = events;
        return this;
    }

    public WebhooksCreationPayload addEventsItem(String eventsItem) {
        this.events.add(eventsItem);
        return this;
    }

    @ApiModelProperty(example="[\"video.encoding.quality.completed\"]", required=true, value="A list of the webhooks that you are subscribing to. There are Currently four webhook options: * ```video.encoding.quality.completed```  Occurs when a new video is uploaded into your account, it will be encoded into several different HLS and mp4 qualities. When each version is encoded, your webhook will get a notification.  It will look like ```{ \\\"type\\\": \\\"video.encoding.quality.completed\\\", \\\"emittedAt\\\": \\\"2021-01-29T16:46:25.217+01:00\\\", \\\"videoId\\\": \\\"viXXXXXXXX\\\", \\\"encoding\\\": \\\"hls\\\", \\\"quality\\\": \\\"720p\\\"} ```. This request says that the 720p HLS encoding was completed. * ```live-stream.broadcast.started```  When a live stream begins broadcasting, the broadcasting parameter changes from false to true, and this webhook fires. * ```live-stream.broadcast.ended```  This event fires when a live stream has finished broadcasting. * ```video.source.recorded```  Occurs when a live stream is recorded and submitted for encoding.")
    public List<String> getEvents() {
        return this.events;
    }

    public void setEvents(List<String> events) {
        this.events = events;
    }

    public WebhooksCreationPayload url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="https://example.com/webhooks", required=true, value="The the url to which HTTP notifications are sent. It could be any http or https URL.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhooksCreationPayload webhooksCreationPayload = (WebhooksCreationPayload)o;
        return Objects.equals(this.events, webhooksCreationPayload.events) && Objects.equals(this.url, webhooksCreationPayload.url);
    }

    public int hashCode() {
        return Objects.hash(this.events, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebhooksCreationPayload {\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

